/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.WebSocketController;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.DashboardsReloadNeeded;
import com.dataiku.dip.server.notifications.backend.PongEvent;
import com.dataiku.dip.server.notifications.backend.ScenarioStateChangeEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectsListChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.AnyLoc;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontendSystemNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UIAuthService uiAuthService;
    static final String ANY_USER_BROADCAST_TYPE_WHITELIST = "|user-profile-picture-updated|";
    static final String ADMIN_BROADCAST_TYPE_FULL_WHITELIST = "|msg-all|spinnee-troll|spinnee-untroll|discussions-wizz|";
    static final String ADMIN_BROADCAST_TYPE_RESTRICTED_WHITELIST = "|msg-all|";
    private static Logger logger = Logger.getLogger((String)"dku.notifications.frontend");

    @Override
    public void init() {
        WebSocketController wsController = WebSocketController.getInstance();
        DSSEventListener toAllOnProject = evt -> {
            if (evt instanceof TaggableObjectsListChangedEvent) {
                wsController.broadcastToProjectUsers(evt, evt.getProjectKey());
            } else {
                wsController.broadcastToAllOnProject(evt, evt.getProjectKey());
            }
        };
        this.pubSub.subscribe("datasets-list-changed", toAllOnProject);
        this.pubSub.subscribe("recipes-list-changed", toAllOnProject);
        this.pubSub.subscribe("analyses-list-changed", toAllOnProject);
        this.pubSub.subscribe("tags-list-changed", toAllOnProject);
        this.pubSub.subscribe("scenario-state-change", evt -> {
            if (evt.state != ScenarioStateChangeEvent.State.DONE) {
                return;
            }
            this.broadcastRefreshDashboard(wsController, (ScenarioStateChangeEvent)evt);
        });
        boolean restrictEasterEggsEvenForAdmin = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().security.restrictEasterEggsEvenForAdmin;
        DSSEventListener forward = evt -> {
            String jsonMsg = evt.getNestedEvent().toString();
            String session = evt.getWebSocketSessionId();
            boolean loopback = evt.shouldLoopBack();
            String evtTypeToken = "|" + evt.getNestedEvent().get("type").getAsString() + "|";
            boolean isAllowedEvtType = ANY_USER_BROADCAST_TYPE_WHITELIST.contains(evtTypeToken);
            if (!isAllowedEvtType && evt.isAdmin()) {
                String adminWhiteList = restrictEasterEggsEvenForAdmin ? ADMIN_BROADCAST_TYPE_RESTRICTED_WHITELIST : ADMIN_BROADCAST_TYPE_FULL_WHITELIST;
                isAllowedEvtType = adminWhiteList.contains(evtTypeToken);
            }
            if (isAllowedEvtType) {
                wsController.broadcastToSession("broadcast", session, jsonMsg, loopback);
            } else {
                logger.warn((Object)("Invalid broadcast event type " + evtTypeToken + " for login " + evt.getUserLogin()));
            }
        };
        this.pubSub.subscribe("ui-broadcast", forward);
        DSSEventListener toUser = evt -> {
            logger.info((Object)("dispatch " + evt.getName()));
            wsController.broadcastToUser(evt, evt.getUserLogin());
        };
        this.pubSub.subscribe("update-notifications-count", toUser);
        this.pubSub.subscribe("achievement-unlocked", toUser);
        this.pubSub.subscribe("project-invitation-sent", toUser);
        this.pubSub.subscribe("workspace-invitation-sent", toUser);
        this.pubSub.subscribe("logout", toUser);
        this.pubSub.subscribe("login", toUser);
        this.pubSub.subscribe("session-expiration", toUser);
        this.pubSub.subscribe("watch-triggered", evt -> wsController.broadcastToSession(evt, evt.getWebSocketSessionId()));
        this.pubSub.subscribe("ping", evt -> wsController.broadcastToSession((DSSEvent)new PongEvent(), evt.getWebSocketSessionId()));
    }

    private void broadcastRefreshDashboard(WebSocketController wsController, ScenarioStateChangeEvent evt) {
        Set<AnyLoc> dashboards;
        Map<String, Object> additionalData = evt.getAdditionalData();
        Object o = additionalData.get("dashboards-reload-needed");
        if (o instanceof DashboardsReloadNeeded.DashboardsReloadNeededParams && !(dashboards = ((DashboardsReloadNeeded.DashboardsReloadNeededParams)o).dashboards).isEmpty()) {
            wsController.broadcastToAllOnProject((DSSEvent)new DashboardsReloadNeeded(dashboards), evt.getProjectKey());
        }
    }
}

