/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.output.ResplittableExtensibleFileOutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;

public class FSProviderOutput
implements Output,
CanListFilesWrittenTo {
    private FSProvider provider;
    private Partition partition;
    private int splitId;
    private int resplitFactor;
    private String outputFormatType;
    private FormatParams outputFormatParams;
    private Schema outputSchema;
    private WarningsContext warningsContext;
    private String basePath;
    private SerializedDataset.ReadWriteOptions readWriteOptions;
    private PartitioningScheme scheme;
    private String projectKey;
    private AuthCtx authCtx;

    public FSProviderOutput(AuthCtx authCtx, String projectKey, FSProvider provider, String basePath, Partition targetPartition, PartitioningScheme scheme, int splitId, int resplitFactor, String outputFormatType, FormatParams outputFormatParams, Schema outputSchema, WarningsContext warningsContext, SerializedDataset.ReadWriteOptions readWriteOptions) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.provider = provider;
        this.basePath = basePath;
        this.partition = targetPartition;
        this.scheme = scheme;
        this.splitId = splitId;
        this.resplitFactor = resplitFactor;
        this.outputFormatType = outputFormatType;
        this.outputFormatParams = outputFormatParams;
        this.outputSchema = outputSchema;
        this.warningsContext = warningsContext;
        this.readWriteOptions = readWriteOptions;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException {
        String outputDir = this.basePath;
        if (this.partition != null) {
            outputDir = FilePartitioner.computePartitionRelPathAsFolder(this.partition, this.scheme);
        }
        if (this.resplitFactor == 0) {
            this.resplitFactor = 1;
        }
        String compress = null;
        if (this.outputFormatParams instanceof CompressibleFormatParams) {
            compress = ((CompressibleFormatParams)this.outputFormatParams).compress;
        }
        return new ResplittableExtensibleFileOutputWriter<FSProvider>(this.authCtx, this.projectKey, this.provider, outputDir, this.splitId, this.resplitFactor, this.outputFormatType, this.outputFormatParams, this.outputSchema, this.warningsContext, writeMode, compress, this.readWriteOptions);
    }

    public List<String> list(OutputWriter writer) {
        return ((ResplittableExtensibleFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return ResplittableExtensibleFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.splitId);
    }
}

