/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.dss.aggregators.PercentilesAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.refine.expr.Evaluable;
import com.google.refine.grel.ast.VariableExpr;
import com.google.refine.udaf.UdafControlFunctionRegistry;
import com.google.refine.udaf.UdafUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;

public class AggregateToSQL {
    private final ColumnMapper colMapping;
    private final SQLDialect dialect;
    private final String projectkey;

    public AggregateToSQL(ColumnMapper colMapping, SQLDialect dialect, String projectKey) {
        this.colMapping = colMapping;
        this.dialect = dialect;
        this.projectkey = projectKey;
    }

    public String aggregateExpr(Aggregation aggr) {
        ColumnMapper.ExprType exprType = AggregateToSQL.getExprType(aggr);
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        if (aggr.column == null) {
            if (aggr.function == Aggregation.Function.COUNT) {
                return "COUNT(*)";
            }
            throw this.unsupportedAggregation(aggr.function);
        }
        switch (aggr.function) {
            case COUNTD: {
                return String.format("COUNT(DISTINCT %s)", this.colMapping.getAs((String)aggr.column, (ColumnMapper.ExprType)exprType).expr);
            }
            case OBJECT_MIN: {
                return String.format("MIN(%s)", this.colMapping.getAs((String)aggr.column, (ColumnMapper.ExprType)exprType).expr);
            }
            case OBJECT_MAX: {
                return String.format("MAX(%s)", this.colMapping.getAs((String)aggr.column, (ColumnMapper.ExprType)exprType).expr);
            }
            case CUSTOM: {
                return String.format("(%s)", this.rewriteColumns(aggr.customFunction));
            }
            case VARIANCE: 
            case VARIANCE_POPULATION: 
            case STDEV: 
            case STDEV_POPULATION: {
                QueryUtils.OperatorType operatorType = null;
                switch (aggr.function) {
                    case VARIANCE: {
                        operatorType = QueryUtils.OperatorType.VARIANCE_SAMP;
                        break;
                    }
                    case VARIANCE_POPULATION: {
                        operatorType = QueryUtils.OperatorType.VARIANCE_POP;
                        break;
                    }
                    case STDEV: {
                        operatorType = QueryUtils.OperatorType.STDDEV_SAMP;
                        break;
                    }
                    case STDEV_POPULATION: {
                        operatorType = QueryUtils.OperatorType.STDDEV_POP;
                    }
                }
                QueryUtils.AbstractOperator operator = this.dialect.getOperator(operatorType);
                if (operator != null) {
                    return operator.apply(new QueryAst.Expr[]{ebf.col((String)aggr.column).expr});
                }
                throw this.unsupportedAggregation(aggr.function);
            }
            case PERCENTILE: 
            case MEDIAN: {
                double percentile = aggr.function == Aggregation.Function.MEDIAN ? 50.0 : aggr.percentile;
                PercentilesAggregator.percentileValueCheck(percentile);
                QueryUtils.AbstractOperator operator = this.dialect.getOperator(QueryUtils.OperatorType.PERCENTILE_CONT);
                if (operator != null) {
                    return operator.apply(new QueryAst.Expr[]{ebf.col((String)aggr.column).expr, ebf.cst((Object)Double.valueOf((double)(percentile / 100.0))).expr});
                }
                throw this.unsupportedAggregation(aggr.function);
            }
            case AVG: {
                return String.format("AVG(%s + 0.0)", this.colMapping.getAs((String)aggr.column, (ColumnMapper.ExprType)exprType).expr);
            }
        }
        return String.format("%s(%s)", new Object[]{aggr.function, this.colMapping.getAs((String)aggr.column, (ColumnMapper.ExprType)exprType).expr});
    }

    private UnsupportedOperation unsupportedAggregation(Aggregation.Function function) {
        throw new UnsupportedOperation(String.format("The function %s is not yet available for your database", new Object[]{function}));
    }

    private static ColumnMapper.ExprType getExprType(Aggregation aggr) {
        if (aggr.type == AxisDef.Type.ALPHANUM) {
            return ColumnMapper.ExprType.STRING;
        }
        if (aggr.type == AxisDef.Type.DATE) {
            return ColumnMapper.ExprType.DATE;
        }
        return ColumnMapper.ExprType.NUMBER;
    }

    private String rewriteColumns(String request) {
        GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)this.getGrelQueryMappingWithAggregates(), UdafControlFunctionRegistry.getInstance());
        VariablesContext variablesContext = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(this.projectkey);
        Expression expression = new Expression(variablesContext.expand(request), UdafControlFunctionRegistry.getInstance());
        expression.setVariablesContext(variablesContext);
        ExpressionBuilder result = (ExpressionBuilder)translator.translateToQuery((Expression)expression, (boolean)true).result;
        return QuerySQLWriter.generateSafeSQL(this.dialect, result.expr);
    }

    private GrelToQueryMapping getGrelQueryMappingWithAggregates() {
        GrelToQueryMapping mapping = new GrelToQueryMapping(this.dialect);
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        Predicate<Evaluable[]> forbidNonNumericOnAggregations = args -> {
            if (((Evaluable[])args).length == 1 && args[0] instanceof VariableExpr && this.colMapping.get((String)((VariableExpr)args[0]).getName()).type != ColumnMapper.ExprType.NUMBER) {
                throw new UnsupportedOperation("Cannot aggregate on non numeric column");
            }
            return true;
        };
        mapping.withOp("avg", QueryUtils.OperatorType.AVG, args -> args).withOp("count", QueryUtils.OperatorType.COUNT).withOp("sum", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.SUM, forbidNonNumericOnAggregations)).withOp("stdev", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.STDDEV_SAMP, forbidNonNumericOnAggregations)).withOp("stdevp", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.STDDEV_POP, forbidNonNumericOnAggregations)).withOp("var", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.VARIANCE_SAMP, forbidNonNumericOnAggregations)).withOp("varp", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.VARIANCE_POP, forbidNonNumericOnAggregations)).withOp("min", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.MIN, UdafUtils::isMinMaxUdaf)).withOp("max", (Pair<QueryUtils.OperatorType, Predicate<Evaluable[]>>)new Pair((Object)QueryUtils.OperatorType.MAX, UdafUtils::isMinMaxUdaf)).withOp("countd", QueryUtils.OperatorType.COUNT, args -> {
            ExpressionBuilder[] expressionBuilderArray;
            if (args.length == 1) {
                ExpressionBuilder[] expressionBuilderArray2 = new ExpressionBuilder[1];
                expressionBuilderArray = expressionBuilderArray2;
                expressionBuilderArray2[0] = args[0].distinct();
            } else {
                expressionBuilderArray = args;
            }
            return expressionBuilderArray;
        }).withOp("median", QueryUtils.OperatorType.PERCENTILE_CONT, args -> {
            if (args.length == 1) {
                return new ExpressionBuilder[]{args[0], ebf.cst(0.5)};
            }
            throw new UnsupportedOperation("The median function should only take one parameter.");
        }).withOp("percentile", QueryUtils.OperatorType.PERCENTILE_CONT, args -> {
            Object percentileArg;
            if (args.length == 2 && args[1].expr instanceof QueryAst.ConstExpr && (percentileArg = ((QueryAst.ConstExpr)args[1].expr).value) instanceof Number) {
                double percentile = ((Number)percentileArg).doubleValue();
                PercentilesAggregator.percentileValueCheck(percentile);
                return new ExpressionBuilder[]{args[0], ebf.cst(percentile / 100.0)};
            }
            throw new UnsupportedOperation("The percentile function is incorrectly configured, please refer to the formula glossary.");
        });
        return mapping;
    }

    public List<SelectQueryBuilder.SelectRef> deduplicateAndAddToQuery(List<Aggregation> aggrs, SelectExistingRef selectExistingRef) {
        LinkedList<Object> beforeDeduplication = new LinkedList<Object>();
        beforeDeduplication.add(new Pair((Object)new Aggregation(Aggregation.Function.COUNT), (Object)false));
        beforeDeduplication.addAll(this.mapNonNullCountToAggregations(aggrs));
        ArrayList<SelectQueryBuilder.SelectRef> selectedAggregates = new ArrayList<SelectQueryBuilder.SelectRef>();
        for (Pair pair : beforeDeduplication) {
            Aggregation baseAggr = (Aggregation)pair.first;
            SelectQueryBuilder.SelectRef existingRef = null;
            for (int j = 0; j < selectedAggregates.size(); ++j) {
                Aggregation currentAggr = (Aggregation)((Pair)beforeDeduplication.get((int)j)).first;
                SelectQueryBuilder.SelectRef currentRef = (SelectQueryBuilder.SelectRef)selectedAggregates.get(j);
                if (baseAggr.function != currentAggr.function || !StringUtils.equals((String)baseAggr.column, (String)currentAggr.column) || !Objects.equals(baseAggr.customFunction, currentAggr.customFunction) || !Objects.equals(baseAggr.percentile, currentAggr.percentile) || ((Boolean)pair.second).booleanValue()) continue;
                existingRef = currentRef;
            }
            if (existingRef == null) {
                String alias = QueryUtils.safeRandomIdentifier("dku_aggr_");
                existingRef = selectExistingRef.selectRef(baseAggr, alias);
            }
            existingRef.countOfPrevious = (Boolean)pair.second;
            selectedAggregates.add(existingRef);
        }
        return selectedAggregates;
    }

    public LinkedList<Pair<Aggregation, Boolean>> mapNonNullCountToAggregations(List<Aggregation> aggregations) {
        LinkedList<Pair<Aggregation, Boolean>> pairs = new LinkedList<Pair<Aggregation, Boolean>>();
        for (Aggregation agg : aggregations) {
            pairs.add((Pair<Aggregation, Boolean>)new Pair((Object)agg, (Object)false));
            if (Aggregation.Function.CUSTOM.equals((Object)agg.function)) continue;
            pairs.add((Pair<Aggregation, Boolean>)new Pair((Object)new Aggregation(Aggregation.Function.COUNT, agg.column, agg.type), (Object)true));
        }
        return pairs;
    }

    public static interface SelectExistingRef {
        public SelectQueryBuilder.SelectRef selectRef(Aggregation var1, String var2);
    }
}

