/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf.series;

import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.google.common.base.Preconditions;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;

public class BaseSeries {
    private final ChartTextSource title;
    private final int id;
    private Color color = Color.fromHTML("#000000");
    private boolean smoothed;
    private STMarkerStyle.Enum marker = STMarkerStyle.NONE;

    protected BaseSeries(int id, ChartTextSource title) {
        this.title = (ChartTextSource)Preconditions.checkNotNull((Object)title);
        this.id = id;
    }

    public STMarkerStyle.Enum getMarker() {
        return this.marker;
    }

    public void setMarker(STMarkerStyle.Enum marker) {
        this.marker = marker;
    }

    public void setMarker(int idx) {
        this.marker = BaseSeries.getMarkerFromIdx(idx);
    }

    private static STMarkerStyle.Enum getMarkerFromIdx(int idx) {
        STMarkerStyle.Enum[] vals = new STMarkerStyle.Enum[]{STMarkerStyle.TRIANGLE, STMarkerStyle.X, STMarkerStyle.DIAMOND, STMarkerStyle.STAR, STMarkerStyle.CIRCLE, STMarkerStyle.PLUS, STMarkerStyle.DASH};
        return vals[idx % vals.length];
    }

    public int getId() {
        return this.id;
    }

    public ChartTextSource getTitle() {
        return this.title;
    }

    public boolean isSmoothed() {
        return this.smoothed;
    }

    public void setSmoothed(boolean smoothed) {
        this.smoothed = smoothed;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = (Color)Preconditions.checkNotNull((Object)color);
    }
}

