/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.populardatasets.MostUsedDatasetInfos;
import com.dataiku.dip.populardatasets.PopularDatasetsProcessing;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class PopularDatasetsCacheService {
    private static final String DIRECTORY = "most-used-datasets";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<MostUsedDatasetInfos> getMostUsedDatasetLastResult() throws IOException {
        File listFile = PopularDatasetsCacheService.getListFile();
        PopularDatasetsCacheService popularDatasetsCacheService = this;
        synchronized (popularDatasetsCacheService) {
            if (!listFile.exists()) {
                return null;
            }
            return ((ListWrapper)JSON.parseFile((File)PopularDatasetsCacheService.getListFile(), ListWrapper.class)).mostUsedDatasetInfos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PopularDatasetsProcessing.RunMetadata getLastResultMetadata() throws IOException {
        File metaFile = PopularDatasetsCacheService.getMetaFile();
        PopularDatasetsCacheService popularDatasetsCacheService = this;
        synchronized (popularDatasetsCacheService) {
            if (!metaFile.exists()) {
                return null;
            }
            return (PopularDatasetsProcessing.RunMetadata)JSON.parseFile((File)metaFile, PopularDatasetsProcessing.RunMetadata.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PopularDatasetsProcessing.RunMetadata> getMetadataHistory() throws IOException {
        File historyFile = PopularDatasetsCacheService.getMetaHistoryFile();
        PopularDatasetsCacheService popularDatasetsCacheService = this;
        synchronized (popularDatasetsCacheService) {
            if (!historyFile.exists()) {
                return new ArrayList<PopularDatasetsProcessing.RunMetadata>();
            }
            return (List)JSON.parseFile((File)historyFile, (TypeToken)new TypeToken<List<PopularDatasetsProcessing.RunMetadata>>(){});
        }
    }

    public boolean saveOutput(PopularDatasetsProcessing.Output output) throws IOException {
        File tempListFile = DKUApp.getFile((String[])new String[]{DIRECTORY, "temp-list.json"});
        File tempMetaFile = DKUApp.getFile((String[])new String[]{DIRECTORY, "temp-meta.json"});
        File listFile = PopularDatasetsCacheService.getListFile();
        File metaFile = PopularDatasetsCacheService.getMetaFile();
        File historyFile = PopularDatasetsCacheService.getMetaHistoryFile();
        DKUFileUtils.mkdirsParent((File)tempListFile);
        JSON.prettyToFile((Object)new ListWrapper(output.mostUsedDatasetInfos), (File)tempListFile);
        JSON.prettyToFile((Object)output.lastRunMetadata, (File)tempMetaFile);
        if (listFile.exists()) {
            DKUFileUtils.forceDelete((File)listFile);
        }
        if (metaFile.exists()) {
            DKUFileUtils.forceDelete((File)metaFile);
        }
        List<PopularDatasetsProcessing.RunMetadata> history = this.getMetadataHistory();
        if (historyFile.exists()) {
            DKUFileUtils.forceDelete((File)historyFile);
        }
        history.add(output.lastRunMetadata);
        JSON.prettyToFile(history, (File)historyFile);
        return tempListFile.renameTo(listFile) && tempMetaFile.renameTo(metaFile);
    }

    private static File getListFile() {
        return DKUApp.getFile((String[])new String[]{DIRECTORY, "last-list.json"});
    }

    private static File getMetaFile() {
        return DKUApp.getFile((String[])new String[]{DIRECTORY, "last-meta.json"});
    }

    private static File getMetaHistoryFile() {
        return DKUApp.getFile((String[])new String[]{DIRECTORY, "history-meta.json"});
    }

    private static class ListWrapper {
        public List<MostUsedDatasetInfos> mostUsedDatasetInfos;

        public ListWrapper(List<MostUsedDatasetInfos> mostUsedDatasetInfos) {
            this.mostUsedDatasetInfos = mostUsedDatasetInfos;
        }
    }
}

