/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeMeta;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.gson.JsonObject;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ImpalaRecipeCreator
extends SingleOutputDatasetRecipeCreator {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;

    public ImpalaRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) throws Exception {
        ImpalaRecipeMeta.ImpalaRecipeParams params = new ImpalaRecipeMeta.ImpalaRecipeParams();
        return RecipeCreationUtils.setupImpalaParams(this.authCtx, sr.projectKey, params);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        String prefill;
        String firstInputRef = recipe.getInputsForRole((String)"main").get((int)0).ref;
        SerializedDataset inputSD = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstInputRef));
        Dataset inputDS = Dataset.fromSerialized(inputSD);
        ImpalaSQLDialect dialect = new ImpalaSQLDialect();
        String string = prefill = data.has("script") ? data.get("script").getAsString() : null;
        if (StringUtils.isNotBlank((String)prefill)) {
            return prefill;
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        SerializedProject project = this.projectsDAO.getMandatory(recipe.projectKey);
        switch (project.settings.relocationSettings.sqlLikeRecipesInitializationMode) {
            case DATASET_REFERENCES: {
                SQLUtils.SQLTable sqlTable = DatasetUtils.getUnresolvedTable(inputSD, (SQLDialect)dialect, true, false);
                Object virtualName = "${tbl:" + firstInputRef + "}";
                if (StringUtils.isNotBlank((String)sqlTable.getSchemaNullIfBlank())) {
                    virtualName = "${db:" + firstInputRef + "}." + (String)virtualName;
                }
                query.from(new QueryAst.TableVariableReference((String)virtualName, "This variable contains the table name for input dataset " + firstInputRef));
                break;
            }
            case VARIABILIZED_TABLE_REFERENCES: {
                SQLUtils.SQLTable sqlTable = DatasetUtils.getUnresolvedTable(inputSD, (SQLDialect)dialect, true, false);
                query.from(sqlTable, null);
                break;
            }
            case RESOLVED_TABLE_REFERENCES: {
                SQLUtils.SQLTable sqlTable = DatasetUtils.getResolvedTable(inputSD, (SQLDialect)dialect, true, false);
                query.from(sqlTable, null);
                break;
            }
        }
        if (inputDS.getPartitioningSchema() != null && inputDS.getPartitioningSchema().isPartitioned()) {
            Set partitioningColumns = inputDS.getPartitioningSchema().getDimensionNamesSet();
            for (SchemaColumn column : inputDS.getSchema().getColumns()) {
                if (partitioningColumns.contains(column.getName())) continue;
                query.select(column.getName());
            }
        }
        Object script = query.toSQL(dialect);
        PartitioningScheme partitioning = inputDS.getPartitioningSchema();
        if (partitioning != null && partitioning.getDimensionNames().size() > 0) {
            script = (String)script + "\nWHERE ${DKU_PARTITION_FILTER_" + inputDS.getName() + "}";
        }
        return script;
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        SerializedRecipe.RecipeOutput oldOutput = recipe.getOutputsForRole("main").get(0);
        SerializedDataset oldDataset = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.resolveSmart(recipe.projectKey, oldOutput.ref));
        ManagedDatasetsHelper.copySchema(this.authCtx, Dataset.fromSerialized(oldDataset).getSchema(), outputDataset);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new Error("Unreachable");
    }
}

