/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.shell;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.code.AbstractCodeBasedRecipeStatusComputer;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.shell.ShellRecipeHelper;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ShellScriptRecipeStatusComputer
extends AbstractCodeBasedRecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GenericRecipesValidationService validationService;

    public ShellScriptRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        CodeBasedRecipeStatus ret;
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        RecipeRunnableSubgraph subgraph = null;
        if (request != null) {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            try (Transaction t = this.transactionService.beginRead();){
                FlowGraph graph = new FlowGraph();
                FlowRecipe fr = graph.buildSingleRecipe(this.recipe);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, fr, request.targetPartitionSpec);
            }
            subgraph = subgraphCallable.call_NT();
        }
        RecipeRunnableSubgraph fakeSubgraphForVariables = null;
        try (Transaction t = this.transactionService.beginRead();){
            ret = this.fastStatusIgnorePartitions(authCtx);
            if (request != null) {
                this.addVariablesSubstitutionWithoutCheck(authCtx, ret, subgraph);
                JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
                fakeSubgraphForVariables = (RecipeRunnableSubgraph)activity.getSubgraph();
            }
        }
        if (fakeSubgraphForVariables != null) {
            Map<String, String> variables = new ShellRecipeHelper().getVariablesForFlow_NT(authCtx, fakeSubgraphForVariables, this.recipe);
            ret.mergeSubstitutionVariables(variables);
        }
        ret.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_CODE_NOT_CHECKED, "Code of shell recipes is not checked - only global consistency checks were performed");
        return ret;
    }

    @Override
    public CodeBasedRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        CodeBasedRecipeStatus ret = new CodeBasedRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("USER_CODE", "User code", "SHELL", "Shell", "Shell (user code)");
        return ret;
    }
}

