/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.spark;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeCreator;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeRunner;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeStatusComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class SparkRRecipeMeta
extends RecipeMeta
implements MetaWithSelectableCodeEnv {
    public static final SparkRRecipeMeta META = new SparkRRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return SparkRRecipeParams.class;
    }

    @Override
    public String getType() {
        return "sparkr";
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new SparkRRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new SparkRRecipeRunner(activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new SparkRRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return RecipeDesc.newDescWithNaryAny("Spark R", null);
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withUserCode().withSpark();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.R;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        SparkRRecipeParams params = sr.getParamsAs(SparkRRecipeParams.class);
        return params.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        SparkRRecipeParams params = sr.getParamsAs(SparkRRecipeParams.class);
        params.sparkConfig = config;
        return payload;
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        SparkRRecipeParams params = sr.getParamsAs(SparkRRecipeParams.class);
        params.executionEngine = executionEngine;
        return payload;
    }

    public static class SparkRRecipeParams
    extends AbstractSparkRecipeParams
    implements ParamsWithSelectableCodeEnv {
        public SparkRRecipeMode recipeMode = SparkRRecipeMode.SPARKR;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.R, this.envSelection.envName, CodeEnvModel.EnvUsage.RECIPE, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static enum SparkRRecipeMode {
        SPARKR,
        SPARKLYR;

    }
}

