/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.SQLComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.sql.BigQueryUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLServerSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSQLQueryLikeRecipeRunner
implements AbortableRecipeRunner {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected VariablesService variablesService;
    protected boolean sqlQueryIsCommentFree = false;
    protected boolean sqlQueryMayContainUnionOrSelect = true;
    protected boolean needExecutionPlan = true;
    protected String mainConnection;
    protected JobActivity activity;
    protected volatile boolean abortNotified;
    private Statement currentStatement;
    protected boolean runTerminated;
    protected final String recipeProjectKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.sql");

    public AbstractSQLQueryLikeRecipeRunner(String recipeProjectKey) {
        this.recipeProjectKey = recipeProjectKey;
    }

    protected String finalizeSql(String sql, SQLDialect dialect) {
        if (dialect instanceof SQLServerSQLDialect && sql.toLowerCase().startsWith("merge into ")) {
            return sql + "\n;\n";
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCancellableStatement(SQLConnectionProvider.SQLConnectionWrapper conn, Statement statement, String sql) throws SQLException {
        AbstractSQLQueryLikeRecipeRunner abstractSQLQueryLikeRecipeRunner;
        logger.info((Object)"Executing statement: ");
        logger.info((Object)sql);
        AbstractSQLQueryLikeRecipeRunner abstractSQLQueryLikeRecipeRunner2 = this;
        synchronized (abstractSQLQueryLikeRecipeRunner2) {
            if (this.abortNotified) {
                throw new ActivityAbortedException();
            }
            if (this.currentStatement != null) {
                throw new RuntimeException("This is a bug: concurrent statement are not possible !");
            }
            this.currentStatement = statement;
        }
        ComputeResourceUsage cru = SQLComputeResourceUsage.forSQLQuery(conn, sql);
        try {
            cru.reportStartNoFail();
            if (StringUtils.isBlank((String)sql.trim())) {
                logger.info((Object)"Statement is blank, was probably a lone comment");
            } else {
                statement.execute(this.finalizeSql(sql, conn.getDialect()));
            }
            logger.info((Object)"Statement done");
        }
        finally {
            cru.reportCompleteNoFail();
            abstractSQLQueryLikeRecipeRunner = this;
            synchronized (abstractSQLQueryLikeRecipeRunner) {
                this.currentStatement = null;
            }
        }
        abstractSQLQueryLikeRecipeRunner = this;
        synchronized (abstractSQLQueryLikeRecipeRunner) {
            if (this.abortNotified) {
                throw new RuntimeException("Activity aborted !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        Statement statementToCancel;
        AbstractSQLQueryLikeRecipeRunner abstractSQLQueryLikeRecipeRunner = this;
        synchronized (abstractSQLQueryLikeRecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            statementToCancel = this.currentStatement;
        }
        if (statementToCancel != null) {
            try {
                logger.info((Object)"Cancelling SQL statement...");
                statementToCancel.cancel();
                logger.info((Object)"SQL statement cancelled!");
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to cancel SQL statement", (Throwable)e);
            }
        }
        abstractSQLQueryLikeRecipeRunner = this;
        synchronized (abstractSQLQueryLikeRecipeRunner) {
            long start = System.currentTimeMillis();
            while (!this.runTerminated) {
                long end = System.currentTimeMillis();
                if (end - start > 15000L) {
                    logger.error((Object)"The recipe cannot be properly stopped. It'll be killed abruptly with the JEK.");
                    return;
                }
                logger.info((Object)"Waiting for the recipe to terminate...");
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.info((Object)"Recipe terminated!");
        }
    }

    protected List<String> getWriteStatements(SQLDialect dialect, Dataset dataset, boolean preWriteStatements) {
        String statements;
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        String string = statements = preWriteStatements ? config.customPreWriteStatements : config.customPostWriteStatements;
        if (!StringUtils.isBlank((String)statements)) {
            Splitter splitter = dialect.getSplitter();
            return Arrays.asList(splitter.split(statements));
        }
        return ImmutableList.of();
    }

    private void executeWriteStatements(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, boolean preWriteStatements) throws SQLException {
        for (String preWriteStatement : this.getWriteStatements(connData.getDialect(), dataset, preWriteStatements)) {
            SQLUtils.safeExec(conn, preWriteStatement, true);
        }
    }

    protected void executePreWriteStatements(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset) throws SQLException {
        this.executeWriteStatements(connData, conn, dataset, true);
    }

    protected void executePostWriteStatements(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset) throws SQLException {
        this.executeWriteStatements(connData, conn, dataset, false);
    }

    protected void runRegularToDataset(AuthCtx authCtx, Dataset targetDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData, QueryBunch unexpandedQueryBunch, VariablesExpansionLoopItemsIterable veLoopIterable) throws Exception {
        logger.info((Object)"Running as regular stream mode");
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        ProcessorOutput out = SQLQueryRecipeUtils.buildProcessorOutput(authCtx, targetDataset, targetPartition, this.activity, (ColumnFactory)cf, (RowFactory)rf);
        DateTimeZone assumedTz = DateTimeZone.UTC;
        if (DatasetInspector.isSQL(targetDataset)) {
            String timezoneId = targetDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(targetDataset.getProjectKey()).getAssumedJavaTzForUnknownTz();
            assumedTz = timezoneId != null && timezoneId.length() > 0 ? DateTimeZone.forID((String)timezoneId) : DateTimeZone.getDefault();
        }
        RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)this.activity.getSubgraph();
        ConnectionTasksService.SQLQueryRun runningSQL = this.activity.runningThings.addSQL(connData.getConnection().name);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, this.recipeProjectKey);){
            SQLDialect dialect = connData.getDialect();
            for (JsonObject jo : veLoopIterable) {
                AutoCloseable withLevel = DynamicLevelsStack.withLevel(jo);
                try {
                    Statement stmt;
                    QueryBunch queryBunch = unexpandedQueryBunch.clone();
                    queryBunch.query = SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipeProjectKey, subgraph, queryBunch.query, dialect, false);
                    queryBunch.preQueries = queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipeProjectKey, subgraph, q, dialect, false)).collect(Collectors.toList());
                    queryBunch.postQueries = queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, this.recipeProjectKey, subgraph, q, dialect, false)).collect(Collectors.toList());
                    for (String query : queryBunch.preQueries) {
                        stmt = conn.createStatement();
                        try {
                            this.executeCancellableStatement(conn, stmt, query);
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                    if ("BigQuery".equals(targetDataset.getType())) {
                        AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = targetDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(targetDataset.getProjectKey());
                        SQLConnectionProvider.SQLConnectionData targetDatasetConnData = SQLConnectionProvider.getConnectionData_NT(authCtx, targetDataset.getProjectKey(), outputConfig.getConnection());
                        BigQueryUtils.checkPartitioningConsistency(authCtx, targetDatasetConnData.getConnection(), outputConfig, targetDataset.getPartitioningSchema());
                    }
                    this.safePrintExecutionPlan(queryBunch.query, connData, dialect, conn, true);
                    try (Statement stmt2 = SQLUtils.getProperlyStreamableStatement(connData, conn);){
                        this.executeCancellableStatement(conn, stmt2, queryBunch.query);
                        ResultSet rs2 = stmt2.getResultSet();
                        ResultSetMetaData meta = rs2.getMetaData();
                        ArrayList<Column> columns = new ArrayList<Column>();
                        ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
                        for (SchemaColumn sc : targetDataset.getSchema().getColumns()) {
                            columns.add(cf.column(sc.getName()));
                            schemaColumns.add(new SchemaColumn(sc).withTimestampNoTzAsDate(sc.timestampNoTzAsDate && !targetDataset.isManaged()));
                        }
                        logger.info((Object)"Starting to emit output data");
                        int rows = 0;
                        while (rs2.next()) {
                            if (this.abortNotified) {
                                throw new ActivityAbortedException();
                            }
                            SQLQueryRecipeUtils.streamSingleRow(connData, columns, schemaColumns, rs2, meta, (RowFactory)rf, out, assumedTz, true);
                            if (++rows % 10000 != 0) continue;
                            logger.infoV("Emitted %d rows", new Object[]{rows});
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Query failed", (Throwable)e);
                        throw e;
                    }
                    for (String query : queryBunch.postQueries) {
                        stmt = conn.createStatement();
                        try {
                            this.executeCancellableStatement(conn, stmt, query);
                        }
                        finally {
                            if (stmt == null) continue;
                            stmt.close();
                        }
                    }
                }
                finally {
                    if (withLevel == null) continue;
                    withLevel.close();
                }
            }
            out.lastRowEmitted();
            if (dialect.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Query failed", (Throwable)e);
            throw e;
        }
        finally {
            runningSQL.doneOn = System.currentTimeMillis();
        }
    }

    protected void initializeTargetTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, Partition targetPartition, Dataset outputDataset, FlowRecipe recipe, InfoMessage.InfoMessages messages) throws Exception {
        Output.WriteMode wm = recipe.getModel().getSingleOutput("main").getWriteMode();
        dialect.prepareTableForWriting(authCtx, connData, conn, wm, outputDataset, targetPartition, false, messages);
    }

    protected void safePrintExecutionPlan(String sqlQuery, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, SQLConnectionProvider.SQLConnectionWrapper conn, boolean rollbackOnFailure) {
        if (!this.needExecutionPlan) {
            logger.info((Object)"Execution plan is not requested");
            return;
        }
        try {
            if (connData.getType() != ConnectionUtils.SQLConnectionType.JDBC && connData.getType() != ConnectionUtils.SQLConnectionType.BIGQUERY) {
                ExecutionPlanService eps = new ExecutionPlanService();
                ExecutionPlanService.ExecutionPlan ep = eps.getExecutionPlan(conn, connData, sqlQuery);
                logger.info((Object)("Execution plan: \n" + String.valueOf(ep)));
            } else {
                logger.info((Object)("Execution plan not implemented for " + String.valueOf((Object)connData.getType())));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Could not print execution plan", (Throwable)e);
            try {
                if (rollbackOnFailure && dialect.supportsCommitAndRollback()) {
                    conn.rollback();
                }
            }
            catch (Exception e2) {
                logger.warn((Object)"Failed to rollback after execution plan failure", (Throwable)e2);
            }
        }
    }
}

