/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.download;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.download.DownloadRecipeCreator;
import com.dataiku.dip.recipes.download.DownloadRecipeGeneratorEvaluator;
import com.dataiku.dip.recipes.download.DownloadRecipeParams;
import com.dataiku.dip.recipes.download.DownloadRecipeRunner;
import com.dataiku.dip.recipes.download.DownloadRecipeSource;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class DownloadRecipeMeta
extends RecipeMeta
implements IPluginifiedHolderMeta {
    public static final DownloadRecipeMeta META = new DownloadRecipeMeta();

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return DownloadRecipeParams.class;
    }

    @Override
    public String getType() {
        return "download";
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.NONE;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new DownloadRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return null;
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return RecipeMeta.defaultStatusComputer("DSS", "DSS", "STREAM", "Stream", "DSS");
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        RecipeDesc desc = new RecipeDesc("download", null);
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredFolder("main", ""));
        desc.copiable = false;
        String secondaryRoleLabel = ts.translate(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET", "Parameters dataset", new Object[0]);
        RecipeDesc.IORoleDef secondaryRole = new RecipeDesc.IORoleDef("veloop", secondaryRoleLabel).withEditable(false, false);
        secondaryRole.arity = RecipeDesc.IOArity.NARY;
        secondaryRole.description = ts.translate(lang, "RECIPE.SHAKER.DESC.VELOOP_DATASET.HELP", "This input is added for 'dynamic repeat' recipes.\nEdit the recipe parameters dataset to change it.", new Object[0]);
        desc.inputRoles.add(secondaryRole);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags();
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new DownloadRecipeCreator(authCtx, this, true);
    }

    @Override
    public boolean isGenerator() {
        return true;
    }

    @Override
    public GeneratorEvaluator getGeneratorEvaluator(SerializedRecipe serializedRecipe) {
        return new DownloadRecipeGeneratorEvaluator(serializedRecipe);
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        DownloadRecipeParams params = (DownloadRecipeParams)serializedRecipe.params;
        HashSet<String> res = new HashSet<String>();
        for (DownloadRecipeSource source : params.sources) {
            String co2 = source.getConnection();
            if (co2 == null || co2.isEmpty()) continue;
            res.add(co2);
        }
        return res;
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, @Nullable String payload, Map<String, String> replacements) {
        DownloadRecipeParams params = (DownloadRecipeParams)serializedRecipe.params;
        for (DownloadRecipeSource source : params.sources) {
            String co2 = source.getConnection();
            if (co2 == null) continue;
            String target = replacements.get(co2);
            if (target == null) {
                throw ErrorContext.iaef((String)"Did not find connection to remap in recipe %s: %s", (Object)serializedRecipe.name, (Object[])new Object[]{co2});
            }
            source.setConnection(target);
        }
        return null;
    }

    @Override
    public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
        ArrayList components = Lists.newArrayList();
        if (object instanceof SerializedRecipe) {
            DownloadRecipeParams params = ((SerializedRecipe)object).getParamsAs(DownloadRecipeParams.class);
            for (DownloadRecipeSource source : params.sources) {
                components.add(new IPluginifiedHolderMeta.Pluginifiable("fsProvider", source.providerType, source.params));
            }
        }
        return components;
    }
}

