/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.recipes.fromapp.AppRecipeParams;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class AppAsRecipeInstanceDetector
implements SanityCheckDetectorBase {
    private static final int DEFAULT_INSTANCE_COUNT_THRESHOLD_FOR_WARNING = 10;
    private static final HrefContext HREF_CONTEXT = new HrefContext("");
    private final AppsService appsService;
    private final ProjectsDAO projectsDAO;
    private final RecipesDAO recipesDAO;
    private final TransactionService transactionService;
    private final int instanceCountThresholdForWarning;

    @Autowired
    public AppAsRecipeInstanceDetector(AppsService appsService, ProjectsDAO projectsDAO, RecipesDAO recipesDAO, TransactionService transactionService) {
        this.appsService = appsService;
        this.projectsDAO = projectsDAO;
        this.transactionService = transactionService;
        this.recipesDAO = recipesDAO;
        this.instanceCountThresholdForWarning = 10;
    }

    public AppAsRecipeInstanceDetector(AppsService appsService, ProjectsDAO projectsDAO, RecipesDAO recipesDAO, TransactionService transactionService, int instanceCountThresholdForWarning) {
        this.appsService = appsService;
        this.projectsDAO = projectsDAO;
        this.transactionService = transactionService;
        this.recipesDAO = recipesDAO;
        this.instanceCountThresholdForWarning = instanceCountThresholdForWarning;
    }

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        try (Transaction transaction = this.transactionService.beginRead();){
            List<SerializedProject> projectList = this.projectsDAO.listAllUnsafe();
            Map<String, SerializedRecipe> recipeFullIdToRecipeMap = this.buildRecipeFullIdToRecipeMap(projectList);
            Map<String, List<SerializedProject>> instanceCreatorFullIdToInstancesMap = this.buildInstanceCreatorFullIdToInstancesMap(projectList, transaction);
            transaction.close();
            if (!exclusionList.contains(Codes.WARN_APP_AS_RECIPE_TOO_MANY_INSTANCES.getCode())) {
                this.generateTooManyInstancesWarnings(recipeFullIdToRecipeMap, instanceCreatorFullIdToInstancesMap).forEach(arg_0 -> ((SanityCheckInfoMessages)messages).addMessage(arg_0));
            }
            if (!exclusionList.contains(Codes.WARN_APP_AS_RECIPE_HAS_ORPHAN_INSTANCES.getCode())) {
                this.generateOrphanInstancesWarnings(recipeFullIdToRecipeMap, instanceCreatorFullIdToInstancesMap).forEach(arg_0 -> ((SanityCheckInfoMessages)messages).addMessage(arg_0));
            }
        }
        catch (InternalException e) {
            messages.addMessage(this.createFatalMessage(e.getCause()));
        }
        catch (Exception e) {
            messages.addMessage(this.createFatalMessage(e));
        }
        return messages;
    }

    private Map<String, List<SerializedProject>> buildInstanceCreatorFullIdToInstancesMap(List<SerializedProject> projectList, Transaction transaction) {
        return projectList.stream().filter(project -> this.isAppAsRecipeInstance((SerializedProject)project, transaction)).flatMap(project -> this.extractInstanceCreatorFullId((SerializedProject)project).map(instanceCreatorFullId -> Map.entry(instanceCreatorFullId, Stream.of(project))).stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Stream::concat)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Stream)entry.getValue()).collect(Collectors.toList())));
    }

    private Map<String, SerializedRecipe> buildRecipeFullIdToRecipeMap(List<SerializedProject> projectList) {
        return projectList.stream().flatMap(project -> this.buildRecipeFullIdToRecipeMap(project.projectKey).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, SerializedRecipe> buildRecipeFullIdToRecipeMap(String projectKey) {
        try {
            return this.recipesDAO.listUnsafe(projectKey).stream().filter(this::isAppAsRecipe).map(recipe -> Map.entry(recipe.getFullId(), recipe)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private boolean isAppAsRecipe(SerializedRecipe recipe) {
        return recipe.params instanceof AppRecipeParams;
    }

    private boolean isAppAsRecipeInstance(SerializedProject project, Transaction transaction) {
        try {
            return project.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && this.appsService.getManifestFromProjectUnsafe((TransactionRef)transaction, (String)project.projectKey).useAsRecipeSettings != null;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private Optional<String> extractInstanceCreatorFullId(SerializedProject project) {
        return Optional.ofNullable(project.appInstanceCreatorFullId).filter(StringUtils::isNotBlank).or(() -> Optional.of(project.name).filter(projectName -> projectName.startsWith("Execute recipe ")).map(projectName -> projectName.substring("Execute recipe ".length())).filter(StringUtils::isNotBlank));
    }

    private Stream<InfoMessage> generateTooManyInstancesWarnings(Map<String, SerializedRecipe> recipeFullIdToRecipeMap, Map<String, List<SerializedProject>> instanceCreatorFullIdToInstancesMap) {
        return recipeFullIdToRecipeMap.values().stream().flatMap(recipe -> {
            boolean isKeepInstanceEnabled = this.isKeepInstanceEnabled((SerializedRecipe)recipe);
            List<SerializedProject> appAsRecipeInstanceList = Optional.ofNullable((List)instanceCreatorFullIdToInstancesMap.get(recipe.getFullId())).orElse(List.of());
            if (isKeepInstanceEnabled && appAsRecipeInstanceList.size() >= this.instanceCountThresholdForWarning) {
                return Stream.of(this.generateTooManyInstancesForRecipeWithKeepInstanceEnabled((SerializedRecipe)recipe, appAsRecipeInstanceList));
            }
            if (!isKeepInstanceEnabled && !appAsRecipeInstanceList.isEmpty()) {
                return Stream.of(this.generateTooManyInstancesForRecipeWithKeepInstanceDisabled((SerializedRecipe)recipe, appAsRecipeInstanceList));
            }
            return Stream.empty();
        });
    }

    private Stream<InfoMessage> generateOrphanInstancesWarnings(Map<String, SerializedRecipe> recipeFullIdToRecipeMap, Map<String, List<SerializedProject>> instanceCreatorFullIdToInstancesMap) {
        return instanceCreatorFullIdToInstancesMap.entrySet().stream().flatMap(entry -> {
            String recipeFullId = (String)entry.getKey();
            List appAsRecipeInstanceList = (List)entry.getValue();
            return recipeFullIdToRecipeMap.containsKey(recipeFullId) ? Stream.empty() : Stream.of(this.generateOrphanInstancesWarning(recipeFullId, appAsRecipeInstanceList));
        });
    }

    private boolean isKeepInstanceEnabled(SerializedRecipe recipe) {
        return recipe.params instanceof AppRecipeParams && recipe.getParamsAs(AppRecipeParams.class).keepInstance;
    }

    private InfoMessage generateOrphanInstancesWarning(String recipeFullId, List<SerializedProject> appAsRecipeInstanceList) {
        String appAsRecipeInstancesDetails = appAsRecipeInstanceList.stream().map(project -> "<li>" + this.generateProjectLink((SerializedProject)project) + "</li>").collect(Collectors.joining());
        return new SanityCheckInfoMessages.InfoMessageWithExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_APP_AS_RECIPE_HAS_ORPHAN_INSTANCES, String.format("The App-As-Recipe '%s' was deleted but has orphan instances (<b>%s</b>). Consider deleting all of them.<p>", HtmlEscapers.htmlEscaper().escape(recipeFullId), appAsRecipeInstanceList.size()), "Instances:", String.format("<ul>%s</ul>", appAsRecipeInstancesDetails));
    }

    private InfoMessage generateTooManyInstancesForRecipeWithKeepInstanceEnabled(SerializedRecipe recipe, List<SerializedProject> appAsRecipeInstanceList) {
        String appAsRecipeInstancesDetails = appAsRecipeInstanceList.stream().map(project -> "<li>" + this.generateProjectLink((SerializedProject)project) + "</li>").collect(Collectors.joining());
        return new SanityCheckInfoMessages.InfoMessageWithExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_APP_AS_RECIPE_TOO_MANY_INSTANCES, String.format("The %s recipe has %s instances. Consider deleting some of them and/or disable the \"Keep Instance\" setting.", this.generateRecipeLink(recipe), appAsRecipeInstanceList.size()), "Instances:", String.format("<ul>%s</ul>", appAsRecipeInstancesDetails));
    }

    private InfoMessage generateTooManyInstancesForRecipeWithKeepInstanceDisabled(SerializedRecipe recipe, List<SerializedProject> appAsRecipeInstanceList) {
        String appAsRecipeInstancesDetails = appAsRecipeInstanceList.stream().map(project -> "<li>" + this.generateProjectLink((SerializedProject)project) + "</li>").collect(Collectors.joining());
        return new SanityCheckInfoMessages.InfoMessageWithExtraInfo(InfoMessage.Severity.WARNING, (InfoMessage.MessageCode)Codes.WARN_APP_AS_RECIPE_TOO_MANY_INSTANCES, String.format("The %s recipe has %s instances but the \"Keep Instance\" setting is disabled. Consider deleting those instances.", this.generateRecipeLink(recipe), appAsRecipeInstanceList.size()), "Instances:", String.format("<ul>%s", appAsRecipeInstancesDetails));
    }

    private String generateRecipeLink(SerializedRecipe recipe) {
        return this.generateHtmlLink(HREF_CONTEXT.recipe(recipe.projectKey, recipe.name), recipe.name);
    }

    private String generateProjectLink(SerializedProject project) {
        return this.generateHtmlLink(HREF_CONTEXT.project(project.projectKey), project.name);
    }

    private String generateHtmlLink(String url, String linkText) {
        return String.format("<a href=\"%s\">%s</a>", url, HtmlEscapers.htmlEscaper().escape(linkText));
    }

    static enum Codes implements InfoMessage.MessageCode
    {
        WARN_APP_AS_RECIPE_TOO_MANY_INSTANCES("Too many App-As-Recipe instances", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_APP_AS_RECIPE_HAS_ORPHAN_INSTANCES("App-As-Recipe instances has orphan instances", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    private static class InternalException
    extends RuntimeException {
        InternalException(Throwable throwable) {
            super(throwable);
        }
    }
}

