/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.proxymodelversions;

import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLInputValidator;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.savedmodels.proxymodels.AzureMLProxyConfiguration;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;

public class AzureMLProxyModelVersionConfiguration
extends ProxyModelVersionConfiguration {
    @SerializedName(value="endpoint_name")
    public String endpointName;

    @Override
    public void validate() {
        super.validate();
        AzureMLInputValidator.validateEndpointName(this.endpointName);
    }

    @Override
    public ProxyModelVersionConfiguration.ConsolidatedEndpointInfo getConsolidatedEndpointInfo_NT(AuthCtx authCtx) throws IOException, AzureMLUtils.AzureAuthenticationException, DKUSecurityException {
        AzureMLProxyConfiguration proxyModelConfiguration = (AzureMLProxyConfiguration)this.proxyModelConfiguration;
        if (proxyModelConfiguration == null) {
            throw new IllegalArgumentException("Missing proxyModelConfiguration");
        }
        if (StringUtils.isEmpty((CharSequence)this.endpointName) || StringUtils.isEmpty((CharSequence)proxyModelConfiguration.workspace) || StringUtils.isEmpty((CharSequence)proxyModelConfiguration.resourceGroup) || StringUtils.isEmpty((CharSequence)proxyModelConfiguration.subscriptionId)) {
            logger.warnV("Endpoint name, workspace, resource group and subscription should be defined (name: %s, workspace: %s, resource group: %s, subscription: %s)", new Object[]{this.endpointName, proxyModelConfiguration.workspace, proxyModelConfiguration.resourceGroup, proxyModelConfiguration.subscriptionId});
            return null;
        }
        return AzureMLUtils.getConsolidatedEndpointInfo_NT(authCtx, proxyModelConfiguration.connection, this.endpointName, proxyModelConfiguration.workspace, proxyModelConfiguration.resourceGroup, proxyModelConfiguration.subscriptionId, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
    }
}

