/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.LoadedPythonRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.scheduler.runnables.PythonRunnableMeta;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.reflect.TypeToken;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.JsonObject;
import com.dataiku.dss.shadelib.com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonRunnablesService
extends CustomPythonElementService<PythonRunnableDesc, LoadedPythonRunnable> {
    @Override
    public String getFolderName() {
        return "python-runnables";
    }

    @Override
    public String getPrefix() {
        return "runnable";
    }

    @Override
    protected String getCodeExtension(LoadedPythonRunnable desc) {
        return ".py";
    }

    @Override
    public Class<PythonRunnableDesc> getDescClass() {
        return PythonRunnableDesc.class;
    }

    @Override
    public Class<LoadedPythonRunnable> getLoadedDescClass() {
        return LoadedPythonRunnable.class;
    }

    @Override
    protected void removeElement(LoadedPythonRunnable desc) {
        DSSRunnableRegistry.deregister(desc.runnableType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "pyrunnable_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonRunnable load(String elementType, String pluginId, String elementId, File file) throws IOException {
        File ldFile;
        LoadedPythonRunnable loaded = new LoadedPythonRunnable(elementType, pluginId, elementId, (PythonRunnableDesc)JSON.parseFile((File)file, PythonRunnableDesc.class));
        if (StringUtils.isBlank((String)((PythonRunnableDesc)loaded.desc).longDescription) && (ldFile = new File(file.getParent(), "long-description.md")).isFile()) {
            ((PythonRunnableDesc)loaded.desc).longDescription = DKUFileUtils.readFileToStringUTF8((File)ldFile);
        }
        if (StringUtils.isBlank((String)((PythonRunnableDesc)loaded.desc).longDescription)) {
            ((PythonRunnableDesc)loaded.desc).longDescription = ((PythonRunnableDesc)loaded.desc).meta.description;
        }
        if (((PythonRunnableDesc)loaded.desc).meta.category == null) {
            ((PythonRunnableDesc)loaded.desc).meta.category = pluginId.replace('-', ' ');
        }
        if (((PythonRunnableDesc)loaded.desc).permissions.contains(null)) {
            ((PythonRunnableDesc)loaded.desc).permissions = ((PythonRunnableDesc)loaded.desc).permissions.stream().filter(Objects::nonNull).collect(Collectors.toList());
            JsonObject jsonObj = JsonParser.parseReader((Reader)new FileReader(file)).getAsJsonObject();
            List originalPermissions = (List)new Gson().fromJson(jsonObj.get("permissions"), new TypeToken<List<String>>(){}.getType());
            originalPermissions.removeAll(((PythonRunnableDesc)loaded.desc).permissions.stream().map(Enum::toString).collect(Collectors.toList()));
            throw new JsonSyntaxException("Invalid permission(s) '" + String.join((CharSequence)"', '", originalPermissions) + "' referenced in python runnable '" + pluginId + "'");
        }
        PythonRunnableMeta stepMeta = new PythonRunnableMeta(loaded, this);
        DSSRunnableRegistry.register(stepMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonRunnableDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonRunnablesService.this.getPrefix());
                }
                if (desc.adminParams != null) {
                    this.genericValidateParams(desc.adminParams, CustomPythonRunnablesService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (desc.macroRoles != null) {
                    for (DSSRunnableDesc.MacroRoleDef r : desc.macroRoles) {
                        if (r.type != null) continue;
                        this.withWarning("Unknown macro role");
                    }
                }
                return this.messages;
            }
        }.validate();
    }
}

