/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRegistry;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class Step {
    private static final int ID_MAX_LENGTH = 2000;
    public String id;
    public String type;
    public String name;
    public String description;
    private String comment;
    private boolean alwaysShowComment;
    public StepParams params;
    public boolean enabled = true;
    public RunConditionType runConditionType = RunConditionType.RUN_IF_STATUS_MATCH;
    public List<ReportItem.Outcome> runConditionStatuses = Lists.newArrayList((Object[])new ReportItem.Outcome[]{ReportItem.Outcome.SUCCESS, ReportItem.Outcome.WARNING});
    public String runConditionExpression;
    public int maxRetriesOnFail;
    public int delayBetweenRetries = 10;
    public boolean resetScenarioStatus = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.code-envs.languages");

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean getAlwaysShowComment() {
        return this.alwaysShowComment;
    }

    public StepParams getParams() {
        return this.params;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public RunConditionType getRunConditionType() {
        return this.runConditionType;
    }

    public List<ReportItem.Outcome> getRunConditionStatuses() {
        return this.runConditionStatuses;
    }

    public String getRunConditionExpression() {
        return this.runConditionExpression;
    }

    public int getMaxRetriesOnFail() {
        return this.maxRetriesOnFail;
    }

    public int getDelayBetweenRetries() {
        return this.delayBetweenRetries;
    }

    public boolean resetsScenarioStatus() {
        return this.resetScenarioStatus;
    }

    public <T extends StepParams> T getParamsAs(Class<T> clazz) {
        return (T)((StepParams)clazz.cast(this.params));
    }

    public Step withType(String type) {
        this.type = type;
        return this;
    }

    public static String ensureIdNotOversize(String id) {
        if (id != null && id.length() > 2000) {
            String md5 = DigestUtils.md5Hex((String)id);
            return id.substring(0, 2000 - md5.length() - 2) + "_" + md5;
        }
        return id;
    }

    public Step withId(String id) {
        this.id = Step.ensureIdNotOversize(id);
        return this;
    }

    public Step withName(String name) {
        this.name = name;
        return this;
    }

    public Step withDescription(String description) {
        this.description = description;
        return this;
    }

    public Step withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Step withAlwaysShowComment(boolean alwaysShowComment) {
        this.alwaysShowComment = alwaysShowComment;
        return this;
    }

    public Step withParams(StepParams params) {
        this.params = params;
        return this;
    }

    public Step withMaxRetriesOnFail(int numberRetries) {
        this.maxRetriesOnFail = numberRetries;
        return this;
    }

    public Step withDelayBetweenRetries(int delayBetweenRetries) {
        this.delayBetweenRetries = delayBetweenRetries;
        return this;
    }

    private void setDefaultRunConditions() {
        this.runConditionType = RunConditionType.RUN_IF_STATUS_MATCH;
        this.runConditionStatuses = Lists.newArrayList((Object[])new ReportItem.Outcome[]{ReportItem.Outcome.SUCCESS, ReportItem.Outcome.WARNING});
        this.runConditionExpression = null;
        this.resetScenarioStatus = false;
    }

    public Step disableRun() {
        this.enabled = false;
        return this;
    }

    public Step enableRun() {
        this.enabled = true;
        return this;
    }

    protected Step withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    protected Step withRunConditionType(RunConditionType runConditionType) {
        switch (runConditionType) {
            case DISABLED: {
                this.setDefaultRunConditions();
                this.enabled = false;
                break;
            }
            default: {
                this.runConditionType = runConditionType;
            }
        }
        return this;
    }

    protected Step withResetsScenarioStatus(boolean resetScenarioStatus) {
        this.resetScenarioStatus = resetScenarioStatus;
        return this;
    }

    protected Step withRunConditionExpression(String runConditionExpression) {
        this.runConditionExpression = runConditionExpression;
        return this;
    }

    protected Step withRunConditionStatuses(List<ReportItem.Outcome> runConditionStatuses) {
        this.runConditionStatuses = runConditionStatuses;
        return this;
    }

    public static void registerAdapter() {
        JSON.registerAdapter(Step.class, (Object)new JSON.Adapter<Step>(){

            public Step deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonParams;
                JsonElement jsonNumberRetries;
                JsonElement jsonDelayBetweenRetries;
                JsonElement jsonRunConditionType;
                JsonElement jsonRunConditionStatuses;
                JsonElement jsonResetScenarioStatus;
                JsonElement jsonRunConditionExpression;
                JsonElement jsonAlwaysShowComment;
                JsonElement jsonComment;
                JsonElement jsonEnabled;
                JsonElement jsonDescription;
                JsonElement jsonName;
                JsonObject jsonObj = json.getAsJsonObject();
                Step step = new Step();
                step = step.withType(jsonObj.get("type").getAsString());
                JsonElement jsonId = jsonObj.get("id");
                if (jsonId != null && !jsonId.isJsonNull()) {
                    step = step.withId(jsonId.getAsString());
                }
                if ((jsonName = jsonObj.get("name")) != null && !jsonName.isJsonNull()) {
                    step = step.withName(jsonName.getAsString());
                }
                if ((jsonDescription = jsonObj.get("description")) != null && !jsonDescription.isJsonNull()) {
                    step = step.withDescription(jsonDescription.getAsString());
                }
                if ((jsonEnabled = jsonObj.get("enabled")) != null && !jsonEnabled.isJsonNull()) {
                    step = step.withEnabled(jsonEnabled.getAsBoolean());
                }
                if ((jsonComment = jsonObj.get("comment")) != null && !jsonComment.isJsonNull()) {
                    step = step.withComment(jsonComment.getAsString());
                }
                if ((jsonAlwaysShowComment = jsonObj.get("alwaysShowComment")) != null && !jsonAlwaysShowComment.isJsonNull()) {
                    step = step.withAlwaysShowComment(jsonAlwaysShowComment.getAsBoolean());
                }
                if ((jsonRunConditionExpression = jsonObj.get("runConditionExpression")) != null && !jsonRunConditionExpression.isJsonNull()) {
                    step = step.withRunConditionExpression(jsonRunConditionExpression.getAsString());
                }
                if ((jsonResetScenarioStatus = jsonObj.get("resetScenarioStatus")) != null && !jsonResetScenarioStatus.isJsonNull()) {
                    step = step.withResetsScenarioStatus(jsonResetScenarioStatus.getAsBoolean());
                }
                if ((jsonRunConditionStatuses = jsonObj.get("runConditionStatuses")) != null && !jsonRunConditionStatuses.isJsonNull()) {
                    step = step.withRunConditionStatuses((List)ctx.deserialize(jsonRunConditionStatuses, new TypeToken<List<ReportItem.Outcome>>(){}.getType()));
                }
                if ((jsonRunConditionType = jsonObj.get("runConditionType")) != null && !jsonRunConditionType.isJsonNull()) {
                    step = step.withRunConditionType((RunConditionType)((Object)ctx.deserialize(jsonRunConditionType, RunConditionType.class)));
                }
                if ((jsonDelayBetweenRetries = jsonObj.get("delayBetweenRetries")) != null && !jsonDelayBetweenRetries.isJsonNull()) {
                    step = step.withDelayBetweenRetries(jsonDelayBetweenRetries.getAsInt());
                }
                if ((jsonNumberRetries = jsonObj.get("maxRetriesOnFail")) != null && !jsonNumberRetries.isJsonNull()) {
                    step = step.withMaxRetriesOnFail(jsonNumberRetries.getAsInt());
                }
                if ((jsonParams = jsonObj.get("params")) != null) {
                    try {
                        step = step.withParams((StepParams)ctx.deserialize(jsonParams, StepRegistry.getMeta(step).paramsClass()));
                    }
                    catch (JsonSyntaxException exception) {
                        if ("define_vars".equals(StepRegistry.getMeta(step).getType()) || "set_global_vars".equals(StepRegistry.getMeta(step).getType()) || "set_project_vars".equals(StepRegistry.getMeta(step).getType())) {
                            logger.error((Object)exception);
                            throw new JsonSyntaxException("The field 'Variables' does not contain a valid JSON object.\n(You may need to temporarily set 'Evaluated Variable' to OFF to see it.)", (Throwable)exception);
                        }
                        throw exception;
                    }
                }
                return step;
            }

            public JsonElement serialize(Step step, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                jsonObj.addProperty("id", step.getId());
                jsonObj.addProperty("type", step.getType());
                jsonObj.addProperty("name", step.getName());
                jsonObj.addProperty("description", step.getDescription());
                jsonObj.addProperty("enabled", Boolean.valueOf(step.getEnabled()));
                jsonObj.addProperty("comment", step.getComment());
                jsonObj.addProperty("alwaysShowComment", Boolean.valueOf(step.getAlwaysShowComment()));
                jsonObj.add("runConditionType", ctx.serialize((Object)step.getRunConditionType(), RunConditionType.class));
                jsonObj.add("runConditionStatuses", ctx.serialize(step.getRunConditionStatuses(), List.class));
                jsonObj.addProperty("runConditionExpression", step.getRunConditionExpression());
                jsonObj.addProperty("resetScenarioStatus", Boolean.valueOf(step.resetsScenarioStatus()));
                jsonObj.addProperty("delayBetweenRetries", (Number)step.getDelayBetweenRetries());
                jsonObj.addProperty("maxRetriesOnFail", (Number)step.getMaxRetriesOnFail());
                if (step.getParams() != null) {
                    jsonObj.add("params", ctx.serialize((Object)step.getParams(), StepRegistry.getMeta(step).paramsClass()));
                }
                return jsonObj;
            }
        });
    }

    public static enum RunConditionType {
        DISABLED,
        RUN_ALWAYS,
        RUN_IF_STATUS_MATCH,
        RUN_CONDITIONALLY;

    }
}

