/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class UIFSudoHelper {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.uif");

    public static String getCustomSudo() {
        return ApplicationConfigurator.getIniValue((String)"mus", (String)"custom_root_sudo");
    }

    public static List<String> getSudoCommand() {
        List args = null;
        String customSudo = ApplicationConfigurator.getIniValue((String)"mus", (String)"custom_root_sudo");
        args = customSudo != null ? (List)JSON.parse((String)customSudo, JSON.StringList.class) : Lists.newArrayList((Object[])new String[]{"sudo", "-n"});
        return args;
    }

    public static File getExecWrapperLocation() {
        String wrapperLocation = ApplicationConfigurator.getIniValue((String)"mus", (String)"exec_wrapper_location");
        File execWrapper = null;
        execWrapper = wrapperLocation != null ? new File(wrapperLocation) : new File(ApplicationConfigurator.getFile((String)"security"), "execwrapper.sh");
        return execWrapper;
    }

    public static void execWithSudoErrorSniffer(List<String> args, String baseCmd) throws IOException, InterruptedException {
        if (DKUtils.isOsWindows()) {
            return;
        }
        ProcessBuilder wrapper = new ProcessBuilder(args);
        logger.debug((Object)("exec " + baseCmd + ": " + StringUtils.join(wrapper.command(), (String)" ")));
        if (UIFSudoHelper.getCustomSudo() != null) {
            DKUtils.execAndLogThrows((ProcessBuilder)wrapper, (DKUtils.SmartLogTailBuilder)new DKUtils.SmartLogTailBuilder());
        } else {
            SudoErrorSniffer sudoErrorSniffer = new SudoErrorSniffer();
            new DKUtils.ExecBuilder().withProcessBuilder(wrapper).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)sudoErrorSniffer).withErrorConsumer((DKUtils.ExecSubscription)sudoErrorSniffer).withCompletionHandler((DKUtils.ExecCompletionHandler)sudoErrorSniffer).exec();
        }
    }

    private static class SudoErrorSniffer
    implements DKUtils.LineSubscription,
    DKUtils.ExecCompletionHandler {
        private final Pattern sudoErrorPattern = Pattern.compile("^\\s*sudo\\s*:(.*)$", 2);
        private final Pattern permsErrorPattern = Pattern.compile("^.* ERROR Unable to set access perms : (.*)$", 2);
        private String sudoError = null;
        private String permsError = null;

        private SudoErrorSniffer() {
        }

        public void close() throws IOException {
        }

        public void init(DKUtils.ExecBuilder builder) {
        }

        public void handle(int returnValue) throws IOException {
            if (returnValue != 0) {
                if (this.permsError != null) {
                    throw new IOException("Failed to set permissions : " + this.permsError);
                }
                if (this.sudoError != null) {
                    throw new IOException("sudo failed with return value " + returnValue + ": " + this.sudoError);
                }
                throw ProcessDiedException.getExceptionOnProcessDeath((String)"sudo failed", null, null, (boolean)false, (Integer)returnValue, null);
            }
        }

        public void handle(String line, boolean replace) throws IOException {
            if (line != null) {
                Matcher permsMatcher;
                Matcher sudoMatcher = this.sudoErrorPattern.matcher(line);
                if (sudoMatcher.matches()) {
                    this.sudoError = sudoMatcher.group(1);
                }
                if ((permsMatcher = this.permsErrorPattern.matcher(line)).matches()) {
                    this.permsError = permsMatcher.group(1);
                }
            }
        }
    }
}

