/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PluginCredentialRequestService {
    private static final String CLIENT_ID = "clientId";
    public static final String CLIENT_SECRET = "clientSecret";
    private static final String USE_PKCE = "usePkce";
    private static final String USE_GLOBAL_PROXY = "useGlobalProxy";
    private static final String AUTHORIZATION_ENDPOINT = "authorizationEndpoint";
    private static final String TOKEN_ENDPOINT = "tokenEndpoint";
    private static final String SCOPE = "scope";
    private static final String ENABLE_CACHE_PROPERTY = "dku.plugins.oauth.enableCache";
    @Autowired
    private RegularPluginsRegistryService pluginsRegistryService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private PluginParameterSetsService pluginPresetsService;

    public OAuth2Client buildOAuth2AuthorizationClient(PluginCredentialRequestInfo credentialRequestInfo) throws IOException, DKUSecurityException, URISyntaxException {
        OAuth2Client.Builder builder = new OAuth2Client.Builder();
        InstalledPluginDesc desc = this.pluginsRegistryService.getInstalledDesc(credentialRequestInfo.pluginId);
        PluginSettings pluginSettings = this.pluginsRegistryService.getSettings(credentialRequestInfo.pluginId);
        String authorizationEndpoint = "";
        String tokenEndpoint = "";
        String scope = "";
        for (PluginPreset preset : pluginSettings.presets) {
            JsonObject recipeConfig;
            LoadedParameterSet parameterSetDesc = (LoadedParameterSet)this.pluginPresetsService.getOrNull(preset.type);
            if (!credentialRequestInfo.presetId.equals(preset.name) || !credentialRequestInfo.paramSetId.equals(parameterSetDesc.id) || !(recipeConfig = preset.config).has(credentialRequestInfo.paramName)) continue;
            JsonObject paramAsJson = recipeConfig.getAsJsonObject(credentialRequestInfo.paramName);
            if (paramAsJson.has(CLIENT_ID)) {
                builder.clientId(paramAsJson.getAsJsonPrimitive(CLIENT_ID).getAsString());
            }
            if (recipeConfig.has(AUTHORIZATION_ENDPOINT)) {
                authorizationEndpoint = recipeConfig.get(AUTHORIZATION_ENDPOINT).getAsString();
            }
            if (recipeConfig.has(TOKEN_ENDPOINT)) {
                tokenEndpoint = recipeConfig.get(TOKEN_ENDPOINT).getAsString();
            }
            if (recipeConfig.has(SCOPE)) {
                scope = recipeConfig.get(SCOPE).getAsString();
            }
            if (paramAsJson.has(CLIENT_SECRET)) {
                String maybeEncryptedClientSecret = paramAsJson.getAsJsonPrimitive(CLIENT_SECRET).getAsString();
                builder.clientSecret(this.cryptoService.decryptIfEncrypted(maybeEncryptedClientSecret));
            }
            if (paramAsJson.has(USE_PKCE)) {
                builder.usePkce(paramAsJson.getAsJsonPrimitive(USE_PKCE).getAsBoolean());
            }
            if (!paramAsJson.has(USE_GLOBAL_PROXY)) continue;
            builder.useGlobalProxy(paramAsJson.getAsJsonPrimitive(USE_GLOBAL_PROXY).getAsBoolean());
        }
        for (LoadedParameterSet paramSet : desc.customParameterSets) {
            if (!credentialRequestInfo.paramSetId.equals(paramSet.id) || paramSet.desc == null) continue;
            for (ParamDesc paramDesc : paramSet.desc.params) {
                ParamDesc.CredentialRequestSettings credentialRequestSettings;
                if (!credentialRequestInfo.paramName.equals(paramDesc.name) || (credentialRequestSettings = paramDesc.credentialRequestSettings) == null) continue;
                if (authorizationEndpoint == null || authorizationEndpoint.isEmpty()) {
                    authorizationEndpoint = credentialRequestSettings.authorizationEndpoint;
                }
                if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
                    tokenEndpoint = credentialRequestSettings.tokenEndpoint;
                }
                if (scope == null || scope.isEmpty()) {
                    scope = credentialRequestSettings.scope;
                }
                builder.authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).scope(scope).resources(credentialRequestSettings.resources);
            }
        }
        builder.useAccessTokenCache(ApplicationConfigurator.getParams().getBoolParam(ENABLE_CACHE_PROPERTY, true));
        return builder.build();
    }

    public static class PluginCredentialRequestInfo {
        public String pluginId;
        public String paramSetId;
        public String presetId;
        public String paramName;
        public boolean refreshTokenRotation;
        public String pluginLabel;
        public String pluginIcon;
        public String paramSetLabel;
        public String paramLabel;
        public boolean mandatory = true;

        public String getNameForCredentialMap() {
            String name = JSON.json((Object)ImmutableList.of((Object)"PLUGIN", (Object)this.pluginId, (Object)this.paramSetId, (Object)this.presetId, (Object)this.paramName));
            return name.substring(1, name.length() - 1);
        }

        public String toString() {
            return "PluginCredentialRequestInfo{pluginId='" + this.pluginId + "', paramSetId='" + this.paramSetId + "', presetId='" + this.presetId + "', paramName='" + this.paramName + "', refreshTokenRotation=" + this.refreshTokenRotation + "}";
        }
    }
}

