/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.secretsstorage;

import com.dataiku.dip.security.secretsstorage.SecretsFetcher;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.cloud.secretmanager.v1.AccessSecretVersionRequest;
import com.dataiku.dss.shadelib.com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.dataiku.dss.shadelib.com.google.cloud.secretmanager.v1.SecretVersionName;
import com.dataiku.dss.shadelib.com.google.protobuf.ByteString;
import java.util.Base64;

public class GCPSecretFetcher
implements SecretsFetcher {
    private SecretManagerServiceClient client;
    private Settings settings;

    @Override
    public void init(String params) throws Exception {
        this.settings = (Settings)JSON.parse((String)params, Settings.class);
        this.client = SecretManagerServiceClient.create();
    }

    @Override
    public byte[] fetchSecretBytes(String secretName) throws Exception {
        try {
            SecretVersionName secretVersionName = SecretVersionName.of((String)this.settings.projectId, (String)secretName, (String)"latest");
            AccessSecretVersionRequest request = AccessSecretVersionRequest.newBuilder().setName(secretVersionName.toString()).build();
            ByteString secretPayload = this.client.accessSecretVersion(request).getPayload().getData();
            if (secretPayload == null) {
                throw new Exception("No secret found for project '" + this.settings.projectId + "' and secret name '" + secretName + "'");
            }
            byte[] secretValue = secretPayload.toByteArray();
            return Base64.getDecoder().decode(secretValue);
        }
        catch (Exception e) {
            throw new Exception("Error fetching secret bytes: " + e.getMessage(), e);
        }
    }

    static class Settings {
        private String projectId;

        Settings() {
        }
    }
}

