/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CodeEnvsUserController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private AutomationNodeCodeEnvsService automationNodeEnvsService;
    @Autowired
    private AvailablePythonInterpretersService availablePythonInterpretersService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    private static final Logger logger = Logger.getLogger((String)"dip.codeenv.user.controller");

    @AuditedCall(value={"msgType", "user-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/list"})
    public void listEnvs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> items = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                items = this.automationNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
                break;
            }
            case DESIGN: {
                items = this.designNodeEnvsService.listCodeEnvsWithKernelSpecNames_NT();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        HashSet pluginModes = Sets.newHashSet((Object[])new CodeEnvModel.CodeEnvDeploymentMode[]{CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED});
        ArrayList ret = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem item : items) {
                if (pluginModes.contains((Object)item.deploymentMode) || item.envLang != CodeEnvModel.EnvLang.valueOf(envLang) || !this.permissionsService.hasCodeEnvPrivilege(authCtx, item.envLang, item.envName, Privileges.CodeEnvLevelPrivilegeType.USE)) continue;
                ret.add(item);
            }
        }
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "user-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/list-names"})
    public void anyListEnvs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        List<CodeEnvModel.CodeEnvListItem> items = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                items = this.automationNodeEnvsService.listCodeEnvs();
                break;
            }
            case DESIGN: {
                items = this.designNodeEnvsService.listCodeEnvs();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        HashSet pluginModes = Sets.newHashSet((Object[])new CodeEnvModel.CodeEnvDeploymentMode[]{CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED});
        ArrayList ret = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem item : items) {
                if (pluginModes.contains((Object)item.deploymentMode) || item.envLang != CodeEnvModel.EnvLang.valueOf(envLang) || !this.permissionsService.hasCodeEnvPrivilege(authCtx, item.envLang, item.envName, Privileges.CodeEnvLevelPrivilegeType.USE)) continue;
                ret.add(item.envName);
            }
        }
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "user-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/list-names-with-default"})
    public void anyListEnvsWithDefault(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envLang, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        SerializedProject sp = null;
        String bundleId = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            sp = this.projectsDAO.getMandatory(projectKey);
            if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
                bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
            }
        }
        List<CodeEnvModel.CodeEnvListItem> items = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                items = this.automationNodeEnvsService.listCodeEnvs(projectKey, bundleId);
                break;
            }
            case DESIGN: {
                items = this.designNodeEnvsService.listCodeEnvs();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        HashSet pluginModes = Sets.newHashSet((Object[])new CodeEnvModel.CodeEnvDeploymentMode[]{CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED});
        EnvNamesWithProjectDefault ret = new EnvNamesWithProjectDefault();
        try (Transaction t = this.transactionService.beginRead();){
            for (CodeEnvModel.CodeEnvListItem item : items) {
                if (pluginModes.contains((Object)item.deploymentMode) || item.envLang != CodeEnvModel.EnvLang.valueOf(envLang) || !this.permissionsService.hasCodeEnvPrivilege(authCtx, item.envLang, item.envName, Privileges.CodeEnvLevelPrivilegeType.USE)) continue;
                EnvNameWithDesc en = new EnvNameWithDesc();
                en.envName = item.envName;
                en.pythonInterpreter = item.pythonInterpreter;
                en.pythonInterpreterDeprecated = item.isPythonInterpreterDeprecated();
                ret.envs.add(en);
            }
        }
        ret.resolvedInheritDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.valueOf(envLang), sp.settings.codeEnvs);
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "user-python-code-envs-list-with-experiment-tracking-packages"})
    @RequestMapping(value={"/api/code-envs/list-python-with-mlflow-packages"})
    public void listPythonEnvsWithMLflowPackages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectCodeEnvsSelection projectEnvsSelection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            projectEnvsSelection = this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
        }
        List<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> mlflowCodeEnvs = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case DESIGN: {
                mlflowCodeEnvs = this.designNodeEnvsService.getEnvListWithMLflowCompat_NT(authCtx);
                break;
            }
            case AUTOMATION: {
                mlflowCodeEnvs = this.automationNodeEnvsService.getEnvListWithMLflowCompat_NT(authCtx, projectKey);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        String resolvedInheritDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, projectEnvsSelection);
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)new MLflowEnvNamesWithProjectDefault(mlflowCodeEnvs, resolvedInheritDefault));
    }

    @AuditedCall(value={"msgType", "user-python-code-envs-list-with-visual-ml-packages"})
    @RequestMapping(value={"/api/code-envs/list-python-with-visual-ml-packages"})
    public void listPythonEnvsWithVisualMlPackages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectCodeEnvsSelection projectEnvsSelection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            projectEnvsSelection = this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
        }
        List<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat> codeEnvs = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                break;
            }
            case DESIGN: {
                codeEnvs = this.designNodeEnvsService.getEnvListWithVisualMlCompat_NT(authCtx);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        String resolvedInheritDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, projectEnvsSelection);
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)new VisualMLEnvNamesWithProjectDefault(codeEnvs, resolvedInheritDefault));
    }

    @AuditedCall(value={"msgType", "user-python-code-envs-list-compatibility-with-mltask"})
    @RequestMapping(value={"/api/code-envs/list-python-compatibility-with-mltask"}, method={RequestMethod.POST})
    @ResponseBody
    public DesignNodeCodeEnvsService.EnvsCompatibilityWithMLTask listPythonEnvsWithVisualIncompatibilities(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, String mlTask) throws Exception {
        ProjectCodeEnvsSelection projectEnvsSelection;
        AuthCtx authCtx;
        MLTask taskObj = (MLTask)JSON.parse((String)mlTask, MLTask.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            projectEnvsSelection = this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                return null;
            }
            case DESIGN: {
                return this.designNodeEnvsService.getEnvsCompatibilityWithMLTask_NT(authCtx, taskObj, projectEnvsSelection, projectKey);
            }
        }
        throw new Error("unreachable");
    }

    @AuditedCall(value={"msgType", "user-python-code-envs-list-compatibility-with-test"})
    @RequestMapping(value={"/api/code-envs/list-python-compatibility-with-test"})
    public void listPythonEnvsWithPytestPackage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectCodeEnvsSelection projectEnvsSelection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            projectEnvsSelection = this.projectsDAO.getMandatory((String)projectKey).settings.codeEnvs;
        }
        List<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> testCodeEnvs = null;
        switch (ApplicationConfigurator.getNodeType()) {
            case DESIGN: {
                testCodeEnvs = this.designNodeEnvsService.getEnvListWithTestCompat_NT(authCtx);
                break;
            }
            case AUTOMATION: {
                testCodeEnvs = this.automationNodeEnvsService.getEnvListWithTestCompat_NT(authCtx, projectKey);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        String resolvedInheritDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, projectEnvsSelection);
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)new TestEnvNamesWithProjectDefault(testCodeEnvs, resolvedInheritDefault));
    }

    @AuditedCall(value={"msgType", "user-code-envs-list"})
    @RequestMapping(value={"/api/code-envs/list-usages"})
    public void listEnvUsages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            HashMap deploymentModes = Maps.newHashMap();
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    for (CodeEnvModel.CodeEnvListItem env : this.automationNodeEnvsService.listCodeEnvs()) {
                        deploymentModes.put(new CodeEnvModel.UsedCodeEnvRef(env.envLang, env.envName), env.deploymentMode);
                    }
                    break;
                }
                case DESIGN: {
                    for (CodeEnvModel.CodeEnvListItem env : this.designNodeEnvsService.listCodeEnvs()) {
                        deploymentModes.put(new CodeEnvModel.UsedCodeEnvRef(env.envLang, env.envName), env.deploymentMode);
                    }
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            List<CodeEnvModel.CodeEnvUsage> usages = this.codeEnvUsagesService.listUsages((CodeEnvModel.UsedCodeEnvRef)null, projectKey);
            HashSet used = Sets.newHashSet();
            for (CodeEnvModel.CodeEnvUsage usage : usages) {
                CodeEnvModel.UsedCodeEnvRef use = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
                CodeEnvModel.CodeEnvDeploymentMode deploymentMode = (CodeEnvModel.CodeEnvDeploymentMode)((Object)deploymentModes.get(use));
                if (deploymentMode == null) {
                    logger.warn((Object)("Skipping referencing of code env " + usage.envName + " because it doesn't exist"));
                    continue;
                }
                if (deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED || deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED) {
                    logger.warn((Object)("Skipping referencing of code env " + usage.envName + " because it's a plugin's code env"));
                    continue;
                }
                used.add(use);
            }
            CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)used);
        }
    }

    @AuditedCall(value={"msgType", "user-accessible-code-envs-settings"})
    @RequestMapping(value={"/api/code-envs/user-accessible-settings"})
    public void getUserAccessibleCodeEnvSettings(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        UserAccessibleCodeEnvSettings codeEnvSettings = new UserAccessibleCodeEnvSettings();
        codeEnvSettings.enableCodeEnvResources = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().security.enableCodeEnvResources;
        codeEnvSettings.useConda = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN().codeEnvs.useConda;
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)codeEnvSettings);
    }

    @AuditedCall(value={"msgType", "user-accessible-code-envs-get-packages"})
    @RequestMapping(value={"/api/code-envs/design/get-mandatory-packages"})
    public void getMandatoryPackagesList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String envDesc, @RequestParam String envLang) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        CodeEnvsUserController.writeJSON((HttpServletResponse)resp, (Object)this.designNodeEnvsService.getMandatoryPackagesList(switch (el) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)envDesc, CodeEnvModel.PythonEnvDesc.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)envDesc, CodeEnvModel.REnvDesc.class);
            default -> throw new Error("unreachable");
        }));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-envs/list-available-python-interpreters"})
    @ResponseBody
    public List<StandardPythonInterpreter> listAvailableInterpreters(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return this.availablePythonInterpretersService.getAvailablePythonInterpreters();
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/code-envs/get-default-core-package-set"})
    @ResponseBody
    public CodeEnvModel.PythonEnvDesc.CorePythonPackagesSet getDefaultCorePackageSet(HttpServletRequest req, @RequestParam StandardPythonInterpreter pythonInterpreter) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        return CodeEnvModel.getDefaultCorePackagesSet(pythonInterpreter);
    }

    @AuditedCall(value={"msgType", "user-accessible-code-envs-check-agents-code-env"})
    @RequestMapping(value={"/api/code-envs/agents/check"})
    @ResponseBody
    public JsonObject checkAgentsCodeEnv(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        JsonObject response = new JsonObject();
        String codeEnvName = DKUApp.getParams().getParam("dku.llm.visualAgent.codeenv");
        if (StringUtils.isNotBlank((String)codeEnvName)) {
            response.addProperty("codeEnvType", "CUSTOM");
        } else {
            response.addProperty("codeEnvType", "RAG");
            codeEnvName = DSSInternalCodeEnvsService.getCodeEnvName(DSSInternalCodeEnvsService.DSSInternalCodeEnvType.RAG_CODE_ENV);
        }
        try {
            PythonCodeEnvPackagesUtils.PythonEnvPackages packages = null;
            boolean isUnsupportedPython = false;
            switch (ApplicationConfigurator.getNodeType()) {
                case AUTOMATION: {
                    CodeEnvModel.AutomationUIPythonEnv automationEnv = this.automationNodeEnvsService.getPythonEnvForUI(codeEnvName, false);
                    CodeEnvModel.AutomationUIPythonEnvVersion envVersion = this.automationNodeEnvsService.getPythonEnvVersion(projectKey, automationEnv);
                    if (envVersion == null) {
                        throw new IOException("Automation node code env not found");
                    }
                    if (!((CodeEnvModel.PythonEnvDesc)envVersion.desc).pythonInterpreter.isVersionGreaterOrEqual(StandardPythonInterpreter.PYTHON39)) {
                        isUnsupportedPython = true;
                        break;
                    }
                    packages = PythonCodeEnvPackagesUtils.getEnvPackages(automationEnv, envVersion);
                    break;
                }
                case DESIGN: {
                    CodeEnvModel.DesignUIPythonEnv codeEnv = this.designNodeEnvsService.getPythonEnvForUI(codeEnvName, false);
                    if (!((CodeEnvModel.PythonEnvDesc)codeEnv.desc).pythonInterpreter.isVersionGreaterOrEqual(StandardPythonInterpreter.PYTHON39)) {
                        isUnsupportedPython = true;
                        break;
                    }
                    packages = PythonCodeEnvPackagesUtils.getEnvPackages(codeEnv);
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            if (isUnsupportedPython) {
                response.addProperty("codeEnvError", "requires Python >= 3.9");
            } else if (packages != null && !packages.hasPackage("langgraph")) {
                response.addProperty("codeEnvError", "the langgraph Python package is not installed");
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to load agents code environment", (Throwable)e);
            response.addProperty("codeEnvError", "it is not installed");
        }
        return response;
    }

    @UIModel
    static class EnvNamesWithProjectDefault {
        public List<EnvNameWithDesc> envs = new ArrayList<EnvNameWithDesc>();
        public String resolvedInheritDefault;

        EnvNamesWithProjectDefault() {
        }
    }

    static class EnvNameWithDesc {
        public String envName;
        public String owner;
        public StandardPythonInterpreter pythonInterpreter;
        public boolean pythonInterpreterDeprecated;

        public EnvNameWithDesc() {
        }

        public EnvNameWithDesc(String envName) {
            this.envName = envName;
        }
    }

    @UIModel
    static class MLflowEnvNamesWithProjectDefault {
        List<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> envs;
        public String resolvedInheritDefault;

        public MLflowEnvNamesWithProjectDefault(List<PythonCodeEnvPackagesUtils.CodeEnvMLflowCompat> envs, String resolvedInheritDefault) {
            this.envs = envs;
            this.resolvedInheritDefault = resolvedInheritDefault;
        }
    }

    static class VisualMLEnvNamesWithProjectDefault {
        List<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat> envs;
        public String resolvedInheritDefault;
        PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat builtinEnvCompat;

        public VisualMLEnvNamesWithProjectDefault(List<PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat> envs, String resolvedInheritDefault) {
            this.envs = envs;
            this.resolvedInheritDefault = resolvedInheritDefault;
            this.builtinEnvCompat = PythonCodeEnvPackagesUtils.CodeEnvVisualMLCompat.builtinEnvCompatibility();
        }
    }

    @UIModel
    static class TestEnvNamesWithProjectDefault {
        List<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> envs;
        public String resolvedInheritDefault;

        public TestEnvNamesWithProjectDefault(List<PythonCodeEnvPackagesUtils.CodeEnvTestCompat> envs, String resolvedInheritDefault) {
            this.envs = envs;
            this.resolvedInheritDefault = resolvedInheritDefault;
        }
    }

    private static class UserAccessibleCodeEnvSettings {
        public boolean enableCodeEnvResources;
        public Boolean useConda;

        private UserAccessibleCodeEnvSettings() {
        }
    }
}

