/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.recipes.code.scala.ScalaKernelsManager;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.yarnaware.YarnClusterService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ClustersController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private HProxyKernelsManager hProxyKernelsManager;
    @Autowired
    private ScalaKernelsManager scalaKernelsManager;
    @Autowired
    private YarnClusterService yarnClusterService;
    static Logger logger = Logger.getLogger((String)"dip.controllers.clusters");

    @AuditedCall(value={"msgType", "clusters-list"})
    @RequestMapping(value={"/api/clusters/list"})
    public void listClusters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            ArrayList items = Lists.newArrayList();
            for (Cluster cluster : this.clustersService.listUnsafe()) {
                if (!this.permissionsService.hasAnyClusterAccess(authCtx, cluster.id)) continue;
                ClustersService.ClusterHeadItem clusterHeadItem = new ClustersService.ClusterHeadItem(cluster);
                clusterHeadItem.fillPrivilegeInfo(this.permissionsService, authCtx);
                items.add(clusterHeadItem);
            }
            this.clustersService.collectUsageCounts(items);
            ClustersController.writeJSON((HttpServletResponse)resp, (Object)items);
        }
    }

    @AuditedCall(value={"msgType", "clusters-list"})
    @RequestMapping(value={"/api/clusters/list-accessible"})
    public void listAccessibleClusters(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, value="architecture") String architectureStr) throws Exception {
        Cluster.ClusterArchitecture architecture = StringUtils.isNotBlank((String)architectureStr) ? Cluster.ClusterArchitecture.valueOf(architectureStr) : null;
        ArrayList items = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (Cluster cluster : this.clustersService.listUnsafe()) {
                if (architecture != null && architecture != cluster.architecture || !this.permissionsService.hasAnyClusterAccess(authCtx, cluster.id)) continue;
                items.add(new ClustersService.ClusterHeadItem(cluster));
            }
        }
        ClustersController.writeJSON((HttpServletResponse)resp, (Object)items);
    }

    @AuditedCall(value={"msgType", "clusters-get", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/get"})
    public void getCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            Cluster cluster = this.clustersService.getMandatoryUnsafe(id);
            ClustersService.ClusterItem clusterItem = new ClustersService.ClusterItem(cluster);
            clusterItem.fillPrivilegeInfo(this.permissionsService, authCtx);
            ClustersController.writeJSON((HttpServletResponse)resp, (Object)clusterItem);
        }
    }

    @AuditedCall(value={"msgType", "clusters-get-status", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/get-status"})
    public void getClusterStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ClustersService.ClusterStatus status;
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            try {
                status = this.clustersService.getStatus(id);
                ArrayList accessibleUsages = Lists.newArrayList();
                for (ClustersService.ClusterUsage usage : status.usages) {
                    if (StringUtils.isNotBlank((String)usage.projectKey)) {
                        if (this.permissionsService.hasAnyProjectAccess(authCtx, usage.projectKey)) {
                            accessibleUsages.add(usage);
                            continue;
                        }
                        ++status.otherProjectUsagesCount;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)usage.scenarioProjectKey)) continue;
                    if (this.permissionsService.hasAnyProjectAccess(authCtx, usage.scenarioProjectKey)) {
                        accessibleUsages.add(usage);
                        continue;
                    }
                    ++status.otherScenarioUsagesCount;
                }
                status.usages = accessibleUsages;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to retrieve status", (Throwable)e);
                status = new ClustersService.ClusterStatus();
                status.error = new SerializedError((Throwable)e, true);
            }
            ClustersController.writeJSON((HttpServletResponse)resp, (Object)status);
        }
    }

    @AuditedCall(value={"msgType", "clusters-delete", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/delete"})
    public void deleteCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            Cluster cluster = this.clustersService.delete(id);
            t.commit("Delete cluster " + cluster.name);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/clusters/create"})
    public void createCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        Cluster cluster = (Cluster)JSON.parse((String)data, Cluster.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx authCtx;
            GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (gs.sparkSettings.sparkEnabled) {
                cluster.sparkSettings.sparkEnabled = true;
            }
            if (gs.impalaSettings.enabled) {
                cluster.impalaSettings.enabled = true;
            }
            if (!(authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req)).getPermissions().mayCreateClusters()) {
                throw new SecurityException("You may not create clusters");
            }
            cluster.origin = Cluster.ClusterOrigin.makeManual(authCtx);
            cluster = this.clustersService.create(authCtx, cluster);
            t.commit("Create cluster " + cluster.name);
            ClustersController.writeJSON((HttpServletResponse)resp, (Object)cluster);
            this.auditTrailService.generic("clusters-create").with("clusterId", cluster.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("clusters-create", (Throwable)e).with("clusterId", cluster.id).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/clusters/save"})
    public void saveCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        Cluster cluster = (Cluster)JSON.parse((String)data, Cluster.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, cluster.id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            cluster = this.clustersService.saveFromUser(cluster, this.permissionsService.hasClusterPrivilege(authCtx, cluster.id, Privileges.ClusterLevelPrivilegeType.MANAGE_USERS));
            ClustersService.ClusterItem clusterItem = new ClustersService.ClusterItem(cluster);
            clusterItem.fillPrivilegeInfo(this.permissionsService, authCtx);
            ClustersController.writeJSON((HttpServletResponse)resp, (Object)clusterItem);
            t.commit("Save cluster " + cluster.name);
            this.auditTrailService.generic("clusters-save").with("clusterId", cluster.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("clusters-save", (Throwable)e).with("clusterId", cluster.id).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "clusters-start", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/start"})
    public void startCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            Cluster cluster = this.clustersService.getMandatoryUnsafe(id);
            ClustersController.writeJSON((HttpServletResponse)resp, this.clustersService.start(authCtx, null, cluster));
        }
    }

    @AuditedCall(value={"msgType", "clusters-stop", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/stop"})
    public void stopCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id, @RequestParam(required=false, defaultValue="true") boolean terminate, @RequestParam(required=false, defaultValue="false") boolean forceStop) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            Cluster cluster = this.clustersService.getMandatoryUnsafe(id);
            ClustersController.writeJSON((HttpServletResponse)resp, this.clustersService.stop(authCtx, null, cluster, terminate, forceStop));
        }
    }

    @AuditedCall(value={"msgType", "clusters-stop", "clusterId", "${id}"})
    @RequestMapping(value={"/api/clusters/mark-stopped"})
    public void markStoppedCluster(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        Cluster cluster;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, id, Privileges.ClusterLevelPrivilegeType.UPDATE);
            cluster = this.clustersService.getMandatoryUnsafe(id);
            cluster = this.clustersService.markStopped(authCtx, cluster);
            t.commit("Mark cluster " + cluster.name + " as stopped");
        }
        ClustersController.writeJSON((HttpServletResponse)resp, (Object)cluster);
    }

    @AuditedCall(value={"msgType", "clusters-list-logs", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/list-logs"})
    public void listLogs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
        }
        ClustersController.writeJSON((HttpServletResponse)resp, this.clustersService.listLogs(clusterId));
    }

    @AuditedCall(value={"msgType", "clusters-stream-log", "clusterId", "${clusterId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/clusters/stream-log"})
    public void streamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String logName) throws IOException, DKUSecurityException {
        String dlName;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
        }
        String now = DKUtils.getDateFormatter((String)"_yyyy_MM_dd").print(new Date().getTime());
        if (StringUtils.isNotBlank((String)logName)) {
            String basename = FilenameUtils.getBaseName((String)logName);
            String extension = FilenameUtils.getExtension((String)logName);
            dlName = basename + now + "." + extension + ".gz";
        } else {
            dlName = "dssLogs" + now + ".zip";
        }
        String cd = String.format("attachment; filename=\"%s\"", dlName);
        resp.setHeader("Content-Disposition", cd);
        this.clustersService.streamLog(clusterId, logName, (OutputStream)resp.getOutputStream());
    }

    @AuditedCall(value={"msgType", "clusters-get-log", "clusterId", "${clusterId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/clusters/get-log"})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String logName) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
        }
        ClustersController.writeJSON((HttpServletResponse)resp, (Object)this.clustersService.getLog(clusterId, logName));
    }

    @AuditedCall(value={"msgType", "clusters-get-diag", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/download-diagnosis"})
    public void downloadLogDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
        }
        File clusterDir = ClustersService.getClusterFolder(clusterId);
        String id = "dss-cluster-diag-" + clusterId + "/";
        HashMap directoriesToZip = Maps.newHashMap();
        directoriesToZip.put(id, clusterDir);
        if (clusterDir.exists()) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + id + ".zip\"");
            resp.setStatus(200);
            try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                ZipUnzipDir.zipDirectoriesToStream(directoriesToZip, bos, null);
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("run logs dir not found");
        }
    }

    @AuditedCall(value={"msgType", "clusters-get-diag", "clusterId", "${clusterId}"})
    @RequestMapping(value={"/api/clusters/abort-kernel"})
    public void abortKernel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String prefix, @RequestParam String kernelId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        if (this.hProxyKernelsManager.getPrefix().equals(prefix)) {
            this.hProxyKernelsManager.abort(kernelId);
        } else if (this.scalaKernelsManager.getPrefix().equals(prefix)) {
            this.scalaKernelsManager.abort(kernelId);
        } else {
            throw new IllegalArgumentException("Unknown cluster-dependent kernel type " + prefix);
        }
    }

    @AuditedCall(value={"msgType", "yarn-cluster-preload"})
    @RequestMapping(value={"/api/clusters/preload-yarn-cluster-files"})
    public void preloadYarnClusterFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="yarnClusterSettings") String yarnClusterSettingsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
            ClustersController.writeJSON((HttpServletResponse)resp, this.yarnClusterService.preload(authCtx, (SparkSettings.YarnClusterSettings)JSON.parse((String)yarnClusterSettingsData, SparkSettings.YarnClusterSettings.class)));
        }
    }
}

