/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MeaningsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MeaningsService meaningsService;
    @Autowired
    private MeaningsService.MeaningsDeletionService meaningsDeletionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private IInternalDataCatalogService catalogService;

    @AuditedCall(value={"msgType", "meanings-list"})
    @RequestMapping(value={"/api/meanings/list-all"})
    public void listMeanings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            MeaningsController.writeJSON((HttpServletResponse)resp, (Object)this.meaningsService.listAll());
        }
    }

    @AuditedCall(value={"msgType", "meanings-list"})
    @RequestMapping(value={"/api/meanings/udm/list-with-state"})
    public void listUDMWithState(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            MeaningsController.writeJSON((HttpServletResponse)resp, this.meaningsService.listUserDefinedUnsafe());
        }
    }

    @AuditedCall(value={"msgType", "meaning-get", "meaningId", "${id}"})
    @RequestMapping(value={"/api/meanings/udm/get"})
    public void getMeaning(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            MeaningsController.writeJSON((HttpServletResponse)resp, (Object)this.meaningsService.getUnsafe(id));
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/meanings/udm/save"})
    public void saveUDM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String userDefinedMeaning) throws IOException, UnauthorizedException {
        UserDefinedMeaning udm = (UserDefinedMeaning)JSON.parse((String)userDefinedMeaning, UserDefinedMeaning.class);
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayManageUDM()) {
                throw new SecurityException("You may not manage user-defined meanings");
            }
            this.meaningsService.save(udm);
            rwt.commitV("Saved user-defined meaning: " + udm.id, new Object[0]);
            this.auditTrailService.generic("meaning-save").with("meaningId", udm.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("meaning-save", (Throwable)e).with("meaningId", udm.id).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/meanings/udm/create"})
    public void createUDM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String userDefinedMeaning) throws IOException, UnauthorizedException {
        UserDefinedMeaning udm = (UserDefinedMeaning)JSON.parse((String)userDefinedMeaning, UserDefinedMeaning.class);
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            this.authService.getMandatoryUser(req);
            DSSAuthCtx liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayManageUDM()) {
                throw new SecurityException("You may not manage user-defined meanings");
            }
            this.meaningsService.create(udm);
            rwt.commitV("Created user-defined meaning: " + udm.id, new Object[0]);
            this.auditTrailService.generic("meaning-create").with("meaningId", udm.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("meaning-create", (Throwable)e).with("meaningId", udm.id).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "meaning-delete", "meaningId", "${id}"})
    @RequestMapping(value={"/api/meanings/udm/delete"})
    public void deleteUDM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (RWTransaction rwt = this.transactionService.beginWriteForUI(req);){
            if (!((DSSAuthCtx)this.authService.getMandatoryUser(req)).getPermissions().mayManageUDM()) {
                throw new SecurityException("You may not manage user-defined meanings");
            }
            this.meaningsService.delete(id);
            rwt.commitV("Deleted user-defined meaning: " + id, new Object[0]);
            this.catalogService.flush();
        }
    }

    @AuditedCall(value={"msgType", "meaning-prepare-delete", "meaningId", "${id}"})
    @RequestMapping(value={"/api/meanings/udm/prepare-delete"})
    public void prepareDeleteUDM(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            if (!((DSSAuthCtx)this.authService.getMandatoryUser(req)).getPermissions().mayManageUDM()) {
                throw new SecurityException("You may not manage user-defined meanings");
            }
        }
        MeaningsController.writeJSON((HttpServletResponse)resp, (Object)this.meaningsDeletionService.prepareDelete(id));
    }
}

