/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.PageSettingsCatalogService;
import com.dataiku.dip.server.services.catalog.internal.IInternalDataCatalogService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/search"})
public class PagesSettingsController
extends DIPInternalControllerBase {
    @Autowired
    private PageSettingsCatalogService pageSettingsCatalogService;
    @Autowired
    private IInternalDataCatalogService internalDataCatalogService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectService;
    private Executor executor = Executors.newCachedThreadPool();
    private static Logger logger = Logger.getLogger(PagesSettingsController.class);
    private static final String TOKEN_TYPE = "type:";
    private static final String TOKEN_TAG = "tag:";
    private static final String TOKEN_NAVIGATION = "navigation:";
    private static final String TOKEN_USER = "user:";
    private static final String TOKEN_PROJECT = "project:";

    @AuditedCall(value={"msgType", "global-finder-search"})
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam(required=false, defaultValue="10") int limit, @RequestParam(required=false, defaultValue="") String contextualProjectKey, final @Nullable String explainDocId, final @Nullable String explainDocType) throws Exception {
        boolean hasContextualProjectAccess;
        AuthCtx authCtx;
        ExecutorCompletionService<LuceneResponseWrapper> service = new ExecutorCompletionService<LuceneResponseWrapper>(this.executor);
        StringBuilder builder = new StringBuilder(query);
        List<String> types = this.extractTypes(builder);
        List<String> navigations = this.extractTokenValue(builder, TOKEN_NAVIGATION, Collections.emptyList());
        List<String> users = this.extractTokenValue(builder, TOKEN_USER, Collections.emptyList());
        List<String> tags = this.extractTokenValue(builder, TOKEN_TAG, Collections.emptyList());
        List<String> projectKeys = this.extractTokenValue(builder, TOKEN_PROJECT, Collections.emptyList());
        ArrayList<Future<LuceneResponseWrapper>> futures = new ArrayList<Future<LuceneResponseWrapper>>(2);
        List<LuceneResponseWrapper.Hit> searchHits = new ArrayList<LuceneResponseWrapper.Hit>();
        LinkedHashMap<String, LuceneResponseWrapper.Aggregation> aggregations = new LinkedHashMap<String, LuceneResponseWrapper.Aggregation>();
        final String trimmedQuery = builder.toString().trim();
        boolean noFilter = types.isEmpty() && users.isEmpty() && tags.isEmpty() && navigations.isEmpty();
        boolean searchCatalog = noFilter || !types.isEmpty() || !users.isEmpty() || !tags.isEmpty();
        boolean searchNavigation = noFilter || !searchCatalog;
        ArrayList<String> projectKeysWithAccess = new ArrayList();
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            try {
                hasContextualProjectAccess = StringUtils.isNotBlank((String)contextualProjectKey) && this.permissionsService.hasAnyProjectAccess(authCtx, contextualProjectKey);
            }
            catch (DKUSecurityException e) {
                hasContextualProjectAccess = false;
                logger.error((Object)("Used non-existing contextual project key " + contextualProjectKey), (Throwable)e);
            }
            for (String projectKey : projectKeys) {
                if ("all".equals(projectKey)) {
                    projectKeysWithAccess = Collections.emptyList();
                    break;
                }
                try {
                    if (!StringUtils.isNotBlank((String)projectKey) || !this.permissionsService.hasAnyProjectAccess(authCtx, projectKey) && !this.projectService.isVisible(projectKey)) continue;
                    projectKeysWithAccess.add(projectKey);
                }
                catch (DKUSecurityException e) {
                    logger.error((Object)("Used non-existing project filter token " + projectKey), (Throwable)e);
                }
            }
        }
        if (searchCatalog) {
            final IInternalDataCatalogService.Options options = new IInternalDataCatalogService.Options(limit, true, false, false);
            final Map<String, List<String>> facets = this.buildFacets(types, tags, users, projectKeysWithAccess);
            futures.add(service.submit(new Callable<LuceneResponseWrapper>(){

                @Override
                public LuceneResponseWrapper call() throws Exception {
                    return PagesSettingsController.this.internalDataCatalogService.searchInternal(trimmedQuery, facets, authCtx, options.withExplainDocId(explainDocId).withExplainDocType(explainDocType));
                }
            }));
        }
        if (searchNavigation) {
            final Map<String, List<String>> navigationFacets = this.buildNavigationFacets(contextualProjectKey, navigations, hasContextualProjectAccess);
            final PageSettingsCatalogService.Options pagesOptions = new PageSettingsCatalogService.Options(limit, contextualProjectKey, false);
            futures.add(service.submit(new Callable<LuceneResponseWrapper>(){

                @Override
                public LuceneResponseWrapper call() throws Exception {
                    return PagesSettingsController.this.pageSettingsCatalogService.search(trimmedQuery, navigationFacets, authCtx, true, pagesOptions);
                }
            }));
        }
        ArrayList<LuceneResponseWrapper.Hit> fullMatches = new ArrayList<LuceneResponseWrapper.Hit>();
        ArrayList others = new ArrayList();
        int fullMatchesIndex = 0;
        int othersIndex = 0;
        for (int i = 0; i < futures.size(); ++i) {
            LuceneResponseWrapper response = (LuceneResponseWrapper)service.take().get();
            if (response == null) continue;
            for (LuceneResponseWrapper.Hit hit : response.hits) {
                int index;
                ArrayList<LuceneResponseWrapper.Hit> list;
                Map source = hit._source;
                String nameTrimmed = Objects.toString(source.get("name"), Objects.toString(source.get("objectName"), "")).trim();
                boolean isPage = IndexableType.PAGE.index().equals(hit._type);
                if (Objects.equals(nameTrimmed.toLowerCase(), trimmedQuery.toLowerCase())) {
                    list = fullMatches;
                    index = fullMatchesIndex++;
                } else {
                    list = others;
                    index = othersIndex++;
                }
                list.add(isPage ? index : list.size(), hit);
            }
        }
        searchHits.addAll(fullMatches);
        searchHits.addAll(others);
        if (searchCatalog && searchNavigation && searchHits.size() > limit) {
            searchHits = searchHits.subList(0, limit);
        }
        String jsonOutput = LuceneResponseWrapper.serializeHits(searchHits, null, aggregations, true);
        jsonOutput = this.internalDataCatalogService.searchResultPostTreatment(authCtx, searchHits, jsonOutput, base -> base.getAsJsonArray("hits"));
        PagesSettingsController.writeJSONString((HttpServletResponse)resp, (String)jsonOutput);
    }

    private Map<String, List<String>> buildNavigationFacets(String contextualProjectKey, List<String> origin, boolean hasContextualProjectAccess) {
        ArrayList<String> navigations = new ArrayList<String>(origin);
        HashMap<String, List<String>> navigationFacets = new HashMap<String, List<String>>();
        if (navigations.isEmpty() || navigations.size() == 1 && "all".equals(navigations.get(0))) {
            navigations.add("instance");
            navigations.add("user");
            navigations.add("project");
        }
        navigations.remove("all");
        if (StringUtils.isBlank((String)contextualProjectKey) || !hasContextualProjectAccess) {
            navigations.remove("project");
        }
        navigationFacets.put("scope", navigations);
        return navigationFacets;
    }

    private List<String> extractTypes(StringBuilder query) {
        ArrayList<String> types = new ArrayList<String>();
        List<String> rawTypes = this.extractTokenValue(query, TOKEN_TYPE, Collections.emptyList());
        for (String rawType : rawTypes) {
            IndexableType type;
            try {
                type = IndexableType.forName(rawType);
            }
            catch (IllegalArgumentException e) {
                type = IndexableType.ALL;
                logger.info((Object)e);
            }
            types.add(type.index());
        }
        return types;
    }

    private Map<String, List<String>> buildFacets(List<String> types, List<String> tags, List<String> users, List<String> projectKeys) {
        HashMap<String, List<String>> facets = new HashMap<String, List<String>>();
        if (!projectKeys.isEmpty()) {
            facets.put("projectKey.raw", projectKeys);
        }
        facets.put("_type", types.isEmpty() ? Collections.singletonList("all") : types);
        if (!tags.isEmpty() && !"all".equals(tags.get(0))) {
            facets.put("tag.raw", tags);
        }
        if (!users.isEmpty() && !"all".equals(users.get(0))) {
            facets.put("user", users);
        }
        return facets;
    }

    private String extractTokenValue(StringBuilder query, String tokenType, String defaultValue) {
        String value = defaultValue;
        Pattern pattern = Pattern.compile(String.format("(%s(\".+\"|[^ ]+))", tokenType));
        Matcher matcher = pattern.matcher(query);
        if (matcher.find()) {
            value = matcher.group(2);
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            String group = matcher.group(0);
            int startIndex = query.indexOf(group);
            query.replace(startIndex, startIndex + group.length(), "");
        }
        return value;
    }

    private List<String> extractTokenValue(StringBuilder query, String tokenType, List<String> defaultValue) {
        int count = org.springframework.util.StringUtils.countOccurrencesOf((String)query.toString(), (String)tokenType);
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String value = this.extractTokenValue(query, tokenType, "");
            if (value.isEmpty()) {
                return defaultValue;
            }
            if (value.indexOf(44) != -1) {
                list.addAll(Arrays.asList(value.split(",")));
                continue;
            }
            list.add(value);
        }
        return list;
    }
}

