/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.TemplatesDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.scenarios.TestScenarioRunDTO;
import com.dataiku.dip.scheduler.steps.PytestStepRunner;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.CallUsedByDashboard;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenarioRunsService;
import com.dataiku.dip.server.services.ScenarioScheduleService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.exceptions.TransactionFailedException;
import com.dataiku.dip.transactions.git.TransactionGitException;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ScenarioController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private ScenarioRunsService scenarioRunsService;
    @Autowired
    private ScenariosTriggerService scenariosTriggerService;
    @Autowired
    private ScenarioReportsService scenarioReportsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ScenarioScheduleService scenarioScheduleService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    static Logger logger = Logger.getLogger((String)"dip.scenarios.controller");

    @AuditedCall(value={"msgType", "scenarios-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ScenarioController.writeJSON((HttpServletResponse)resp, this.scenariosService.list(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "scenarios-list"})
    @RequestMapping(value={"/api/scenarios/list-accessible"})
    public void listAccessible(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            ArrayList allScenarios = Lists.newArrayList();
            for (ProjectsService.UIProject project : this.projectsService.listAccessibleUnsafe(user, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                for (Scenario scenario : this.scenariosService.listUnsafe(project.projectKey)) {
                    allScenarios.add(new ScenarioHead(scenario));
                }
            }
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)allScenarios);
        }
    }

    @AuditedCall(value={"msgType", "scenarios-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/scenarios/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx u;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            for (Scenario sc : this.scenariosService.list(projectKey)) {
                if (!TagFilterUtils.matches(tf, sc)) {
                    ++heads.filteredOut;
                    continue;
                }
                Scenario.ScenarioListItem head = new Scenario.ScenarioListItem(sc);
                this.taggableObjectsService.setEditionInfoFromTags(sc, head);
                head.unavailable = this.scenariosService.isUnavailable(sc);
                heads.items.add(head);
                scenarios.add(sc);
            }
        }
        for (int i = 0; i < scenarios.size(); ++i) {
            Scenario sc = (Scenario)scenarios.get(i);
            Scenario.ScenarioListItem head = (Scenario.ScenarioListItem)heads.items.get(i);
            ScenarioThread scenarioThread = this.scenarioRunsService.getMostRecentScenarioRun(sc);
            head.computeTriggerDigest_NT(this.scenariosTriggerService);
            head.setThread(scenarioThread, true);
        }
        this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, heads.items);
        ScenarioController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "scenarios-list"})
    @RequestMapping(value={"/api/scenarios/list-all-heads"})
    public void listAllHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx u;
        HashMap allHeads = Maps.newHashMap();
        LinkedHashMap allScenarios = Maps.newLinkedHashMap();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        List<Object> summaries = new ArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            summaries = this.projectsService.listAccessibleUnsafe(u, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        for (ProjectsService.UIProject uIProject : summaries) {
            TaggableObjectsService.FilteredTaggableItems projectHeads = new TaggableObjectsService.FilteredTaggableItems();
            ArrayList<Scenario> projectScenarios = new ArrayList<Scenario>();
            allHeads.put(uIProject.projectKey, projectHeads);
            try (Transaction t = this.transactionService.beginRead();){
                for (Scenario sc : this.scenariosService.listUnsafe(uIProject.projectKey)) {
                    if (!TagFilterUtils.matches(tf, sc)) {
                        ++projectHeads.filteredOut;
                        continue;
                    }
                    projectScenarios.add(sc);
                    allScenarios.put(sc.getFullId(), sc);
                }
            }
            for (Scenario sc : projectScenarios) {
                Scenario.ScenarioListItem head = new Scenario.ScenarioListItem(sc);
                head.computeTriggerDigest_NT(this.scenariosTriggerService);
                this.taggableObjectsService.setEditionInfoFromTags(sc, head);
                projectHeads.items.add(head);
            }
        }
        TaggableObjectsService.FilteredTaggableItems fullHeads = new TaggableObjectsService.FilteredTaggableItems();
        for (Map.Entry e : allHeads.entrySet()) {
            TaggableObjectsService.FilteredTaggableItems head = (TaggableObjectsService.FilteredTaggableItems)e.getValue();
            String projectKey = (String)e.getKey();
            this.interestsService.enrichListItems(u.getAssociatedDSSUser(), projectKey, head.items);
            fullHeads.items.addAll(head.items);
            fullHeads.filteredOut += head.filteredOut;
        }
        for (Scenario.ScenarioListItem head : fullHeads.items) {
            Scenario sc = (Scenario)allScenarios.get(head.projectKey + "." + head.id);
            ScenarioThread scenarioThread = sc != null ? this.scenarioRunsService.getMostRecentScenarioRun(sc) : null;
            head.setThread(scenarioThread, true);
        }
        ScenarioController.writeJSON((HttpServletResponse)resp, fullHeads);
    }

    @AuditedCall(value={"msgType", "scenarios-list"})
    @RequestMapping(value={"/api/scenarios/list-all-reporters"})
    public void listAllReporters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<ProjectsService.UIProject> summaries;
        TaggableObjectsService.FilteredTaggableItems fullHeads = new TaggableObjectsService.FilteredTaggableItems();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            summaries = this.projectsService.listAccessibleUnsafe(authCtx, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        for (ProjectsService.UIProject summary : summaries) {
            ArrayList<Scenario> projectScenarios = new ArrayList<Scenario>();
            try (Transaction t = this.transactionService.beginRead();){
                for (Scenario sc : this.scenariosService.listUnsafe(summary.projectKey)) {
                    if (sc.getReporters().isEmpty()) continue;
                    projectScenarios.add(sc);
                }
            }
            for (Scenario sc : projectScenarios) {
                Scenario.ScenarioListItem head = new Scenario.ScenarioListItem(sc);
                head.computeReporterDigest_NT();
                fullHeads.items.add(head);
            }
        }
        ScenarioController.writeJSON((HttpServletResponse)resp, fullHeads);
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-last-trigger-runs"})
    public void getLastTriggerRuns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId) throws Exception {
        Scenario scenario;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
        }
        ScenarioController.writeJSON((HttpServletResponse)resp, this.scenariosTriggerService.getLastTriggerRuns(scenario));
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "smartScenarioId", "${smartScenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-last-scenario-runs"})
    public void getLastScenarioRuns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartScenarioId, @RequestParam(required=false, defaultValue="false") boolean onlyFinishedRuns, @RequestParam(required=false, defaultValue="true") boolean withFullScenario, @RequestParam(required=false, defaultValue="100") int limit) throws Exception {
        Scenario scenario;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SCENARIO, smartScenarioId);
        boolean addFutureIdToResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS) || this.projectsService.hasDashboardPermission(authCtx, ref, projectKey, SerializedProject.ReaderAuthorization.Mode.RUN)) {
                addFutureIdToResponse = true;
            } else if (!this.projectsService.hasDashboardPermission(authCtx, ref, projectKey, SerializedProject.ReaderAuthorization.Mode.READ)) {
                this.projectsService.checkPerm(authCtx, ref.getProjectKey(projectKey), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            scenario = this.scenariosService.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
        }
        List<ScenarioRun> scenarioRuns = this.scenariosService.getLastRuns(scenario, limit, onlyFinishedRuns, withFullScenario);
        ArrayList scenarioRunWithFutures = Lists.newArrayList();
        for (ScenarioRun scenarioRun : scenarioRuns) {
            ScenarioRunWithFuture scenarioRunWithFuture = new ScenarioRunWithFuture(scenarioRun);
            ScenarioThread futureThread = this.scenarioRunsService.getScenarioThread(scenarioRun);
            if (futureThread != null) {
                scenarioRunWithFuture.isRunning = StringUtils.isNotBlank((String)futureThread.jobId);
                if (addFutureIdToResponse) {
                    scenarioRunWithFuture.futureId = futureThread.jobId;
                }
                scenarioRunWithFuture.aborted = futureThread.isAborted();
            }
            scenarioRunWithFutures.add(scenarioRunWithFuture);
        }
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenarioRunWithFutures);
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-scenario-run-details"})
    @ResponseBody
    public ScenariosService.ScenarioRunDetails getScenarioRunDetails(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId) throws Exception {
        boolean includeLogs;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            includeLogs = ScenarioController.canAccessLogs(authCtx);
        }
        ScenariosService.ScenarioRunDetails scenarioRunDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, includeLogs);
        if (scenarioRunDetails.scenarioRun != null) {
            try (Transaction t = this.transactionService.beginRead();){
                this.scenarioReportsService.fillInfoInReportItems(projectKey, scenarioRunDetails.scenarioRun, scenarioRunDetails.stepRuns);
            }
        }
        return scenarioRunDetails;
    }

    @AuditedCall(value={"msgType", "scenario-get-test-runs", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/scenarios/list-test-scenario-runs"})
    @ResponseBody
    public List<TestScenarioRunDTO> getTestScenarioRuns(HttpServletRequest req, @RequestParam String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, IOException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<TestScenarioRunDTO> list = this.scenariosService.getTestScenarioRunDTOs(projectKey, bundleId);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Scenario scenario = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenario);
        }
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId) throws Exception {
        AuthCtx authCtx;
        ScenarioSummary summ = new ScenarioSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.scenariosService.getMandatoryUnsafe(projectKey, scenarioId);
            summ.unavailableSteps = this.scenariosService.getUnavailableSteps((Scenario)summ.object);
            summ.unavailableTriggerIds = this.scenariosService.getUnavailableTriggers((Scenario)summ.object);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, scenarioId, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, scenarioId);
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "scenario-get", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/get-script"})
    public void getScript(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ScenarioPayload ret = new ScenarioPayload();
            ret.script = this.scenariosService.getPayload(projectKey, scenarioId, "py");
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = (Scenario)JSON.parse((String)data, Scenario.class);
            if (scenario.getProjectKey() != null && !scenario.getProjectKey().equals(projectKey)) {
                throw new IllegalArgumentException("Project key on scenario doesn't match project key on call: " + scenario.getProjectKey() + " vs " + projectKey);
            }
            if (scenario.getProjectKey() == null) {
                scenario = scenario.withProjectKey(projectKey);
            }
            Scenario s = this.scenariosService.create(projectKey, scenario);
            t.commit("Created scenario " + projectKey + "." + s.id);
            this.auditTrailService.generic("scenario-create").with("projectKey", projectKey).with("scenarioId", s.id).emit();
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)new Scenario().withProjectKey(s.getProjectKey()).withId(s.getId()));
        }
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditedCall(value={"msgType", "scenario-duplicate", "projectKeyFrom", "${projectKeyFrom}", "scenarioIdFrom", "${idFrom}", "projectKeyTo", "${projectKeyTo}", "scenarioIdTo", "${idTo}"})
    @RequestMapping(value={"/api/scenarios/duplicate"})
    public void duplicate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKeyFrom, @RequestParam String projectKeyTo, @RequestParam String idFrom, @RequestParam String idTo, @RequestParam String name) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKeyFrom, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.projectsService.checkPerm(req, projectKeyTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = this.scenariosService.duplicate(projectKeyFrom, idFrom, projectKeyTo, idTo, name);
            t.commit("Duplicated scenario " + projectKeyTo + "." + scenario.id + " from " + projectKeyFrom + "." + idFrom);
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenario);
        }
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam(required=false) String scriptData, @RequestParam(required=false) String saveInfo) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        ScenarioUnavailabilityInfo scenarioUnavailabilityInfo = new ScenarioUnavailabilityInfo();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = (Scenario)JSON.parse((String)data, Scenario.class);
            Scenario savedScenario = this.scenariosService.save(projectKey, scenario);
            if (scriptData != null) {
                this.scenariosService.savePayload(projectKey, scenario.getId(), "py", scriptData);
            }
            this.createGitCommit(t, si, projectKey, scenario);
            scenarioUnavailabilityInfo.scenario = savedScenario;
        }
        this.setScenarioUnavailabilityInfo(scenarioUnavailabilityInfo);
        this.auditTrailService.generic("scenario-save").with("projectKey", projectKey).with("scenarioId", scenarioUnavailabilityInfo.scenario.id).emit();
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenarioUnavailabilityInfo);
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/schedule"})
    public void schedule(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="data") ScenarioScheduleService.ScheduleScenarioOptions options) throws Exception {
        Scenario createdScenario;
        LicenseStatusService.LicensingStatus status = this.licenseStatusService.getLicensingStatus();
        if (!status.valid || status.community) {
            throw new LicenseRestrictionException("Creating Scenario is not allowed with your licence");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        Scenario scenario = this.scenarioScheduleService.createScheduledScenario(projectKey, options);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            createdScenario = this.scenariosService.create(projectKey, scenario);
            t.commit("Scheduled scenario " + projectKey + "." + createdScenario.id);
        }
        this.auditTrailService.generic("scenario-schedule").with("projectKey", projectKey).with("scenarioId", createdScenario.id).emit();
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)new Scenario().withProjectKey(createdScenario.getProjectKey()).withId(createdScenario.getId()));
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/rename"})
    public void rename(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String newName) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = new TaggableObjectsService.TaggableObjectSaveInfo();
        ScenarioUnavailabilityInfo scenarioUnavailabilityInfo = new ScenarioUnavailabilityInfo();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = this.scenariosService.getMandatory(projectKey, scenarioId);
            scenario.name = newName;
            Scenario savedScenario = this.scenariosService.save(projectKey, scenario);
            this.createGitCommit(t, si, projectKey, scenario);
            scenarioUnavailabilityInfo.scenario = savedScenario;
        }
        this.setScenarioUnavailabilityInfo(scenarioUnavailabilityInfo);
        this.auditTrailService.generic("scenario-rename").with("projectKey", projectKey).with("scenarioId", scenarioUnavailabilityInfo.scenario.id).emit();
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenarioUnavailabilityInfo);
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/save-no-params"})
    public void saveNoParams(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam List<String> fieldsToSave, @RequestParam(required=false) String saveInfo) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        ScenarioUnavailabilityInfo scenarioUnavailabilityInfo = new ScenarioUnavailabilityInfo();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario scenario = (Scenario)JSON.parse((String)data, Scenario.class);
            Scenario savedScenario = this.scenariosService.saveNoParams(projectKey, scenario, fieldsToSave);
            this.createGitCommit(t, si, projectKey, scenario);
            scenarioUnavailabilityInfo.scenario = savedScenario;
        }
        this.setScenarioUnavailabilityInfo(scenarioUnavailabilityInfo);
        this.auditTrailService.generic("scenario-save").with("projectKey", projectKey).with("scenarioId", scenarioUnavailabilityInfo.scenario.id).emit();
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenarioUnavailabilityInfo);
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/save-reporter-state"})
    public void saveReporterState(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        this.saveOrDeleteReporter(req, resp, projectKey, scenarioId, data, saveInfo, false);
    }

    @AuditInline
    @RequestMapping(value={"/api/scenarios/delete-reporter"})
    public void deleteReporter(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        this.saveOrDeleteReporter(req, resp, projectKey, scenarioId, data, saveInfo, true);
    }

    private void saveOrDeleteReporter(HttpServletRequest req, HttpServletResponse resp, String projectKey, String scenarioId, String data, String saveInfo, boolean delete) throws Exception {
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        ScenarioUnavailabilityInfo scenarioUnavailabilityInfo = new ScenarioUnavailabilityInfo();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            Scenario.ReporterDigestItem reporter = (Scenario.ReporterDigestItem)JSON.parse((String)data, Scenario.ReporterDigestItem.class);
            Scenario savedScenario = delete ? this.scenariosService.deleteReporter(projectKey, scenarioId, reporter) : this.scenariosService.saveReporterState(projectKey, scenarioId, reporter);
            this.createGitCommit(t, si, projectKey, savedScenario);
            scenarioUnavailabilityInfo.scenario = savedScenario;
        }
        this.setScenarioUnavailabilityInfo(scenarioUnavailabilityInfo);
        this.auditTrailService.generic("scenario-save").with("projectKey", projectKey).with("scenarioId", scenarioUnavailabilityInfo.scenario.id).emit();
        ScenarioController.writeJSON((HttpServletResponse)resp, (Object)scenarioUnavailabilityInfo);
        this.scenariosTriggerService.touchTriggerThreadExecution();
    }

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "scenario-run", "projectKey", "${projectKey}", "smartScenarioId", "${smartScenarioId}"})
    @RequestMapping(value={"/api/scenarios/manual-run"})
    public void manualRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartScenarioId, @RequestParam(required=false) String params, @RequestParam(required=false, defaultValue="false") boolean waitForStart, @RequestParam(required=false, defaultValue="false") boolean waitForCompletion) throws Exception {
        JsonObject o;
        Scenario scenario;
        DSSAuthCtx authCtx;
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SCENARIO, smartScenarioId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            scenario = this.scenariosService.getMandatoryUnsafe(ref.getProjectKey(projectKey), ref.objectId);
            if (!this.projectsService.hasDashboardPermission((AuthCtx)authCtx, ref, projectKey, SerializedProject.ReaderAuthorization.Mode.RUN)) {
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, ref.getProjectKey(projectKey), Privileges.ProjectLevelPrivilegeType.READ_CONF);
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, ref.getProjectKey(projectKey), Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS);
                if (StringUtils.isBlank((String)scenario.runAsUser)) {
                    this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, ref.getProjectKey(projectKey), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                }
            }
            o = new JsonObject();
            if (!StringUtils.isBlank((String)params)) {
                o = (JsonObject)JSON.parse((String)params, JsonObject.class);
            }
        }
        TriggerFire triggerFire = this.scenariosTriggerService.manualRun(authCtx, scenario, "Manual trigger", o);
        if (waitForCompletion || waitForStart) {
            ScenarioRunWaiter waiter = new ScenarioRunWaiter(authCtx, triggerFire, waitForCompletion);
            FutureResponse<ScenariosService.ScenarioRunDetails> fr = this.futureService.runFuture(waiter, 0L, new TypeToken<FutureResponse<ScenariosService.ScenarioRunDetails>>(){});
            ScenarioController.writeJSON((HttpServletResponse)resp, fr);
        } else {
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)triggerFire);
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/download-run-diagnosis"})
    public void downloadLogDiagnosis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId) throws Exception {
        ScenariosService.ScenarioRunDetails scenarioRunDetails;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!ScenarioController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
            scenarioRunDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, true);
        }
        this.scenariosService.sendScenarioDiagnostic(authCtx, resp, scenarioRunDetails);
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/run-log"})
    public void runLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!ScenarioController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
        }
        File runDir = ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId);
        File logFileCompressed = new File(runDir, "log.log.gz");
        File logFile = logFileCompressed.exists() ? logFileCompressed : new File(runDir, "log.log");
        this.writeLog(resp, runDir, logFile, scenarioId + "_" + runId + ".log");
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/step-run-log"})
    public void stepRunLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId, @RequestParam String stepRunId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            if (!ScenarioController.checkCanAccessLogs(authCtx, resp)) {
                return;
            }
        }
        File runDir = ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId);
        File logFile = new File(runDir, "step_" + stepRunId + ".log");
        this.writeLog(resp, runDir, logFile, "step_" + stepRunId + ".log");
    }

    private void writeLog(HttpServletResponse resp, File runDir, File logFile, String filename) throws IOException {
        if (DKUFileUtils.isWithin((File)runDir, (File)(logFile = DKUFileUtils.getWithAutoDecompress((File)logFile))) && logFile.isFile() && logFile.canRead()) {
            resp.setContentType("text/plain; charset=UTF-8");
            resp.setHeader("Content-Disposition", "inline; filename=\"" + filename + ".log\"");
            resp.setStatus(200);
            try (InputStream fis = DKUFileUtils.readWithAutoDecompress((File)logFile);){
                IOUtils.copy((InputStream)fis, (OutputStream)resp.getOutputStream());
            }
        } else {
            resp.setStatus(404);
            resp.getWriter().write("run log not found " + logFile.getAbsolutePath());
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/load-kept-file"})
    public void loadKeptFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId, @RequestParam String stepName, @RequestParam(value="item") String itemData) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ReportTargetItem.KeptFileItem item = (ReportTargetItem.KeptFileItem)JSON.parse((String)itemData, ReportTargetItem.KeptFileItem.class);
        File runDir = DKUFileUtils.getWithin((File)ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId), (String[])new String[]{stepName});
        File file2 = file = item.path.startsWith("/") ? new File(item.path) : new File(runDir, item.path);
        if (DKUFileUtils.isWithin((File)runDir, (File)file) && file.isFile() && file.canRead()) {
            ScenarioController.writeJSON((HttpServletResponse)resp, (Object)Lists.newArrayList((Object[])new String[]{FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8)}));
        } else {
            resp.setStatus(404);
            resp.getWriter().write("File not found " + file.getAbsolutePath());
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-history", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}"})
    @RequestMapping(value={"/api/scenarios/download-kept-file"})
    public void downloadKeptFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId, @RequestParam String stepName, @RequestParam(value="item") String itemData) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPermNoXSRF(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ReportTargetItem.KeptFileItem item = (ReportTargetItem.KeptFileItem)JSON.parse((String)itemData, ReportTargetItem.KeptFileItem.class);
        File runDir = DKUFileUtils.getWithin((File)ScenarioRunContext.scenarioRunFolder(projectKey, scenarioId, runId), (String[])new String[]{stepName});
        File file2 = file = item.path.startsWith("/") ? new File(item.path) : new File(runDir, item.path);
        if (DKUFileUtils.isWithin((File)runDir, (File)file) && file.isFile() && file.canRead()) {
            this.writeFileForDownload(resp, file, item.mimeType, file.getName());
        } else {
            resp.setStatus(404);
            resp.getWriter().write("File not found " + file.getAbsolutePath());
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/scenarios/list-report-templates"})
    public void listReportTemplates(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
        }
        TemplatesDAO templatesDAO = new TemplatesDAO();
        ScenarioController.writeJSON((HttpServletResponse)resp, templatesDAO.list(TemplatesDAO.TemplateType.SCENARIO));
    }

    @AuditedCall(value={"msgType", "scenario-add-items", "items", "${items}", "options", "${options}"})
    @RequestMapping(value={"/api/scenarios/add-to-scenario"})
    public void addToScenario(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam String options) throws Exception {
        List refs = (List)JSON.parse((String)items, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        ScenariosService.AddToScenarioOptions parsedOptions = (ScenariosService.AddToScenarioOptions)JSON.parse((String)options, ScenariosService.AddToScenarioOptions.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkAllWritePermissions(refs, authCtx);
            this.scenariosService.addToScenario(refs, parsedOptions);
            t.commit("Add " + refs.size() + " items to scenario " + parsedOptions.scenarioId);
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-run-report", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}"})
    @RequestMapping(value={"/api/scenarios/scenario-run-report"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadScenarioRunReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId) throws IOException, DKUSecurityException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScenariosService.ScenarioRunDetails runDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, false);
        if (runDetails.scenarioRun == null) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Run %s of scenario %s not found", runId, scenarioId));
            return;
        }
        String reportFileStem = String.format("%s-%s-test-scenario-report", scenarioId, runId);
        String reportFileName = String.format("%s.xml", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"xml");){
            this.scenariosService.createTestScenarioRunReportFile(runDetails.scenarioRun, runDetails.stepRuns, (File)tmpFile);
            this.writeFileForDownload(resp, (File)tmpFile, "application/xml", reportFileName);
        }
    }

    @AuditedCall(value={"msgType", "scenario-get-step-run-report", "projectKey", "${projectKey}", "scenarioId", "${scenarioId}", "runId", "${runId}", "stepId", "${stepId}"})
    @RequestMapping(value={"/api/scenarios/step-run-report"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadStepRunReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String scenarioId, @RequestParam String runId, @RequestParam String stepId) throws IOException, DKUSecurityException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ScenariosService.ScenarioRunDetails runDetails = this.scenariosService.getScenarioRunDetails(projectKey, scenarioId, runId, false);
        if (Objects.isNull(runDetails.scenarioRun)) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Run %s of scenario %s not found", runId, scenarioId));
            return;
        }
        StepRun stepRun = runDetails.stepRuns.stream().filter(sr -> sr.getStep().getId().equals(stepId)).findFirst().orElse(null);
        if (Objects.isNull(stepRun)) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("Step %s was not run in run %s of scenario %s", stepId, runId, scenarioId));
            return;
        }
        if (!PytestStepRunner.META.getType().equals(stepRun.getStep().getType())) {
            resp.setStatus(404);
            resp.getWriter().write("Step run reports are only available for Python Unit Test steps");
            return;
        }
        ReportItem.RanPythonUnitTest ranPythonUnitTest = this.scenariosService.findRanPythonUnitTestItem(stepRun.getAdditionalReportItems()).orElse(null);
        if (Objects.isNull(ranPythonUnitTest) || StringUtils.isEmpty((String)ranPythonUnitTest.getRunReport())) {
            resp.setStatus(404);
            resp.getWriter().write(String.format("No report file found for step %s in run %s of scenario %s", stepId, runId, scenarioId));
            return;
        }
        String xmlReport = ranPythonUnitTest.getRunReport();
        this.writeStream(resp, new ByteArrayInputStream(xmlReport.getBytes(StandardCharsets.UTF_8)), "application/xml", String.format("step-run-report-%s-%s-%s.xml", scenarioId, runId, stepRun.getStep().getName()));
    }

    @AuditedCall(value={"msgType", "get-last-test-scenario-runs-report", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/scenarios/last-test-scenario-runs-report"}, method={RequestMethod.GET})
    public void downloadLastTestScenarioRunsReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, IOException, SQLException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        String reportFileStem = bundleId != null ? String.format("%s-%s-test-scenarios-report", projectKey, bundleId) : String.format("%s-test-scenarios-report", projectKey);
        String reportFileName = String.format("%s.xml", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"xml");){
            if (bundleId != null) {
                this.scenariosService.createTestScenarioRunsReportFileForBundle(projectKey, bundleId, (File)tmpFile);
            } else {
                this.scenariosService.createTestScenarioRunsReportFileForProject(projectKey, (File)tmpFile);
            }
            this.writeFileForDownload(resp, (File)tmpFile, "application/xml", reportFileName);
        }
    }

    @AuditedCall(value={"msgType", "get-last-test-scenario-runs-html-report", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/scenarios/last-test-scenario-runs-html-report"}, method={RequestMethod.GET})
    public void downloadLastTestScenarioRunsHTMLReport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String bundleId) throws DKUSecurityException, IOException, SQLException, TemplateException {
        String nodeId;
        String userName;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            userName = authCtx.getAssociatedDSSUser();
            nodeId = ApplicationConfigurator.getNodeId();
        }
        String reportFileStem = bundleId != null ? String.format("%s-%s-test-scenarios-report", projectKey, bundleId) : String.format("%s-test-scenarios-report", projectKey);
        String reportFileName = String.format("%s.html", reportFileStem);
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"test-reports", (String)reportFileStem, (String)"html");){
            this.scenariosService.createTestScenarioRunsHTMLReportFile(projectKey, bundleId, nodeId, userName, (File)tmpFile);
            this.writeFileForDownload(resp, (File)tmpFile, "text/html", reportFileName);
        }
    }

    private void setScenarioUnavailabilityInfo(ScenarioUnavailabilityInfo scenarioUnavailabilityInfo) {
        try (Transaction t = this.transactionService.beginRead();){
            scenarioUnavailabilityInfo.unavailableSteps = this.scenariosService.getUnavailableSteps(scenarioUnavailabilityInfo.scenario);
            scenarioUnavailabilityInfo.unavailableTriggerIds = this.scenariosService.getUnavailableTriggers(scenarioUnavailabilityInfo.scenario);
        }
    }

    private void createGitCommit(RWTransaction t, TaggableObjectsService.TaggableObjectSaveInfo si, String projectKey, Scenario scenario) throws TransactionFailedException, TransactionGitException {
        if (si.summaryOnly) {
            t.commit("Updated summary for scenario " + projectKey + "." + scenario.name + " (id: " + scenario.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        } else if (StringUtils.isNotBlank((String)si.commitMessage)) {
            t.commit(si.commitMessage);
        } else {
            t.commit("Saved scenario " + projectKey + "." + scenario.name + " (id: " + scenario.id + ")", 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
        }
    }

    private void checkAllWritePermissions(List<TaggableObjectsService.TaggableObjectRef> refs, AuthCtx authCtx) throws DKUSecurityException {
        HashSet<String> authorized = new HashSet<String>();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            if (authorized.contains(ref.projectKey)) continue;
            this.projectsService.checkPerm(authCtx, ref.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authorized.add(ref.projectKey);
        }
    }

    private static boolean checkCanAccessLogs(AuthCtx authCtx, HttpServletResponse resp) throws IOException {
        if (!ScenarioController.canAccessLogs(authCtx)) {
            resp.setStatus(403);
            resp.setContentType("text/plain; charset=UTF-8");
            resp.getWriter().write("Logs visibility is restricted. Contact your administrator if you need to access these logs");
            return false;
        }
        return true;
    }

    private static boolean canAccessLogs(AuthCtx authCtx) {
        return !ApplicationConfigurator.hideLogs() || authCtx.isAdmin();
    }

    public static class ScenarioHead {
        public String projectKey;
        public String id;
        public String name;
        public String type;

        ScenarioHead(Scenario scenario) {
            this.projectKey = scenario.projectKey;
            this.id = scenario.id;
            this.name = scenario.name;
            this.type = scenario.type;
        }
    }

    public static class ScenarioRunWithFuture
    extends ScenarioRun {
        public boolean isRunning;
        public String futureId;
        public boolean aborted;

        public ScenarioRunWithFuture(ScenarioRun scenarioRun) {
            super(scenarioRun);
        }
    }

    public static class ScenarioSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        List<StepMeta.UnavailableStepInfo> unavailableSteps = new ArrayList<StepMeta.UnavailableStepInfo>();
        List<String> unavailableTriggerIds = new ArrayList<String>();
    }

    public static class ScenarioPayload {
        public String script;
    }

    public static class ScenarioUnavailabilityInfo {
        Scenario scenario;
        List<StepMeta.UnavailableStepInfo> unavailableSteps = new ArrayList<StepMeta.UnavailableStepInfo>();
        List<String> unavailableTriggerIds = new ArrayList<String>();
    }

    private class ScenarioRunWaiter
    extends SimpleFutureThread<ScenariosService.ScenarioRunDetails> {
        private final TriggerFire triggerFire;
        private final boolean waitForCompletion;

        public ScenarioRunWaiter(AuthCtx owner, TriggerFire fire, boolean waitForCompletion) {
            super(owner);
            this.triggerFire = fire;
            this.waitForCompletion = waitForCompletion;
        }

        @Override
        protected ScenariosService.ScenarioRunDetails compute() throws Exception {
            ScenariosService.ScenarioRunDetails details;
            while (true) {
                details = ScenarioController.this.scenariosService.getScenarioRunStartedByTriggerFire(this.triggerFire.projectKey, this.triggerFire.scenarioId, this.triggerFire.trigger.id, this.triggerFire.runId);
                if (details.scenarioRun != null) {
                    if (this.waitForCompletion) break;
                    return details;
                }
                Thread.sleep(2000L);
            }
            while (true) {
                details = ScenarioController.this.scenariosService.getScenarioRunStartedByTriggerFire(this.triggerFire.projectKey, this.triggerFire.scenarioId, this.triggerFire.trigger.id, this.triggerFire.runId);
                if (details.scenarioRun != null && details.scenarioRun.result != null) {
                    return details;
                }
                Thread.sleep(5000L);
            }
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"wait_scenario_run", (String)"Wait for scenario to complete");
        }
    }
}

