/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationComparatorsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ObjectFinder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SearchController
extends DIPInternalControllerBase {
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private InsightsDAO insightsDAO;
    @Autowired
    private ManagedFolderDAO managedFoldersDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private ReportsDAO reportsDAO;
    @Autowired
    private ArticlesDAO articlesDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private ZonesDAO zonesDAO;
    @Autowired
    private ModelEvaluationComparatorsDAO modelEvaluationComparatorsDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    private Comparator<SearchHit> comparator = new Comparator<SearchHit>(){

        @Override
        public int compare(SearchHit a, SearchHit b) {
            return a.score > b.score ? -1 : (a.score < b.score ? 1 : (a.lastModified > b.lastModified ? -1 : (a.lastModified < b.lastModified ? 1 : 0)));
        }
    };
    static DKULogger logger = DKULogger.getLogger((String)"dku.search");

    private int matchScore(String name, String key, String type, String subtype, Object object, String[] tokens, List<String> recentKeys) {
        int score = 0;
        for (String token : tokens) {
            if (StringUtils.isBlank((String)token)) {
                return 0;
            }
            boolean tokenMatches = false;
            if (StringUtils.startsWithIgnoreCase((String)type, (String)token)) {
                tokenMatches = true;
                score += 100;
            }
            if (StringUtils.startsWithIgnoreCase((String)subtype, (String)token)) {
                tokenMatches = true;
                score += 100;
            }
            if (StringUtils.startsWithIgnoreCase((String)name, (String)token)) {
                tokenMatches = true;
                score = (int)((long)score + (200L + Math.round(2000.0 / (double)name.length())));
            } else if (name.contains(token)) {
                tokenMatches = true;
                score += 200;
            } else if (ObjectFinder.matches(object, token)) {
                tokenMatches = true;
                score += 50;
            }
            if (tokenMatches) continue;
            return 0;
        }
        if (recentKeys.contains(key)) {
            score = (int)((long)score + Math.round(200.0 / (double)(1 + recentKeys.indexOf(key))));
        }
        switch (type.toLowerCase()) {
            case "dataset": {
                score += 10;
                break;
            }
            case "analysis": {
                score += 9;
                break;
            }
            case "sql_notebook": 
            case "jupyter_notebook": {
                score += 9;
            }
        }
        return score;
    }

    private SearchHit taggableObjectMatch(TaggableObjectsService.TaggableObject object, String[] tokens, List<String> recentIds) {
        String key = this.getKey(object.getProjectKey(), object.getId(), object.getTaggableType());
        String type = object.getTaggableType().name();
        String subtype = object.getSubtype();
        int score = this.matchScore(object.getDisplayName(), key, type, subtype, object, tokens, recentIds);
        if (score > 0) {
            return new SearchHit(object.getTaggableType(), object.getProjectKey(), object.getId(), object.getDisplayName(), score, 42L, object.getSubtype(), object.tags);
        }
        return null;
    }

    private List<SearchHit> taggableObjectsMatches(List<? extends TaggableObjectsService.TaggableObject> objects, String[] tokens, List<String> recentKeys) {
        ArrayList<SearchHit> ret = new ArrayList<SearchHit>();
        for (TaggableObjectsService.TaggableObject taggableObject : objects) {
            SearchHit sh = this.taggableObjectMatch(taggableObject, tokens, recentKeys);
            if (sh == null) continue;
            ret.add(sh);
        }
        return ret;
    }

    @AuditedCall(value={"msgType", "project-search", "projectKey", "${projectKey}", "query", "${query}"})
    @RequestMapping(value={"/api/home/project-search"})
    public void search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String query, @RequestParam(required=false, defaultValue="") String taggableType, @RequestParam(required=false, defaultValue="") String serializedRecentKeys, @RequestParam(required=false, defaultValue="20") int nb) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            ArrayList<String> recentKeys;
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ArrayList<SearchHit> magicItems = new ArrayList<SearchHit>();
            String[] tokens = null;
            if (StringUtils.isNotBlank((String)serializedRecentKeys)) {
                Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                recentKeys = (List)new Gson().fromJson(serializedRecentKeys, listType);
            } else {
                recentKeys = new ArrayList();
            }
            if (query != null) {
                query = query.toLowerCase();
                tokens = query.trim().split("\\s+");
            }
            ITaggingService.TaggableType type = null;
            if (StringUtils.isNotBlank((String)taggableType)) {
                type = ITaggingService.TaggableType.valueOf(taggableType);
            }
            if (type == null) {
                magicItems.addAll(this.taggableObjectsMatches(this.datasetsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.recipesDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.sqlNotebooksDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.searchNotebooksDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.analysisCRUDService.listCoreUnsafe(projectKey, null), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.savedModelsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.modelEvaluationStoresDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.insightsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.managedFoldersDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.scenariosDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.dashboardsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.webAppsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.articlesDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.worksheetsService.listWorksheets(projectKey, null), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.modelEvaluationComparatorsDAO.listUnsafe(projectKey), tokens, recentKeys));
                magicItems.addAll(this.taggableObjectsMatches(this.labelingTasksDAO.listUnsafe(projectKey), tokens, recentKeys));
            } else {
                type.assertNotFakeType();
                switch (type) {
                    case ANALYSIS: {
                        magicItems.addAll(this.taggableObjectsMatches(this.analysisCRUDService.listCoreUnsafe(projectKey, null), tokens, recentKeys));
                        break;
                    }
                    case STATISTICS_WORKSHEET: {
                        magicItems.addAll(this.taggableObjectsMatches(this.worksheetsService.listWorksheets(projectKey, null), tokens, recentKeys));
                        break;
                    }
                    case DASHBOARD: {
                        magicItems.addAll(this.taggableObjectsMatches(this.dashboardsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case DATASET: {
                        magicItems.addAll(this.taggableObjectsMatches(this.datasetsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case INSIGHT: {
                        magicItems.addAll(this.taggableObjectsMatches(this.insightsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case JUPYTER_NOTEBOOK: {
                        magicItems.addAll(this.taggableObjectsMatches(this.jupyterService.listUnsafe(DSSAuthCtx.newNone(), projectKey), tokens, recentKeys));
                        break;
                    }
                    case MANAGED_FOLDER: {
                        magicItems.addAll(this.taggableObjectsMatches(this.managedFoldersDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case RECIPE: {
                        magicItems.addAll(this.taggableObjectsMatches(this.recipesDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case LABELING_TASK: {
                        magicItems.addAll(this.taggableObjectsMatches(this.labelingTasksDAO.listUnsafe(projectKey), tokens, recentKeys));
                    }
                    case SAVED_MODEL: {
                        magicItems.addAll(this.taggableObjectsMatches(this.savedModelsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        magicItems.addAll(this.taggableObjectsMatches(this.modelEvaluationStoresDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case SCENARIO: {
                        magicItems.addAll(this.taggableObjectsMatches(this.scenariosDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case SQL_NOTEBOOK: {
                        magicItems.addAll(this.taggableObjectsMatches(this.sqlNotebooksDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case SEARCH_NOTEBOOK: {
                        magicItems.addAll(this.taggableObjectsMatches(this.searchNotebooksDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case WEB_APP: {
                        magicItems.addAll(this.taggableObjectsMatches(this.webAppsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case REPORT: {
                        magicItems.addAll(this.taggableObjectsMatches(this.reportsDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case ARTICLE: {
                        magicItems.addAll(this.taggableObjectsMatches(this.articlesDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case LAMBDA_SERVICE: 
                    case STREAMING_ENDPOINT: 
                    case CODE_STUDIO: {
                        break;
                    }
                    case DATA_COLLECTION: {
                        throw new IllegalArgumentException("Cannot search for a data collection within a project");
                    }
                    case PROJECT: {
                        throw new IllegalArgumentException("Cannot search for a project within a project");
                    }
                    case FLOW_ZONE: {
                        magicItems.addAll(this.taggableObjectsMatches(this.zonesDAO.listUnsafe(projectKey), tokens, recentKeys));
                        break;
                    }
                    case MODEL_COMPARISON: {
                        magicItems.addAll(this.taggableObjectsMatches(this.modelEvaluationComparatorsDAO.listUnsafe(projectKey), tokens, recentKeys));
                    }
                }
            }
            Collections.sort(magicItems, this.comparator);
            SearchController.writeJSON((HttpServletResponse)resp, magicItems.subList(0, Math.min(nb, magicItems.size())));
        }
    }

    private String getKey(String projectKey, String name, ITaggingService.TaggableType type) {
        return projectKey + ":" + String.valueOf((Object)type) + ":" + name;
    }

    public static class SearchHit {
        public int score;
        public long lastModified;
        public ITaggingService.TaggableType type;
        public String projectKey;
        public String id;
        public String displayName;
        public String subtype;
        public List<String> tags = new ArrayList<String>();

        public SearchHit(ITaggingService.TaggableType type, String projectKey, String id, String displayName, int score, long lastModified, String subtype, List<String> tags) {
            this.type = type;
            this.projectKey = projectKey;
            this.id = id;
            this.displayName = displayName;
            this.score = score;
            this.lastModified = lastModified;
            this.subtype = subtype;
            this.tags = tags;
        }
    }
}

