/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.CallUsedByDashboard;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TimelinesController
extends DIPInternalControllerBase {
    @Autowired
    private TimelinesService timelineService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.timelines.controller");

    @CallUsedByDashboard
    @AuditedCall(value={"msgType", "project-read-timeline-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/timelines/get-for-project"})
    public void getForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="0") int from, @RequestParam(required=false, defaultValue="80") int limit) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        TimelinesController.writeJSON((HttpServletResponse)resp, (Object)this.timelineService.getProjectTimeline_NT(projectKey, from, limit));
    }

    @AuditedCall(value={"msgType", "project-read-timeline-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/timelines/get-for-object"})
    public void getForObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String objectType, @RequestParam String objectId, @RequestParam(required=false, defaultValue="0") int from, @RequestParam(required=false, defaultValue="80") int limit) throws Exception {
        ITaggingService.TaggableType taggableType = ITaggingService.TaggableType.valueOf(objectType);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(authCtx, SmartObjectRef.fromSmartName(taggableType, objectId), projectKey);
        }
        TimelinesService.TimelineWithVersioning timeline = this.timelineService.getObjectTimeline_NT(taggableType, projectKey, objectId, null, null, from, limit);
        TimelinesController.writeJSON((HttpServletResponse)resp, (Object)timeline);
    }
}

