/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.WorkspaceInviteEmailSendService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/workspaces"})
public class WorkspacesController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WorkspaceTimelinesService workspaceTimelinesService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private WorkspaceInviteEmailSendService workspaceInviteEmailSendService;

    @AuditedCall(value={"msgType", "workspace-list"})
    @RequestMapping(value={"/list"})
    public void listWorkspaces(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="READ") Privileges.WorkspaceLevelPrivilegeType accessLevel) throws Exception {
        List<Workspace> workspaceList;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            workspaceList = this.workspacesService.listAccessibleWorkspacesUnsafe(authCtx, accessLevel);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, workspaceList);
    }

    @AuditedCall(value={"msgType", "workspace-list"})
    @RequestMapping(value={"/list-all-keys"})
    public void listAllKeys(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<String> keys;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            keys = this.workspacesService.listWorkspaceKeys();
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditedCall(value={"msgType", "workspace-list-heads"})
    @ResponseBody
    @RequestMapping(value={"/list-heads"})
    public List<WorkspaceHead> listWorkspaceHeads(HttpServletRequest req, @RequestParam(defaultValue="READ") Privileges.WorkspaceLevelPrivilegeType accessLevel) throws Exception {
        List<Workspace> workspaceList;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            workspaceList = this.workspacesService.listAccessibleWorkspacesUnsafe(authCtx, accessLevel);
        }
        ArrayList<WorkspaceHead> res = new ArrayList<WorkspaceHead>(workspaceList.size());
        for (Workspace workspace : workspaceList) {
            try {
                res.add(new WorkspaceHead(workspace, this.workspaceTimelinesService.getWorkspaceLastModification_NT(workspace.workspaceKey), this.workspaceTimelinesService.getWorkspaceLastModificationForUser_NT(workspace.workspaceKey, authCtx.getAssociatedDSSUser())));
            }
            catch (CodedSQLException e) {
                logger.warn((Object)String.format("Error reading timeline info on workspace %s - ignore it", workspace.workspaceKey), (Throwable)e);
                res.add(new WorkspaceHead(workspace, -1L, -1L));
            }
        }
        return res;
    }

    @AuditedCall(value={"msgType", "workspace-get", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/get"})
    public void getWorkspace(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey) throws Exception {
        Workspace result;
        AuthCtx authCtx;
        WorkspaceInfo workspaceInfo = new WorkspaceInfo();
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWorkspacePerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            result = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, result);
        workspaceInfo.workspace = result;
        workspaceInfo.timeline = this.workspaceTimelinesService.getWorkspaceTimeline_NT(workspaceKey, 0, 100);
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)workspaceInfo);
    }

    @AuditedCall(value={"msgType", "workspace-object-get-thumbnail", "workspaceKey", "${workspaceKey}", "objectId", "${objectId}"})
    @RequestMapping(value={"/{workspaceKey}/thumbnail/{objectId}"})
    @ResponseBody
    public void getWorkspaceObjectThumbnail(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String objectId) throws Exception {
        Workspace workspace;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.workspacesService.checkPerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        Optional<Workspace.WorkspaceObject> workspaceObject = workspace.workspaceObjects.stream().filter(wo -> Objects.equals(wo.id, objectId)).peek(wo -> this.workspacesService.enrichDatastory(authCtx, (Workspace.WorkspaceObject)wo)).findFirst();
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)workspaceObject.map(object -> object.defaultThumbnailData).orElse(""));
    }

    @AuditedCall(value={"msgType", "workspace-create"})
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public void createWorkspace(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspace) throws Exception {
        DSSAuthCtx authCtx;
        Workspace wks = (Workspace)JSON.parse((String)workspace, Workspace.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!authCtx.getPermissions().mayCreateWorkspaces()) {
                throw new SecurityException("You may not create new workspaces");
            }
            this.workspacesService.createWorkspace(authCtx, wks);
            t.commit("Create workspace " + wks.workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.getWorkspace(authCtx, wks.workspaceKey));
    }

    @AuditedCall(value={"msgType", "workspace-update"})
    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    public void updateWorkspace(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspace) throws Exception {
        AuthCtx authCtx;
        Workspace wks = (Workspace)JSON.parse((String)workspace, Workspace.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = t.getUser();
            this.checkWorkspacePerm(authCtx, wks.workspaceKey, Privileges.WorkspaceLevelPrivilegeType.ADMIN);
            this.workspacesService.updateWorkspace(authCtx, wks);
            t.commit("Update workspace " + wks.workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.getWorkspace(authCtx, wks.workspaceKey));
    }

    @AuditedCall(value={"msgType", "workspace-resend-invitation-email", "workspaceKey", "${workspaceKey}", "email", "${email}"})
    @RequestMapping(value={"/resend-workspace-invitation-email"})
    public void resendWorkspaceInvitationEmail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam String email) throws IOException, DKUSecurityException {
        GeneralSettingsDAO.GeneralSettings gs;
        AuthCtx authCtx;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)email), (Object)"Missing email address");
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWorkspacePerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.ADMIN);
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        }
        AbstractInviteEmailSendService.InvitationEmailSendResult result = new AbstractInviteEmailSendService.InvitationEmailSendResult();
        this.workspaceInviteEmailSendService.sendInviteEmails(result, workspaceKey, email, authCtx.getIdentifier(), gs);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            Workspace workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey, true, false);
            BasePermissions.PermissionItem matchingPendingEmailPermission = workspace.permissions.stream().filter(item -> item != null && email.equalsIgnoreCase(item.pendingUserEmail)).findFirst().orElse(null);
            if (matchingPendingEmailPermission == null) {
                throw new IllegalArgumentException(String.format("No matching pending email permission found on workspace %s for email %s", workspaceKey, email));
            }
            this.workspaceInviteEmailSendService.updateEmailStatusesAndSaveWorkspace(workspaceKey, authCtx.getIdentifier(), result);
            t.commit("Sent workspace invitation emails");
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditedCall(value={"msgType", "workspace-delete", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public void deleteWorkspace(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey) throws Exception {
        Workspace workspace;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWorkspacePerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.ADMIN);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey, false, false);
        }
        this.workspacesService.deleteDatastories(authCtx, workspace, workspace.workspaceObjects, true);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.workspacesService.deleteWorkspace(workspaceKey);
            t.commit("Delete workspace " + workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)"");
    }

    @AuditedCall(value={"msgType", "workspace-get-object", "workspaceKey", "${workspaceKey}", "objectKey", "${objectKey}"})
    @RequestMapping(value={"/get-object"})
    public void getWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam Workspace.WorkspaceObject objectKey) throws Exception {
        AuthCtx authCtx;
        WorkspaceObjectInfo workspaceObjectInfo = new WorkspaceObjectInfo();
        workspaceObjectInfo.workspaceKey = workspaceKey;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWorkspacePerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            workspaceObjectInfo.object = this.workspacesService.getWorkspaceObjectMandatory(authCtx, workspaceKey, objectKey);
            workspaceObjectInfo.workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspaceKey, workspaceObjectInfo.object);
        this.workspacesService.enrichWithInterest_NT(authCtx, workspaceObjectInfo.workspace);
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)workspaceObjectInfo);
    }

    @AuditedCall(value={"msgType", "workspace-update-object", "workspaceKey", "${workspaceKey}", "object", "${object}"})
    @RequestMapping(value={"/update-object"}, method={RequestMethod.PUT})
    public void updateWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam Workspace.WorkspaceObject object) throws Exception {
        Workspace workspace;
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.checkWorkspacePerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.WRITE);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        this.workspacesService.updateDatastory(authCtx, workspace, object);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            if (StringUtils.isBlank((String)object.customName)) {
                object.customName = null;
            }
            this.workspacesService.updateWorkspaceObject(authCtx, workspace, object);
            t.commit("Editing object's name " + object.customName);
        }
        WorkspaceObjectInfo workspaceObjectInfo = new WorkspaceObjectInfo();
        workspaceObjectInfo.workspaceKey = workspaceKey;
        workspaceObjectInfo.workspace = workspace;
        workspaceObjectInfo.object = object;
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)workspaceObjectInfo);
    }

    @AuditedCall(value={"msgType", "add-objects-to-workspace"})
    @RequestMapping(value={"/add-objects"}, method={RequestMethod.POST})
    public void addObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam List<Workspace.WorkspaceObject> workspaceObjects) throws Exception {
        Workspace workspace;
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            List<Workspace.WorkspaceObject> workspaceObjectsNeedsRightsCheck = WorkspacesController.collectShareToWorkspacesRights(workspaceObjects);
            if (!workspaceObjectsNeedsRightsCheck.isEmpty()) {
                if (!authCtx.getPermissions().mayShareToWorkspaces()) {
                    throw new SecurityException("You may not share objects to workspaces");
                }
                for (String projectKey : WorkspacesController.collectProjectKeys(workspaceObjectsNeedsRightsCheck)) {
                    this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.SHARE_TO_WORKSPACES);
                }
            }
            this.workspacesService.checkPerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.WRITE);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        this.workspacesService.createDatastories(authCtx, workspace, workspaceObjects);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.workspacesService.addObjects((AuthCtx)authCtx, workspace, workspaceObjects);
            t.commit("Share objects in workspace " + workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.getWorkspace(authCtx, workspaceKey));
    }

    @AuditedCall(value={"msgType", "duplicate-objects-in-workspace"})
    @RequestMapping(value={"/duplicate-objects"}, method={RequestMethod.POST})
    public void duplicateObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam List<Workspace.WorkspaceObject> objectsToDuplicate) throws Exception {
        Workspace workspace;
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.workspacesService.checkPerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.WRITE);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        this.workspacesService.duplicateDatastories(authCtx, workspace, objectsToDuplicate);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.workspacesService.addObjects((AuthCtx)authCtx, workspace, objectsToDuplicate);
            t.commit("Duplicate objects in workspace " + workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.getWorkspace(authCtx, workspaceKey));
    }

    @AuditedCall(value={"msgType", "remove-objects-from-workspace"})
    @RequestMapping(value={"/remove-objects"}, method={RequestMethod.POST})
    public void removeObjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey, @RequestParam List<Workspace.WorkspaceObject> objectsToRemove) throws Exception {
        Workspace workspace;
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.workspacesService.checkPerm(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.WRITE);
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        this.workspacesService.deleteDatastories(authCtx, workspace, objectsToRemove);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.workspacesService.removeObjects((AuthCtx)authCtx, workspaceKey, objectsToRemove);
            t.commit("Remove objects from workspace " + workspaceKey);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.getWorkspace(authCtx, workspaceKey));
    }

    @AuditedCall(value={"msgType", "timeline-get", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/timeline"})
    public void getTimeline(HttpServletRequest req, HttpServletResponse resp, @RequestParam String workspaceKey) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.checkWorkspacePerm(req, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
        }
        WorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.workspaceTimelinesService.getWorkspaceTimeline_NT(workspaceKey, 0, 100));
    }

    private Workspace getWorkspace(AuthCtx authCtx, String workspaceKey) throws IOException, SQLException {
        Workspace workspace;
        try (Transaction ignored = this.transactionService.beginRead();){
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        return workspace;
    }

    private void checkWorkspacePerm(AuthCtx authCtx, String workspaceKey, Privileges.WorkspaceLevelPrivilegeType privilege) throws DKUSecurityException {
        this.workspacesService.checkPerm(authCtx, workspaceKey, privilege);
    }

    private void checkWorkspacePerm(HttpServletRequest req, String workspaceKey, Privileges.WorkspaceLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        AuthCtx authCtx = this.authService.getMandatoryUser(req);
        this.checkWorkspacePerm(authCtx, workspaceKey, privilege);
    }

    private static Set<String> collectProjectKeys(List<Workspace.WorkspaceObject> objectsToShare) {
        HashSet<String> affectedProjectKeys = new HashSet<String>();
        for (Workspace.WorkspaceObject tor : objectsToShare) {
            if (tor.reference == null) continue;
            affectedProjectKeys.add(tor.reference.projectKey);
        }
        return affectedProjectKeys;
    }

    private static List<Workspace.WorkspaceObject> collectShareToWorkspacesRights(List<Workspace.WorkspaceObject> objects) {
        ArrayList<Workspace.WorkspaceObject> workspaceObjects = new ArrayList<Workspace.WorkspaceObject>();
        for (Workspace.WorkspaceObject wo : objects) {
            if (!WorkspacesService.needsShareToWorkspaceRights(wo)) continue;
            workspaceObjects.add(wo);
        }
        return workspaceObjects;
    }

    @UIModel
    public static class WorkspaceHead {
        public String workspaceKey;
        public String displayName;
        public String description;
        public String shortDesc;
        public String color;
        List<BasePermissions.PermissionItem> permissions;
        public long lastModifiedOn;
        public long lastModifiedByCurrentUser;

        public WorkspaceHead(Workspace workspace, long lastModifiedOn, long lastModifiedByCurrentUser) {
            this.workspaceKey = workspace.workspaceKey;
            this.displayName = workspace.displayName;
            this.description = workspace.description;
            this.shortDesc = workspace.shortDesc;
            this.color = workspace.color;
            this.permissions = workspace.permissions;
            this.lastModifiedOn = lastModifiedOn;
            this.lastModifiedByCurrentUser = lastModifiedByCurrentUser;
        }
    }

    public static class WorkspaceInfo {
        public Workspace workspace;
        public WorkspaceTimelinesService.WorkspaceTimelineWithVersioning timeline;
    }

    public static class WorkspaceObjectInfo {
        public String workspaceKey;
        public Workspace workspace;
        public Workspace.WorkspaceObject object;
    }
}

