/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.llm;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.llm.promptstudio.PromptComparisonEngine;
import com.dataiku.dip.llm.promptstudio.PromptComparisonResponse;
import com.dataiku.dip.llm.promptstudio.PromptExecutionEngine;
import com.dataiku.dip.llm.promptstudio.PromptResponse;
import com.dataiku.dip.llm.promptstudio.PromptResponsePreview;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudiosCRUDService;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipePayloadParams;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PromptStudiosController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PromptStudioDAO promptStudiosDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private PromptStudiosCRUDService crudService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @AuditedCall(value={"msgType", "promptstudios-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/prompt-studios/list"})
    @ResponseBody
    public List<PromptStudio> list(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            List<PromptStudio> list = this.promptStudiosDAO.listUnsafe(projectKey);
            return list;
        }
    }

    @AuditedCall(value={"msgType", "promptstudios-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/prompt-studios/list-heads"})
    @ResponseBody
    public List<PromptStudio.PromptStudioListItem> listHeads(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        ArrayList<PromptStudio.PromptStudioListItem> heads = new ArrayList<PromptStudio.PromptStudioListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List list = this.promptStudiosDAO.listUnsafe(projectKey);
            for (PromptStudio promptStudio : list) {
                PromptStudio.PromptStudioListItem item = new PromptStudio.PromptStudioListItem(promptStudio);
                this.taggableObjectsService.setEditionInfoFromTags(promptStudio, item);
                heads.add(item);
            }
        }
        this.interestsService.enrichListItems(authCtx.getAssociatedDSSUser(), projectKey, heads);
        return heads;
    }

    @AuditedCall(value={"msgType", "prompt-studio-get", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/prompt-studios/get"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptStudio getPromptStudio(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            PromptStudio promptStudio = (PromptStudio)this.promptStudiosDAO.getMandatoryUnsafe(projectKey, id);
            return promptStudio;
        }
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-metadata", "projectKey", "${projectKey}", "promptStudioId", "${id}"})
    @RequestMapping(value={"/api/prompt-studios/get-full-info"})
    @ResponseBody
    public NavigatorService.PromptStudioFullInfo getFullInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.PromptStudioFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoTaggableObjectReadUseAccess(u, ITaggingService.TaggableType.PROMPT_STUDIO, loc, projectKey);
            info = this.navigatorService.getPromptStudioFullInfo(projectKey, id);
        }
        this.navigatorService.addInfo_NT(info, u);
        return info;
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Id create(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            Id newId = new Id(this.crudService.create(user, projectKey, name));
            t.commit("Create prompt studio " + newId.id + " (" + name + ")");
            this.auditTrailService.generic("prompt-studio-create").with("projectKey", projectKey).with("promptStudioId", newId.id).emit();
            Id id = newId;
            return id;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam PromptStudio promptStudio, @RequestParam(required=false, defaultValue="{}") TaggableObjectsService.TaggableObjectSaveInfo saveInfo) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(t.getUser(), promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(t.getUser());
            this.crudService.save(promptStudio, saveInfo.summaryOnly);
            t.commit("Saved prompt studio " + promptStudio.id);
            this.auditTrailService.generic("prompt-studio-save").with("projectKey", promptStudio.projectKey).with("promptStudioId", promptStudio.id).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/copy"}, method={RequestMethod.POST})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String promptStudioId) throws Exception {
        Id id;
        PromptStudio copiedPromptStudio;
        PromptStudio promptStudio;
        AuthCtx user;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            promptStudio = (PromptStudio)this.promptStudiosDAO.getMandatoryUnsafe(projectKey, promptStudioId);
            copiedPromptStudio = this.crudService.copy(user, promptStudio, projectKey);
            id = new Id(copiedPromptStudio.id);
            t.commit("Duplicated prompt studio " + projectKey + "." + promptStudioId + " to " + projectKey + "." + id.id);
        }
        this.auditTrailService.generic("prompt-studio-duplicate").with("projectKey", projectKey).with("originalPromptStudioId", promptStudioId).with("newPromptStudioId", id.id).emit();
        if (promptStudio != null && copiedPromptStudio != null) {
            this.crudService.copyChatResponses(user, promptStudio, copiedPromptStudio);
        }
        PromptStudiosController.writeJSON((HttpServletResponse)resp, (Object)id);
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-responses", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}"})
    @RequestMapping(value={"/api/prompt-studios/get-prompt-history"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptStudio.PromptStudioPromptHistory getPromptHistory(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String promptStudioId, @RequestParam String promptId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.crudService.getPromptHistory(projectKey, promptStudioId, promptId);
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-responses", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}"})
    @RequestMapping(value={"/api/prompt-studios/get-prompt-last-response"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptResponse getPromptLastRespone(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String promptStudioId, @RequestParam String promptId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.crudService.getLastResponse(projectKey, promptStudioId, promptId);
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-responses", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}"})
    @RequestMapping(value={"/api/prompt-studios/get-prompt-history-response"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptResponse getPromptHistoryResponse(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String promptStudioId, @RequestParam String promptId, @RequestParam String promptRunId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        return this.crudService.getHistoryResponse(projectKey, promptStudioId, promptId, promptRunId);
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/revert-prompt"}, method={RequestMethod.POST})
    @ResponseBody
    public PromptStudio revertPastRun(HttpServletRequest req, @RequestParam String projectKey, @RequestParam PromptStudio promptStudio, @RequestParam String promptId, @RequestParam String promptRunId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.auditTrailService.generic("prompt-studio-revert").with("projectKey", projectKey).with("promptStudioId", promptStudio.id).emit();
            PromptStudio revertedPromptStudio = this.crudService.revertToPastRun(projectKey, promptStudio, promptId, promptRunId);
            t.commit("Reverted run " + promptRunId + " on prompt studio " + revertedPromptStudio.id);
            PromptStudio promptStudio2 = revertedPromptStudio;
            return promptStudio2;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/start-execute-prompt"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<PromptResponse> runPrompt(HttpServletRequest req, final @RequestParam PromptStudio promptStudio, final @RequestParam PromptStudio.PromptStudioPrompt prompt) throws Exception {
        AuthCtx authCtx = null;
        long time = System.currentTimeMillis();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = t.getUser();
            this.projectsService.checkPerm(t.getUser(), promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(t.getUser());
            this.promptStudiosDAO.save(promptStudio);
            t.commit("Saved prompt studio " + promptStudio.id);
        }
        final String runId = this.crudService.addToPromptHistory(authCtx, time, promptStudio.projectKey, promptStudio.id, prompt);
        this.auditTrailService.generic("prompt-studio-start-execute").with("projectKey", promptStudio.projectKey).with("promptStudioId", promptStudio.id).emit();
        SimpleFutureThread<PromptResponse> t = new SimpleFutureThread<PromptResponse>(authCtx){

            @Override
            protected PromptResponse compute() throws Exception {
                ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forPromptStudio((AuthCtx)this.owner, (String)promptStudio.projectKey, (String)promptStudio.id);
                CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                PromptExecutionEngine pee = new PromptExecutionEngine(this.owner, promptStudio, prompt);
                pee.setPromptRunId(runId);
                PromptResponse response = pee.respond();
                PromptStudiosController.this.crudService.saveLastResponse(promptStudio.projectKey, promptStudio.id, prompt.id, response);
                PromptStudiosController.this.crudService.updatePromptHistory(this.owner, promptStudio.projectKey, promptStudio.id, prompt.id, runId, response);
                return response;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"execute-prompt", (String)"Execute prompt from prompt studio");
            }
        };
        return this.futureService.runFuture(t, 0L, new TypeToken<FutureResponse<PromptResponse>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/start-execute-comparison"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<PromptComparisonResponse> runComparison(HttpServletRequest req, final @RequestParam PromptStudio promptStudio, final @RequestParam JSON.StringList promptIds) throws Exception {
        AuthCtx authCtx = null;
        long time = System.currentTimeMillis();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = t.getUser();
            this.projectsService.checkPerm(t.getUser(), promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.auditTrailService.generic("prompt-studio-start-compare").with("projectKey", promptStudio.projectKey).with("promptStudioId", promptStudio.id).emit();
        final AuthCtx fAuthCtx = authCtx;
        SimpleFutureThread<PromptComparisonResponse> t = new SimpleFutureThread<PromptComparisonResponse>(authCtx){

            @Override
            protected PromptComparisonResponse compute() throws Exception {
                ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forPromptStudio((AuthCtx)this.owner, (String)promptStudio.projectKey, (String)promptStudio.id);
                CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                PromptComparisonEngine pee = new PromptComparisonEngine(fAuthCtx, promptStudio, (List<String>)promptIds);
                return pee.respond();
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"execute-prompt", (String)"Execute prompt from prompt studio");
            }
        };
        return this.futureService.runFuture(t, 0L, new TypeToken<FutureResponse<PromptComparisonResponse>>(){});
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-prompt-dataset-preview", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}"})
    @RequestMapping(value={"/api/prompt-studios/get-prompt-dataset-preview"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<PromptResponsePreview> getPromptDatasetPreview(HttpServletRequest req, final @RequestParam PromptStudio promptStudio, final @RequestParam PromptStudio.PromptStudioPrompt prompt) throws Exception {
        AuthCtx authCtx;
        try (Object t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        t = new SimpleFutureThread<PromptResponsePreview>(authCtx){

            @Override
            protected PromptResponsePreview compute() throws Exception {
                ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forPromptStudio((AuthCtx)this.owner, (String)promptStudio.projectKey, (String)promptStudio.id);
                CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
                PromptExecutionEngine pee = new PromptExecutionEngine(authCtx, promptStudio, prompt);
                return pee.getPromptDatasetPreview();
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"prompt-dataset-preview", (String)"Get preview of prompt dataset in prompt studio");
            }
        };
        return this.futureService.runFuture(t, 0L, new TypeToken<FutureResponse<PromptResponsePreview>>(){});
    }

    @AuditedCall(value={"msgType", "prompt-studio-clear-response", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}"})
    @RequestMapping(value={"/api/prompt-studios/clear-last-response"}, method={RequestMethod.POST})
    public void clearLastResponse(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String promptStudioId, @RequestParam String promptId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = t.getUser();
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.crudService.deleteLastResponse(projectKey, promptStudioId, promptId);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/test-from-kb"}, method={RequestMethod.POST})
    @ResponseBody
    public PromptStudiosCRUDService.EditFromRecipeResult testFromKb(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String smRef, @RequestParam PromptStudiosCRUDService.PromptCreationSettings promptCreationSettings) throws Exception {
        PromptStudiosCRUDService.EditFromRecipeResult result;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(user);
            result = this.crudService.testFromKb(user, projectKey, smRef, promptCreationSettings);
            t.commit("Test prompt from saved model (RETRIEVAL_AUGMENTED_LLM) " + smRef + " in prompt studio " + result.promptStudioId);
        }
        return result;
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/edit-from-recipe"})
    @ResponseBody
    public PromptStudiosCRUDService.EditFromRecipeResult editFromRecipe(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam PromptStudiosCRUDService.PromptCreationSettings promptCreationSettings) throws Exception {
        PromptStudiosCRUDService.EditFromRecipeResult result;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            PromptRecipePayloadParams payload = (PromptRecipePayloadParams)JSON.parse((String)this.recipesDAO.getPayloadOrNull(projectKey, recipeName), PromptRecipePayloadParams.class);
            result = this.crudService.editFromRecipe(authCtx, projectKey, promptCreationSettings, payload, recipe);
            t.commit("Edit prompt from recipe " + recipeName + " in prompt studio " + result.promptStudioId);
        }
        this.auditTrailService.generic("prompt-recipe-edit-in-studio").with("projectKey", projectKey).with("originPromptRecipe", recipeName).with("promptStudioId", result.promptStudioId).emit();
        return result;
    }

    @AuditedCall(value={"msgType", "prompt-studio-overwrite-recipe", "projectKey", "${projectKey}", "recipeName", "${recipeName}", "promptStudioId", "${promptStudioId}", "promptStudioPromptId", "${promptStudioPromptId}"})
    @RequestMapping(value={"/api/prompt-studios/overwrite-recipe"}, method={RequestMethod.POST})
    public void overwriteRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName, @RequestParam String promptStudioId, @RequestParam String promptStudioPromptId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            PromptStudio ps2 = (PromptStudio)this.promptStudiosDAO.getMandatoryUnsafe(projectKey, promptStudioId);
            this.crudService.editRecipe(projectKey, ps2, promptStudioPromptId, recipeName);
            t.commit("Edit recipe " + recipeName + " from the prompt " + promptStudioPromptId + " in prompt studio " + promptStudioId);
        }
    }

    @AuditedCall(value={"msgType", "prompt-studio-get-recipe-payload", "projectKey", "${projectKey}", "promptStudioId", "${promptStudioId}", "promptStudioPromptId", "${promptStudioPromptId}"})
    @RequestMapping(value={"/api/prompt-studios/get-recipe-payload-from-prompt"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptRecipePayloadParams getRecipePayloadFromPrompt(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String promptStudioId, @RequestParam String promptStudioPromptId) throws Exception {
        PromptStudio ps2;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ps2 = (PromptStudio)this.promptStudiosDAO.getMandatoryUnsafe(projectKey, promptStudioId);
        }
        int promptIdx = this.crudService.findPromptIdx(ps2, promptStudioPromptId);
        return this.crudService.getRecipePayloadFromStudioPrompt(promptIdx, ps2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/streamed-completion"}, method={RequestMethod.POST})
    @ResponseBody
    public void streamCompletion(HttpServletRequest req, HttpServletResponse resp, @RequestParam PromptStudio promptStudio, @RequestParam PromptStudio.PromptStudioPrompt prompt) throws Exception {
        AuthCtx authCtx = null;
        long time = System.currentTimeMillis();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = t.getUser();
            this.projectsService.checkPerm(t.getUser(), promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(t.getUser());
            this.promptStudiosDAO.save(promptStudio);
            t.commit("Saved prompt studio " + promptStudio.id);
        }
        String runId = this.crudService.addToPromptHistory(authCtx, time, promptStudio.projectKey, promptStudio.id, prompt);
        this.auditTrailService.generic("prompt-studio-start-streaming").with("projectKey", promptStudio.projectKey).with("promptStudioId", promptStudio.id).emit();
        PromptExecutionEngine pee = new PromptExecutionEngine(authCtx, promptStudio, prompt);
        pee.setPromptRunId(runId);
        try (MiniSSEEmitter emitter = new MiniSSEEmitter(resp, 0L, true);){
            PromptResponse response = pee.streamChatResponse(emitter);
            this.crudService.saveLastResponse(promptStudio.projectKey, promptStudio.id, prompt.id, response);
            emitter.sendEventWithData("completion-response", JSON.json((Object)response), false);
        }
        catch (Exception e) {
            logger.error((Object)"Client disconnected", (Throwable)e);
        }
        finally {
            logger.info((Object)"streamed completion: done");
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/prompt-studios/fork-chat-session"}, method={RequestMethod.POST})
    @ResponseBody
    public void forkChatSession(HttpServletRequest req, HttpServletResponse resp, @RequestParam PromptStudio promptStudio, @RequestParam PromptStudio.PromptStudioPrompt prompt, @RequestParam String sourcePromptId, @RequestParam String sourceUserMessageId) throws Exception {
        AuthCtx authCtx = null;
        long time = System.currentTimeMillis();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = t.getUser();
            this.projectsService.checkPerm(t.getUser(), promptStudio.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(t.getUser());
            this.promptStudiosDAO.save(promptStudio);
            t.commit("Saved prompt studio " + promptStudio.id);
        }
        String runId = this.crudService.addToPromptHistory(authCtx, time, promptStudio.projectKey, promptStudio.id, prompt);
        this.auditTrailService.generic("prompt-studio-fork-session").with("projectKey", promptStudio.projectKey).with("promptStudioId", promptStudio.id).emit();
        PromptExecutionEngine pee = new PromptExecutionEngine(authCtx, promptStudio, prompt);
        pee.setPromptRunId(runId);
        PromptResponse response = this.crudService.getLastResponse(promptStudio.projectKey, promptStudio.id, sourcePromptId);
        pee.forkResponse(response, sourceUserMessageId);
        this.crudService.saveLastResponse(promptStudio.projectKey, promptStudio.id, prompt.id, response);
        PromptStudiosController.writeJSON((HttpServletResponse)resp, (Object)response);
    }
}

