/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class ConnectionChangedEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "connections-changed";
    private final String connectionName;
    private final String connectionType;
    private final String user;
    private final String userDisplayName;
    private final ActionType action;

    public ConnectionChangedEvent(String connectionName, String connectionType, String user, String userDisplayName, ActionType action) {
        this.connectionName = connectionName;
        this.connectionType = connectionType;
        this.user = user;
        this.userDisplayName = userDisplayName;
        this.action = action;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public ActionType getAction() {
        return this.action;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("%s %s %s connection %s", markup.user(this.user, this.userDisplayName), markup.text(this.action.toString().toLowerCase()), markup.text(this.connectionType), markup.connection(this.connectionName, this.connectionName));
    }

    public static enum ActionType {
        CREATED,
        EDITED,
        DELETED;

    }
}

