/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class PluginChangedEvent
extends BackendEvent
implements UserEvent,
EventWithHumanReadableString {
    public static final String NAME = "plugin-changed";
    public final String pluginId;
    public final ActionType action;
    public final String user;

    public PluginChangedEvent(String pluginId, ActionType action, String user) {
        this.pluginId = pluginId;
        this.action = action;
        this.user = user;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.user;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("%s %s plugin %s", markup.user(this.user, null), markup.text(this.action.toString().toLowerCase()), markup.plugin(this.pluginId, this.pluginId));
    }

    public static enum ActionType {
        CREATED,
        INSTALLED,
        EDITED,
        DELETED;

    }
}

