/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.ComputeImpactedInputPartitions;
import com.dataiku.dip.dataflow.ComputeImpactedOutputPartitions;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.dataflow.pdep.EvaluatorFactory;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GenericRecipesValidationService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ComputableFromRefService computableFromRefService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private FlowGraphService flowGraphService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.execution");

    public List<PdepTestEntry> prepareTestPdep(AuthCtx authCtx, SerializedRecipe recipe, String pdepInputRef, SerializedRecipe.SDep dep, PdepTestResult ret) throws Exception {
        ArrayList<PdepTestEntry> entries = new ArrayList<PdepTestEntry>();
        AnyLoc pdepInputLoc = AnyLoc.resolveSmart(recipe.getProjectKey(), pdepInputRef);
        recipe.name = "testRecipe";
        FlowGraph graph = new FlowGraph();
        FlowRecipe frecipe = graph.buildSingleRecipe(recipe);
        for (DimensionDependencySpec spec : frecipe.getPartitionDeps()) {
            DatasetLocUtils.DatasetLoc inputLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, spec.inputDataset);
            Partitionable partInput = this.datasetAccessService.getOrNull(inputLoc);
            if (partInput == null && (partInput = (Partitionable)this.managedFolderDAO.getOrNull(inputLoc)) == null && (partInput = (Partitionable)this.savedModelsDAO.getOrNull(inputLoc)) == null) {
                throw new NotFoundException("Input element element does not exist: " + inputLoc.getFullName());
            }
            if (pdepInputLoc.getFullName().equals(inputLoc.getFullName()) && spec.inputDimension.equals(dep.idim)) {
                Partitionable output = null;
                if (dep.out != null && (output = this.datasetAccessService.getOrNull(recipe.projectKey, dep.out)) == null && (output = (Partitionable)this.managedFolderDAO.getOrNull(recipe.projectKey, dep.out)) == null && (output = (Partitionable)this.savedModelsDAO.getOrNull(recipe.projectKey, dep.out)) == null && (output = (Partitionable)this.modelEvaluationStoresDAO.getOrNull(recipe.projectKey, dep.out)) == null) {
                    throw new NotFoundException("Output element does not exist: " + dep.out);
                }
                logger.info((Object)("Testing pdep: input=" + partInput.getFullName() + " dep= " + JSON.json((Object)spec)));
                DimensionDependencyEvaluator evaluator = null;
                try {
                    evaluator = EvaluatorFactory.build(authCtx, recipe.projectKey, this.variablesService, partInput, spec, recipe.redispatchPartitioning);
                }
                catch (IllegalArgumentException e) {
                    logger.warn((Object)"Pdep test failed", (Throwable)e);
                    ret.validationResult.withFatalV(RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    return null;
                }
                DimensionValue targetVal = null;
                if (dep.odim != null && output != null && output.getPartitioningSchema().isPartitioned()) {
                    Dimension odim = output.getPartitioningSchema().getDimension(dep.odim);
                    targetVal = Partition.randomSamplePartition((Dimension)odim);
                    ret.output = targetVal.id();
                }
                logger.info((Object)("Evaluating pdep: evaluator=" + String.valueOf(evaluator) + " targetVal=" + String.valueOf(targetVal) + " idim=" + JSON.json((Object)partInput.getPartitioningSchema().getDimension(dep.idim))));
                PdepTestEntry entry = new PdepTestEntry();
                entry.spec = spec;
                entry.inputDimension = partInput.getPartitioningSchema().getDimension(dep.idim);
                entry.targetVal = targetVal;
                entry.evaluator = evaluator;
                entries.add(entry);
                continue;
            }
            logger.debug((Object)("Pdep is not what we must test: candidate=" + JSON.json((Object)spec) + " toTest=" + JSON.json((Object)dep)));
        }
        return entries;
    }

    public void testPdep_NT(PdepTestResult ret, List<PdepTestEntry> entries) throws Exception {
        assert (!ret.validationResult.anyMessage);
        for (PdepTestEntry entry : entries) {
            logger.info((Object)("Evaluating pdep: evaluator=" + String.valueOf(entry.evaluator) + " targetVal=" + String.valueOf(entry.targetVal) + " idim=" + JSON.json((Object)entry.inputDimension)));
            try {
                List<DimensionValue> r2 = entry.evaluator.getDependent(entry.targetVal, entry.inputDimension);
                for (DimensionValue dv : r2) {
                    ret.sortedInputs.add(dv.id());
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Pdep test failed", (Throwable)e);
                ret.validationResult.withFatalV(RecipeCodes.ERR_RECIPE_INCONSISTENT_PDEP, "%s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
        }
    }

    public SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> getValidationRunnableSubgraph(AuthCtx authCtx, FlowRecipe recipe, String targetPartitionSpec) throws Exception {
        RecipeRunnableSubgraph realSubgraph;
        if (StringUtils.isBlank((String)targetPartitionSpec)) {
            targetPartitionSpec = null;
        }
        if ((realSubgraph = new RecipeRunnableSubgraph(recipe)).getTargets().size() == 0) {
            return new SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph>(){

                @Override
                public RecipeRunnableSubgraph call_NT() throws Exception {
                    return realSubgraph;
                }
            };
        }
        PartitionRefreshCommand prc = null;
        List<FlowPartitionable> flowPartitionables = realSubgraph.getPartitionedTargets();
        if (flowPartitionables.size() > 0) {
            Iterator<FlowPartitionable> iter = flowPartitionables.iterator();
            FlowPartitionable flowPartitionable = iter.next();
            PartitioningScheme scheme = flowPartitionable.getPartitioned(this.datasetsDAO).getPartitioningSchema();
            while (!scheme.isPartitioned() && iter.hasNext()) {
                flowPartitionable = iter.next();
                scheme = flowPartitionable.getPartitioned(this.datasetsDAO).getPartitioningSchema();
            }
            if (targetPartitionSpec == null && scheme.isPartitioned()) {
                targetPartitionSpec = Partition.randomSamplePartition((PartitioningScheme)scheme).id();
            }
            prc = new PartitionRefreshCommand((FlowComputable)((Object)flowPartitionable), PartitionFactory.fromPartitionSpec(scheme, targetPartitionSpec).get(0));
        } else {
            prc = new PartitionRefreshCommand(realSubgraph.getTargets().get(0), new Partition(null));
        }
        new ComputeImpactedOutputPartitions(this.datasetsDAO, prc, realSubgraph).compute();
        logger.info((Object)("computed output partitions: " + String.valueOf(realSubgraph.getTargetPartitions())));
        if (!recipe.isGenerator() && recipe.getPredecessors().size() > 0) {
            final ComputeImpactedInputPartitions ci = new ComputeImpactedInputPartitions(authCtx, realSubgraph, null);
            SpringUtils.getInstance().autowire((Object)ci);
            ci.prepare_T();
            return new SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph>(){

                @Override
                public RecipeRunnableSubgraph call_NT() throws Exception {
                    ci.compute_NT();
                    logger.info((Object)("computed input partitions : " + String.valueOf(realSubgraph.getSourcePartitions())));
                    return realSubgraph;
                }
            };
        }
        return new SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph>(){

            @Override
            public RecipeRunnableSubgraph call_NT() throws Exception {
                return realSubgraph;
            }
        };
    }

    public RecipeRunnableSubgraph getSampleSubgraph(FlowRecipe recipe) throws Exception {
        FlowStreamingEndpoint fse;
        FlowComputable fmf;
        FlowSavedModel fsm;
        FlowComputable computable;
        RecipeRunnableSubgraph subgraph = new RecipeRunnableSubgraph(recipe);
        SerializedRecipe sr = recipe.getModel();
        for (SerializedRecipe.InputRole irole : sr.getInputsUnsafe().values()) {
            for (SerializedRecipe.RecipeInput recipeInput : irole.items) {
                computable = this.computableFromRefService.get(sr.projectKey, recipeInput.ref);
                switch (computable.getType()) {
                    case DATASET: {
                        FlowDataset fds = (FlowDataset)computable;
                        subgraph.addSource_NoRole(fds);
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)fds.getMandatoryUnsafe(this.datasetsDAO).getPartitioningSchema());
                        subgraph.getSourcePartitions().put(fds.getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                    case SAVED_MODEL: {
                        fsm = (FlowSavedModel)computable;
                        subgraph.addSource_NoRole(fsm);
                        subgraph.getSourcePartitions().put(fsm.getFullId(), Lists.newArrayList((Object[])new Partition[]{new Partition(null)}));
                        break;
                    }
                    case MANAGED_FOLDER: {
                        fmf = (FlowManagedFolder)computable;
                        subgraph.addSource_NoRole(fmf);
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)((FlowManagedFolder)fmf).getManagedFolder().getPartitioningSchema());
                        subgraph.getSourcePartitions().put(((FlowManagedFolder)fmf).getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        fmf = (FlowModelEvaluationStore)computable;
                        subgraph.addSource_NoRole(fmf);
                        Partition sample = Partition.randomSamplePartition((PartitioningScheme)((FlowModelEvaluationStore)fmf).getModelEvaluationStore().getPartitioningSchema());
                        subgraph.getSourcePartitions().put(((FlowModelEvaluationStore)fmf).getFullId(), Lists.newArrayList((Object[])new Partition[]{sample}));
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        fmf = (FlowRetrievableKnowledge)computable;
                        subgraph.addSource_NoRole(fmf);
                        subgraph.getSourcePartitions().put(((FlowRetrievableKnowledge)fmf).getFullId(), Lists.newArrayList((Object[])new Partition[]{Partition.newNP()}));
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        fse = (FlowStreamingEndpoint)computable;
                        subgraph.addSource_NoRole(fse);
                        break;
                    }
                }
            }
        }
        for (SerializedRecipe.OutputRole orole : sr.getOutputsUnsafe().values()) {
            for (SerializedRecipe.RecipeOutput recipeOutput : orole.items) {
                computable = this.computableFromRefService.get(sr.projectKey, recipeOutput.ref);
                switch (computable.getType()) {
                    case DATASET: {
                        FlowDataset outFds = (FlowDataset)computable;
                        subgraph.addTarget_NoRole(outFds);
                        subgraph.getTargetPartitions().put(outFds.getFullId(), Partition.randomSamplePartition((PartitioningScheme)outFds.getMandatoryUnsafe(this.datasetsDAO).getPartitioningSchema()));
                        break;
                    }
                    case SAVED_MODEL: {
                        fsm = (FlowSavedModel)computable;
                        subgraph.addTarget_NoRole(fsm);
                        subgraph.getTargetPartitions().put(fsm.getFullId(), new Partition(null));
                        break;
                    }
                    case MANAGED_FOLDER: {
                        fmf = (FlowManagedFolder)computable;
                        subgraph.addTarget_NoRole(fmf);
                        subgraph.getTargetPartitions().put(((FlowManagedFolder)fmf).getFullId(), Partition.randomSamplePartition((PartitioningScheme)((FlowManagedFolder)fmf).getManagedFolder().getPartitioningSchema()));
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        fmf = (FlowModelEvaluationStore)computable;
                        subgraph.addTarget_NoRole(fmf);
                        subgraph.getTargetPartitions().put(((FlowModelEvaluationStore)fmf).getFullId(), Partition.randomSamplePartition((PartitioningScheme)((FlowModelEvaluationStore)fmf).getModelEvaluationStore().getPartitioningSchema()));
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        fmf = (FlowRetrievableKnowledge)computable;
                        subgraph.addTarget_NoRole(fmf);
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        fse = (FlowStreamingEndpoint)computable;
                        subgraph.addTarget_NoRole(fse);
                        break;
                    }
                }
            }
        }
        return subgraph;
    }

    public void checkTargetsAreWritable(JobActivity activity) throws Exception {
        for (FlowComputable flowComputable : activity.getSubgraph().getTargets()) {
            switch (flowComputable.getType()) {
                case DATASET: {
                    Dataset targetDataset = ((FlowDataset)flowComputable).getMandatory(this.datasetsDAO);
                    if (!DatasetUtils.isReadOnly(targetDataset)) break;
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Output dataset is read-only: " + targetDataset.getFullName());
                }
                case MANAGED_FOLDER: {
                    break;
                }
                case SAVED_MODEL: {
                    break;
                }
                case STREAMING_ENDPOINT: {
                    break;
                }
                case RETRIEVABLE_KNOWLEDGE: {
                    break;
                }
            }
        }
    }

    public void checkComplianceWithRecipeDesc(AuthCtx authCtx, SerializedRecipe recipe) throws Exception {
        Dataset dataset;
        StreamingEndpoint streamingEndpoint;
        AnyLoc loc;
        TransactionContext.assertAttachedTransaction();
        FlowRecipe fr = new FlowRecipe(recipe);
        RecipeRunnableSubgraph subgraph = this.getSampleSubgraph(fr);
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(recipe.type);
        RecipeDesc recipeDesc = recipeMeta.getRecipeDesc();
        String payload = recipe.name == null ? null : this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
        Map<String, FlowComputable> sources = subgraph.getSourcesMap();
        Map<String, FlowComputable> targets = subgraph.getTargetsMap();
        for (RecipeDesc.IORoleDef role : recipeDesc.inputRoles) {
            List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole(role.name);
            if (!role.availabilityDependsOnPayload || payload != null) {
                boolean isRoleAvailable;
                boolean bl = isRoleAvailable = role.availabilityDependsOnPayload ? recipeMeta.isInputRoleAvailableForPayload(role, payload) : true;
                if (!isRoleAvailable && inputs.size() > 0) {
                    throw ErrorContext.icef((String)"Input role '%s' is unsupported for recipe type %s: shouldn't be filled", (Object)recipe.type, (Object[])new Object[]{role.name});
                }
                if (isRoleAvailable && role.required && inputs.size() == 0) {
                    throw ErrorContext.icef((String)"Input role '%s' is required for recipe type %s: no inputs found", (Object)recipe.type, (Object[])new Object[]{role.name});
                }
            }
            if (role.arity == RecipeDesc.IOArity.UNARY && inputs.size() > 1) {
                throw ErrorContext.icef((String)"Input role '%s' requires one input: %s inputs found", (Object)role.name, (Object[])new Object[]{inputs.size()});
            }
            for (SerializedRecipe.RecipeInput input : inputs) {
                loc = AnyLoc.resolveSmart(recipe.projectKey, input.ref);
                FlowComputable source = sources.get(loc.getFullName());
                if (!role.acceptsManagedFolder && source.getType() == FlowComputable.FCType.MANAGED_FOLDER) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept folders)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsModelEvaluationStore && source.getType() == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept evaluation stores)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsSavedModel && source.getType() == FlowComputable.FCType.SAVED_MODEL) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept models)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsDataset && source.getType() == FlowComputable.FCType.DATASET) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept datasets)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsStreamingEndpoint && source.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept streaming endpoints)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsRetrievableKnowledge && source.getType() == FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' does not accept knowledge bank)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (source.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
                    if (!StringUtils.isNotBlank((String)role.mustBeStrictlyType) && role.acceptedTypes == null) continue;
                    FlowStreamingEndpoint sourceSE = (FlowStreamingEndpoint)source;
                    streamingEndpoint = sourceSE.getStreamingEndpoint();
                    if (StringUtils.isNotBlank((String)role.mustBeStrictlyType) && !role.mustBeStrictlyType.equals(streamingEndpoint.getType())) {
                        throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts streaming endpoints type %s)", (Object)input.ref, (Object[])new Object[]{role.name, role.mustBeStrictlyType});
                    }
                    if (role.acceptedTypes == null || role.acceptedTypes.contains(streamingEndpoint.getType())) continue;
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts streaming endpoints types %s)", (Object)input.ref, (Object[])new Object[]{role.name, Joiner.on((char)',').join(role.acceptedTypes)});
                }
                if (!StringUtils.isNotBlank((String)role.mustBeStrictlyType) && role.acceptedTypes == null && !role.mustBeSQL) continue;
                if (!(source instanceof FlowDataset)) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts SQL datasets)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                FlowDataset sourceDS = (FlowDataset)source;
                dataset = sourceDS.getMandatoryUnsafe(this.datasetsDAO);
                if (role.mustBeSQL) {
                    if (!DatasetInspector.isSQLTable(dataset)) {
                        throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts SQL datasets)", (Object)input.ref, (Object[])new Object[]{role.name});
                    }
                } else if (role.mustBeSQLAble && !DatasetInspector.isSQLAble(authCtx, dataset)) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts SQL-compatible datasets)", (Object)input.ref, (Object[])new Object[]{role.name});
                }
                if (StringUtils.isNotBlank((String)role.mustBeStrictlyType) && !role.mustBeStrictlyType.equals(dataset.getType())) {
                    throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts datasets type %s)", (Object)input.ref, (Object[])new Object[]{role.name, role.mustBeStrictlyType});
                }
                if (role.acceptedTypes == null || role.acceptedTypes.contains(dataset.getType())) continue;
                throw ErrorContext.icef((String)"Invalid input: '%s' (role '%s' only accepts datasets types %s)", (Object)input.ref, (Object[])new Object[]{role.name, Joiner.on((char)',').join(role.acceptedTypes)});
            }
        }
        for (RecipeDesc.IORoleDef role : recipeDesc.outputRoles) {
            List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole(role.name);
            if (!role.availabilityDependsOnPayload || payload != null) {
                boolean isRoleAvailable;
                boolean bl = isRoleAvailable = role.availabilityDependsOnPayload ? recipeMeta.isOutputRoleAvailableForPayload(role, payload) : true;
                if (!isRoleAvailable && outputs.size() > 0) {
                    throw ErrorContext.icef((String)"Output role '%s' is unsupported for recipe type %s: shouldn't be filled", (Object)recipe.type, (Object[])new Object[]{role.name});
                }
                if (isRoleAvailable && role.required && outputs.size() == 0) {
                    throw ErrorContext.icef((String)"Output role '%s' is required for recipe type %s: no outputs found", (Object)role.name, (Object[])new Object[]{recipe.type});
                }
            }
            if (role.arity == RecipeDesc.IOArity.UNARY && outputs.size() > 1) {
                throw ErrorContext.icef((String)"Output role '%s' requires one output: %s outputs found", (Object)role.name, (Object[])new Object[]{outputs.size()});
            }
            for (SerializedRecipe.RecipeOutput output : outputs) {
                loc = AnyLoc.resolveSmart(recipe.projectKey, output.ref);
                FlowComputable target = targets.get(loc.getFullName());
                if (!role.acceptsManagedFolder && target.getType() == FlowComputable.FCType.MANAGED_FOLDER) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept folders)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsModelEvaluationStore && target.getType() == FlowComputable.FCType.MODEL_EVALUATION_STORE) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept evaluation stores)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsSavedModel && target.getType() == FlowComputable.FCType.SAVED_MODEL) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept models)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsDataset && target.getType() == FlowComputable.FCType.DATASET) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept datasets)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsStreamingEndpoint && target.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept streaming endpoints)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (!role.acceptsRetrievableKnowledge && target.getType() == FlowComputable.FCType.RETRIEVABLE_KNOWLEDGE) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' does not accept knowledge bank)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (target.getType() == FlowComputable.FCType.STREAMING_ENDPOINT) {
                    if (!StringUtils.isNotBlank((String)role.mustBeStrictlyType) && role.acceptedTypes == null) continue;
                    FlowStreamingEndpoint targetSE = (FlowStreamingEndpoint)target;
                    streamingEndpoint = targetSE.getStreamingEndpoint();
                    if (StringUtils.isNotBlank((String)role.mustBeStrictlyType) && !role.mustBeStrictlyType.equals(streamingEndpoint.getType())) {
                        throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts streaming endpoints type %s)", (Object)output.ref, (Object[])new Object[]{role.name, role.mustBeStrictlyType});
                    }
                    if (role.acceptedTypes == null || role.acceptedTypes.contains(streamingEndpoint.getType())) continue;
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts streaming endpoints types %s)", (Object)output.ref, (Object[])new Object[]{role.name, Joiner.on((char)',').join(role.acceptedTypes)});
                }
                if (!StringUtils.isNotBlank((String)role.mustBeStrictlyType) && role.acceptedTypes == null && !role.mustBeSQL) continue;
                if (!(target instanceof FlowDataset)) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts SQL datasets)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                FlowDataset targetDS = (FlowDataset)target;
                dataset = targetDS.getMandatoryUnsafe(this.datasetsDAO);
                if (role.mustBeSQL && !DatasetInspector.isSQLTable(dataset)) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts SQL datasets)", (Object)output.ref, (Object[])new Object[]{role.name});
                }
                if (StringUtils.isNotBlank((String)role.mustBeStrictlyType) && !role.mustBeStrictlyType.equals(dataset.getType())) {
                    throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts datasets type %s)", (Object)output.ref, (Object[])new Object[]{role.name, role.mustBeStrictlyType});
                }
                if (role.acceptedTypes == null || role.acceptedTypes.contains(dataset.getType())) continue;
                throw ErrorContext.icef((String)"Invalid output: '%s' (role '%s' only accepts datasets types %s)", (Object)output.ref, (Object[])new Object[]{role.name, Joiner.on((char)',').join(role.acceptedTypes)});
            }
        }
    }

    public RunRecipeFromUIResult runRecipeFromUI_NT(AuthCtx authCtx, String projectKey, String recipeName, RunRecipeFromUIMode mode, JsonObject buildPartitions) throws Exception {
        String string;
        logger.infoV("Prepare run-recipe-from-ui project=%s recipe=%s mode=%s", new Object[]{projectKey, recipeName, mode});
        ProjectFlowGraph graph = null;
        FlowRunnable runnable = null;
        try (Transaction t = this.transactionService.beginRead();){
            graph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            String recipeId = new AnyLoc(projectKey, recipeName).getFullName();
            runnable = graph.getRunnable(recipeId);
            if (mode == RunRecipeFromUIMode.RUN_ONLY_IF_NO_SUCCESSORS) {
                boolean hasAnySuccessorRecipe = false;
                for (GraphNode graphNode : runnable.getSuccessors()) {
                    hasAnySuccessorRecipe |= graphNode.getSuccessors().size() > 0;
                }
                boolean bl = this.flowGraphService.hasAnyPartitioningInGraph(graph, projectKey);
                logger.infoV("Auto mode hasSuccessor=%s hasPartitioning=%s", new Object[]{hasAnySuccessorRecipe, bl});
                if (hasAnySuccessorRecipe && !bl) {
                    logger.infoV(" --> Asking user", new Object[0]);
                    RunRecipeFromUIResult runRecipeFromUIResult = new RunRecipeFromUIResult();
                    runRecipeFromUIResult.hasSuccessorsAndCanDoAReverseBuild = true;
                    RunRecipeFromUIResult runRecipeFromUIResult2 = runRecipeFromUIResult;
                    return runRecipeFromUIResult2;
                }
                logger.infoV(" --> Running just this recipe", new Object[0]);
                mode = RunRecipeFromUIMode.RUN_RECIPE_ONLY;
            }
        }
        JobDef jd = new JobDef();
        jd.projectKey = projectKey;
        jd.refreshHiveMetastore = true;
        jd.recipe = recipeName;
        jd.triggeredFrom = JobDef.JobTriggerType.RECIPE;
        jd.initiationTimestamp = System.currentTimeMillis();
        jd.initiator = authCtx.getIdentifier();
        if (mode == RunRecipeFromUIMode.RUN_RECIPE_ONLY) {
            try (Transaction t = this.transactionService.beginRead();){
                jd.type = JobDef.JobType.NON_RECURSIVE_FORCED_BUILD;
                jd.autoUpdateSchemaBeforeEachRecipeRun = false;
                for (GraphNode graphNode : runnable.getSuccessors()) {
                    FlowComputable flowComputable = (FlowComputable)graphNode;
                    JobDef.JobOutput jo = new JobDef.JobOutput();
                    jo.targetDatasetProjectKey = projectKey;
                    jo.targetDataset = AnyLoc.resolveFull(flowComputable.getFullId()).getId();
                    jo.type = flowComputable.getType();
                    PartitioningScheme scheme = this.flowGraphService.getComputablePartitioningScheme(flowComputable);
                    jo.targetPartition = this.computeTargetPartition(scheme, buildPartitions);
                    jd.outputs.add(jo);
                }
            }
        } else if (mode == RunRecipeFromUIMode.RUN_REVERSE_BUILD) {
            jd.type = JobDef.JobType.REVERSE_FORCED_BUILD;
            jd.autoUpdateSchemaBeforeEachRecipeRun = true;
            JobDef.ReverseJobStartingPoint startingPoint = new JobDef.ReverseJobStartingPoint();
            startingPoint.graphNodeSupertype = JobDef.GraphNodeSupertype.RUNNABLE;
            startingPoint.projectKey = projectKey;
            startingPoint.id = recipeName;
            jd.reverseStartingPoints.add(startingPoint);
        } else assert (false);
        VariablesContext vc = this.variablesService.getContext(jd.projectKey);
        jd.expandInPlaceOutputsTargetPartition(vc);
        logger.info((Object)("Executing recipe from UI with job definition: " + JSON.pretty((Object)jd)));
        FlowExecutionService2 flowExecutionService = (FlowExecutionService2)SpringUtils.getBean(FlowExecutionService2.class);
        Object var11_20 = null;
        try (Transaction transaction = this.transactionService.beginRead();){
            string = flowExecutionService.startJob(jd, authCtx);
        }
        RunRecipeFromUIResult runRecipeFromUIResult = new RunRecipeFromUIResult();
        runRecipeFromUIResult.started = true;
        runRecipeFromUIResult.jobId = string;
        return runRecipeFromUIResult;
    }

    private String computeTargetPartition(PartitioningScheme partitioning, JsonObject buildPartitions) {
        if (partitioning != null && partitioning.isPartitioned()) {
            ArrayList dimensionsValues = new ArrayList();
            for (String dimName : partitioning.getDimensionNames()) {
                Dimension dimension = partitioning.getDimension(dimName);
                if (!buildPartitions.has(dimName)) continue;
                ArrayList<Object> dimensionValues = new ArrayList<Object>();
                JsonElement dimPartitions = buildPartitions.get(dimName);
                if (dimension instanceof TimeDimension) {
                    if (((TimeDimension)dimension).mappedPeriod == TimeDimension.Period.YEAR) {
                        dimensionValues.add(dimPartitions.getAsString());
                    } else if (JsonUtils.getAsBoolean(dimPartitions.getAsJsonObject(), false, "useExplicit")) {
                        String explicitVal = JsonUtils.getOrNullStr(dimPartitions.getAsJsonObject(), "explicit");
                        if (explicitVal.indexOf(44) >= 0) {
                            for (String ev : explicitVal.split(",")) {
                                dimensionValues.add(ev);
                            }
                        } else {
                            dimensionValues.add(explicitVal);
                        }
                    } else {
                        String start = JsonUtils.getOrNullStr(dimPartitions.getAsJsonObject(), "start");
                        String end = JsonUtils.getOrNullStr(dimPartitions.getAsJsonObject(), "end");
                        if (start != null && end != null && !start.equals(end)) {
                            dimensionValues.add(start + "/" + end);
                        } else {
                            dimensionValues.add(start);
                        }
                    }
                } else {
                    dimensionValues.add(dimPartitions.getAsString());
                }
                dimensionsValues.add(dimensionValues);
            }
            ArrayList<String> resolvedCompletePartitions = new ArrayList<String>();
            resolvedCompletePartitions.add("");
            for (List list : dimensionsValues) {
                ArrayList<CallSite> newPartitionIds = new ArrayList<CallSite>();
                for (String dimensionValue : list) {
                    String[] stringArray = resolvedCompletePartitions.iterator();
                    while (stringArray.hasNext()) {
                        String resolvedCompletePartition;
                        newPartitionIds.add((CallSite)((Object)(resolvedCompletePartition + String.valueOf((resolvedCompletePartition = (String)stringArray.next()).length() > 0 ? Character.valueOf('|') : "") + dimensionValue)));
                    }
                }
                resolvedCompletePartitions = newPartitionIds;
            }
            return StringUtils.join(resolvedCompletePartitions, (String)",");
        }
        return null;
    }

    static class PdepTestResult {
        RecipeValidationResult validationResult;
        String output;
        TreeSet<String> sortedInputs = new TreeSet();

        PdepTestResult() {
        }
    }

    public static class RecipeValidationResult
    extends InfoMessage.InfoMessages {
        public LinkedHashMap<String, RecipeVariablesHelper.AvailableVariable> substitutionVariables;
    }

    static class PdepTestEntry {
        DimensionDependencySpec spec;
        Dimension inputDimension;
        DimensionValue targetVal;
        DimensionDependencyEvaluator evaluator;

        PdepTestEntry() {
        }
    }

    public static enum RunRecipeFromUIMode {
        RUN_RECIPE_ONLY,
        RUN_REVERSE_BUILD,
        RUN_ONLY_IF_NO_SUCCESSORS;

    }

    public static class RunRecipeFromUIResult {
        public boolean started;
        public boolean hasSuccessorsAndCanDoAReverseBuild;
        public String jobId;
    }
}

