/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.StandaloneEvaluationRecipePayloadParams;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.eda.PCARecipeMeta;
import com.dataiku.dip.recipes.eda.StatsTestRecipeMeta;
import com.dataiku.dip.recipes.eda.UnivariateRecipeMeta;
import com.dataiku.dip.recipes.nlp.classification.model_provided.NLPLLMModelProvidedClassificationRecipeMeta;
import com.dataiku.dip.recipes.nlp.classification.user_provided.NLPLLMUserProvidedClassificationRecipeMeta;
import com.dataiku.dip.recipes.nlp.finetuning.FineTuningRecipeMeta;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipeMeta;
import com.dataiku.dip.recipes.nlp.prompt.PromptRecipeMeta;
import com.dataiku.dip.recipes.nlp.summarization.SummarizationRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipeSaveService {
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private CodeEnvPermissionsService codeEnvPermissionsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;
    @Autowired
    private PasswordEncryptionService cryptoService;
    public static final String ROLE_VELOOP_INPUT = "veloop";
    public static final String ROLE_REFERENCE = "reference";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.saveservice");

    public void rename(RWTransaction t, String projectKey, String oldName, String newName) throws Exception {
        SmartObjectRef oldRecipeRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.RECIPE, oldName);
        String currentZone = this.flowZonesService.retrieveZone(projectKey, oldRecipeRef);
        this.flowZonesService.detachObjectFromZone(projectKey, oldRecipeRef);
        this.recipesDAO.rename(projectKey, oldName, newName);
        this.jupyterService.updateNotebookForRecipeRenaming(projectKey, oldName, newName);
        this.sqlNotebooksService.updateNotebookForRecipeRenaming(projectKey, oldName, newName);
        JsonObject details = new JsonObject();
        if (StringUtils.isNotBlank((String)oldName) && !oldName.equals(newName)) {
            details.addProperty("oldName", oldName);
            details.addProperty("newName", newName);
        }
        this.flowZonesService.attachObjectToZone(currentZone, projectKey, SmartObjectRef.fromSmartName(ITaggingService.TaggableType.RECIPE, newName), true);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RECIPE, projectKey, oldName, t.getUser(), TaggableObjectChangedEvent.ActionType.RECIPE_RENAME, newName).withDetails(details));
    }

    public String smartRename(String projectKey, String name, Map<String, String> datasetNames) throws IOException {
        String datasetName;
        Object newBaseName = name;
        if (name.startsWith("compute_") && datasetNames.containsKey(datasetName = StringUtils.right((String)name, (int)(name.length() - "compute_".length())))) {
            newBaseName = "compute_" + datasetNames.get(datasetName);
        }
        return this.transmogrifyName(projectKey, (String)newBaseName);
    }

    public String transmogrifyName(String projectKey, String name) throws IOException {
        StringTransmogrifier st2 = new StringTransmogrifier(true);
        for (SerializedRecipe sr : this.recipesDAO.listUnsafe(projectKey)) {
            st2.addAlreadyTransmogrified(sr.name);
        }
        return st2.transmogrify(name);
    }

    public SerializedRecipe create(String projectKey, SerializedRecipe sr, String payload) throws IOException, SQLException, DKUSecurityException, UnauthorizedException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        sr = (SerializedRecipe)JSON.deepCopy((Object)sr);
        this.failIfNotAllowed(sr, t.getUser(), payload);
        this.failIfCodeEnvNotUsable(sr, null, t.getUser());
        if (this.recipesDAO.getOrNullUnsafe(projectKey, sr.name) != null) {
            throw ErrorContext.iaef((String)"Recipe %s already exists", (Object)sr.name, (Object[])new Object[0]);
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectCreation(sr);
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(sr);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RECIPE, projectKey, sr.name, t.getUser(), TaggableObjectChangedEvent.ActionType.RECIPE_CREATE));
        this.saveInternal(projectKey, sr, payload);
        return sr;
    }

    public SerializedRecipe saveNoVersionNorNotifications(String projectKey, SerializedRecipe sr, String payload) throws IOException, SQLException, DKUSecurityException, UnauthorizedException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.failIfNotAllowed(sr, t.getUser(), payload);
        SerializedRecipe preExisting = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, sr.name);
        assert (preExisting != null);
        this.saveInternal(projectKey, sr, payload);
        return sr;
    }

    public SerializedRecipe save(String projectKey, SerializedRecipe sr) throws IOException, DKUSecurityException, CodedException {
        String payload = this.recipesDAO.getPayloadOrNull(projectKey, sr.name);
        return this.save(projectKey, sr, payload);
    }

    public SerializedRecipe save(String projectKey, SerializedRecipe sr, String payload) throws IOException, DKUSecurityException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        sr = (SerializedRecipe)JSON.deepCopy((Object)sr);
        this.failIfNotAllowed(sr, t.getUser(), payload);
        SerializedRecipe preExisting = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, sr.name);
        if (preExisting != null) {
            logger.debug((Object)"Saving recipe (with pre-existing)");
        } else {
            logger.debug((Object)"Saving recipe (with no pre-existing)");
        }
        this.failIfCodeEnvNotUsable(sr, preExisting, t.getUser());
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(sr, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(preExisting, sr, t.getUser().getIdentifier());
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RECIPE, projectKey, sr.name, t.getUser(), TaggableObjectChangedEvent.ActionType.RECIPE_EDIT));
        }
        this.saveInternal(projectKey, sr, payload);
        return sr;
    }

    public SerializedRecipe changeType(String projectKey, String name, String newType) throws IOException, DKUSecurityException, CodedException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, name);
        String payload = this.recipesDAO.getPayloadOrNull(projectKey, name);
        sr = (SerializedRecipe)JSON.deepCopy((Object)sr);
        sr.type = newType;
        this.failIfNotAllowed(sr, t.getUser(), payload);
        this.failIfCodeEnvNotUsable(sr, sr, t.getUser());
        VersionTag existingTag = sr.versionTag;
        sr.versionTag = VersionTag.increment(existingTag, t.getUser().getIdentifier());
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(sr, sr, t.getUser().getIdentifier());
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        } else {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RECIPE, projectKey, sr.name, t.getUser(), TaggableObjectChangedEvent.ActionType.RECIPE_EDIT));
        }
        this.changeTypeInternal(projectKey, sr, newType);
        return sr;
    }

    public void delete(String projectKey, String name) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        JsonObject details = new JsonObject();
        try {
            SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNull(projectKey, name);
            if (sr != null) {
                this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), sr);
                this.flowZonesService.cleanupObjectFromZones(projectKey, sr);
                details.addProperty("recipeType", sr.type);
            }
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jupyterService.updateNotebookForRecipeDeletion(projectKey, name);
        this.sqlNotebooksService.updateNotebookForRecipeDeletion(projectKey, name);
        this.continuousActivitiesManager.deleteIfNeeded_T(projectKey, name);
        this.recipesDAO.delete(projectKey, name);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RECIPE, projectKey, name, t.getUser(), TaggableObjectChangedEvent.ActionType.RECIPE_DELETE).withDetails(details));
    }

    private void failIfCodeEnvNotUsable(SerializedRecipe sr, SerializedRecipe preExisting, AuthCtx authCtx) throws DKUSecurityException {
        if (sr.params instanceof ParamsWithSelectableCodeEnv) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(sr.getProjectKey(), RecipeRegistry.getMeta(sr.getType()), sr.params, (Object)(preExisting == null ? null : (ParamsWithSelectableCodeEnv)((Object)preExisting.params)), authCtx);
        }
    }

    public void failIfNotAllowed(SerializedRecipe sr, AuthCtx authCtx, @Nullable String payload) throws SecurityException, IOException, DKUSecurityException {
        Object params;
        boolean isEDARecipe;
        if ((sr.type.equals("pyspark") || sr.type.equals("sparkr") || sr.type.equals("spark_scala") || sr.type.equals("spark_sql_query")) && !this.licenseEnforcementService.getFeaturesStatus().sparkAllowed) {
            throw new SecurityException("Spark usage is not authorized by your license");
        }
        if (sr.type.equals("python") || sr.type.equals("pyspark") || sr.type.equals("r") || sr.type.equals("sparkr")) {
            this.licenseEnforcementService.checkRegularCodeAllowed(authCtx);
        } else if (sr.type.equals("sql_query") || sr.type.equals("sql_script")) {
            this.licenseEnforcementService.checkSQLAllowed(authCtx);
        }
        if (NLPLLMModelProvidedClassificationRecipeMeta.META.getType().equals(sr.type) || NLPLLMUserProvidedClassificationRecipeMeta.META.getType().equals(sr.type) || SummarizationRecipeMeta.META.getType().equals(sr.type)) {
            this.licenseEnforcementService.checkLLMMeshPoweredRecipesAllowed(authCtx);
        }
        if (PromptRecipeMeta.META.getType().equals(sr.type)) {
            this.licenseEnforcementService.checkBasicLLMMeshAllowed(authCtx);
        }
        if (FineTuningRecipeMeta.META.getType().equals(sr.type)) {
            this.licenseEnforcementService.checkFullLLMMeshAllowed(authCtx);
        }
        if (LLMEvaluationRecipeMeta.META.getType().equals(sr.type)) {
            this.licenseEnforcementService.checkFullLLMMeshAllowed(authCtx);
        }
        boolean bl = isEDARecipe = PCARecipeMeta.META.getType().equals(sr.type) || StatsTestRecipeMeta.META.getType().equals(sr.type) || UnivariateRecipeMeta.META.getType().equals(sr.type);
        if (isEDARecipe) {
            this.licenseEnforcementService.checkEDAAllowed(authCtx);
        }
        if (sr.type.equals("python") || sr.type.equals("r") || sr.type.equals("shell") || sr.type.equals("pyspark") || sr.type.equals("sparkr") || sr.type.equals("spark_scala")) {
            authCtx.failIfNoSafeCode("save a code recipe");
        }
        if (sr.type.equals("shaker") && payload != null) {
            SerializedShakerScript ss = null;
            try {
                ss = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Bad shaker script", (Throwable)e);
            }
            if (ss != null) {
                ShakerUtils.checkScriptCodePermission(authCtx, ss);
            }
        }
        if (sr.type.equals("evaluation") && payload != null) {
            params = null;
            try {
                params = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Bad evaluation recipe format", (Throwable)e);
            }
            if (params != null && ((EvaluationRecipePayloadParams)params).customEvaluationMetrics != null && !((EvaluationRecipePayloadParams)params).customEvaluationMetrics.isEmpty()) {
                authCtx.failIfNoSafeCode("write Custom Evaluation Metrics.");
            }
        }
        if (sr.type.equals("standalone_evaluation") && payload != null) {
            params = null;
            try {
                params = (StandaloneEvaluationRecipePayloadParams)JSON.parse((String)payload, StandaloneEvaluationRecipePayloadParams.class);
            }
            catch (Exception e) {
                logger.warn((Object)"Bad standalone evaluation recipe format", (Throwable)e);
            }
            if (params != null && ((StandaloneEvaluationRecipePayloadParams)params).customEvaluationMetrics != null && !((StandaloneEvaluationRecipePayloadParams)params).customEvaluationMetrics.isEmpty()) {
                authCtx.failIfNoSafeCode("write Custom Evaluation Metrics.");
            }
        }
        if (sr.type.equals("sql_script")) {
            Collection<String> allConnections = SQLQueryRecipeUtils.getAllConnections(sr);
            SQLQueryRecipeUtils.checkConnectionUsability(allConnections, authCtx);
        }
        if (sr.type.equals("sql_query")) {
            SQLQueryRecipeTester tester = new SQLQueryRecipeTester();
            Collection<String> inputConnections = tester.getInputConnections(authCtx, sr);
            SQLQueryRecipeUtils.checkConnectionUsability(inputConnections, authCtx);
            String mainConnection = SQLQueryRecipeUtils.getMainConnection(sr, authCtx);
            SQLQueryRecipeUtils.checkConnectionUsability(Collections.singleton(mainConnection), authCtx);
        }
        for (SerializedRecipe.InputRole irole : sr.getInputsUnsafe().values()) {
            for (SerializedRecipe.RecipeInput ri : irole.items) {
                for (SerializedRecipe.SDep sdep : ri.deps) {
                    if (!sdep.func.equals("custom_python")) continue;
                    if (authCtx.getAssociatedDSSUser() == null) {
                        throw new UnauthorizedException("No user associated to this authentication context, cannot create a recipe with code", "not-a-user-authctx");
                    }
                    authCtx.failIfNoUnsafeCode("save a custom dependency");
                }
            }
        }
    }

    private void addImplicitDependencies(SerializedRecipe sr) {
        if (sr.type.equals("sql_query") || sr.type.equals("download")) {
            VariablesExpansionLoopConfig veLoopConfig;
            sr.clearInputsForRole(ROLE_VELOOP_INPUT);
            if (sr.params instanceof ParamsWithVariablesExpansionLoopConfig && (veLoopConfig = ((ParamsWithVariablesExpansionLoopConfig)((Object)sr.params)).getVariablesExpansionLoopConfig()).isEnabled() && StringUtils.isNotBlank((String)veLoopConfig.datasetRef)) {
                sr.addInput(ROLE_VELOOP_INPUT, veLoopConfig.datasetRef);
            }
        }
    }

    private void saveInternal(String projectKey, SerializedRecipe sr, String payload) throws IOException, CodedException {
        logger.infoV("Save recipe internal name=%s type=%s payload_size=%s", new Object[]{sr.name, sr.type, payload != null ? payload.length() : 0});
        RecipeMeta meta = RecipeRegistry.getMeta(sr.type);
        meta.updateImplicitIOBeforeSave(projectKey, sr, payload);
        meta.prepareForSave(sr, this.cryptoService);
        this.addImplicitDependencies(sr);
        try {
            if (meta.hasJsonPayload()) {
                payload = JSON.pretty((Object)new JSONParser().parse(payload));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to prettify payload", (Throwable)e);
        }
        this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.recipesDAO.getOrNull(sr.projectKey, sr.getId()), sr);
        this.recipesDAO.save(projectKey, sr.name, sr, payload);
        this.taggingService.onObjectSaved(projectKey, sr.tags);
    }

    private void changeTypeInternal(String projectKey, SerializedRecipe sr, String newType) throws IOException, CodedException {
        logger.infoV("Change recipe type internal name=%s type=%s newType=%s", new Object[]{sr.name, sr.type, newType});
        this.customPolicyHooksRegistry.onPreObjectSave(TransactionContext.retrieveWrite().getUser(), (TaggableObjectsService.TaggableObject)this.recipesDAO.getOrNull(sr.projectKey, sr.getId()), sr);
        this.recipesDAO.changeType(projectKey, sr.name, newType);
        this.taggingService.onObjectSaved(projectKey, sr.tags);
    }

    public static class RecipeSchemaUpdatedWarnings {
        public boolean hasAnyProblem;
        public List<DatasetLocUtils.DatasetLoc> datasetsNeedingAction = new ArrayList<DatasetLocUtils.DatasetLoc>();
    }
}

