/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.backend.AchievementEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AchievementsService {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TransactionService transactionService;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("AchievementsService-%d").build());
    private Map<String, SessionTimer> sessionLastActive = new HashMap<String, SessionTimer>();
    private static final RelFile achievementsFile = RelFile.global((String)"achievements.json");
    private static Logger logger = Logger.getLogger((String)"dip.services.achievements");

    public void resetSessionTimer(AuthCtx user, String token) throws IOException {
        long now = System.currentTimeMillis();
        SessionTimer timer = this.sessionLastActive.get(token);
        if (timer == null) {
            timer = new SessionTimer();
            timer.started = timer.refreshed = now;
            this.sessionLastActive.put(token, timer);
        }
        if (now - timer.refreshed > 90000L) {
            timer.refreshed = timer.started = now;
        } else if (now - timer.started <= 1800000L && now - timer.started <= 300000L) {
            timer.refreshed = now;
        }
    }

    private AchievementsFile read() throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return (AchievementsFile)t.readObjectDefault(achievementsFile, AchievementsFile.class);
    }

    private void write(RWTransaction t, AchievementsFile file) throws IOException {
        t.writeObject(achievementsFile, (Object)file);
    }

    public UserAchievements getforUser(String login) throws IOException {
        AchievementsFile data = this.read();
        UserAchievements ua = data.won.get(login);
        if (ua == null) {
            ua = new UserAchievements();
        }
        for (AchievementId id : AchievementId.values()) {
            boolean found = false;
            for (Achievement a : ua.achievements) {
                if (!a.id.equals(id.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Achievement notWon = new Achievement();
            notWon.id = id.toString();
            ua.achievements.add(notWon);
        }
        return ua;
    }

    private boolean isEnabled() {
        return false;
    }

    public void win(final AuthCtx usr, final AchievementId id) {
        if (this.isEnabled()) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try (RWTransaction t = AchievementsService.this.transactionService.beginWriteAsLoggedInUser(usr);){
                        AchievementsFile data = AchievementsService.this.read();
                        UserAchievements ua = data.won.get(t.getUser().getAssociatedDSSUserMand());
                        if (ua == null) {
                            ua = new UserAchievements();
                            data.won.put(t.getUser().getAssociatedDSSUserMand(), ua);
                        }
                        for (Achievement a : ua.achievements) {
                            if (!a.id.equals(id.toString())) continue;
                            return;
                        }
                        Achievement won = new Achievement();
                        won.wonOn = System.currentTimeMillis();
                        won.id = id.toString();
                        ua.achievements.add(won);
                        AchievementsService.this.write(t, data);
                        AchievementsService.this.pubSub.publish(new AchievementEvent(t.getUser().getAssociatedDSSUserMand(), id));
                        t.commit("Won achievement!");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to win achievement", (Throwable)e);
                    }
                }
            });
        }
    }

    static class SessionTimer {
        long started;
        long refreshed;

        SessionTimer() {
        }
    }

    public static class AchievementsFile {
        public Map<String, UserAchievements> won = new HashMap<String, UserAchievements>();
    }

    static class UserAchievements {
        public List<Achievement> achievements = new ArrayList<Achievement>();

        UserAchievements() {
        }
    }

    public static enum AchievementId {
        LETS_GET_COOKING,
        APPRENTICE_BARTENDER,
        NOT_QUITE_PARKINSON,
        OH_NOES_JOB_FAILED,
        MY_FIRST_JOB,
        STING_OF_THE_BEE,
        ALL_ON_BOARD,
        SLOW_SHAKE_1,
        SLOW_SHAKE_2,
        SLOW_SHAKE_3,
        CODE_SAMPLE_WIZZARD,
        LIGHT_THE_SPARK,
        IT_HAD_TO_BE_DONE,
        TEAM_PLAYER,
        COLORS_OF_THE_WIND,
        WE_ARE_ALCHEMISTS;

    }

    static class Achievement {
        public String id;
        public long wonOn;

        Achievement() {
        }
    }
}

