/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.config.DesignNodeInfo;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.settings.SourceNodeWithLocalInfo;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NodesService {
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private TransactionService transactionService;

    public boolean isOrHasLocalDeployer() throws IOException {
        GeneralSettingsDAO.GeneralSettings gs;
        try (Transaction t = this.transactionService.beginRead();){
            gs = this.generalSettingsService.read();
        }
        GeneralSettingsDAO.DeployerMode deployerMode = gs.deployerClientSettings.getRef().mode;
        return "deployer".equals(DKUApp.getInstallNodeType()) || deployerMode.equals((Object)GeneralSettingsDAO.DeployerMode.LOCAL) && (this.isDesignNode() || this.isAutomationNode()) || deployerMode.equals((Object)GeneralSettingsDAO.DeployerMode.REMOTE) && gs.deployerServerEnabledDespiteRemote;
    }

    public boolean hasLocalDeployer() throws IOException {
        GeneralSettingsDAO.GeneralSettings gs;
        try (Transaction t = this.transactionService.beginRead();){
            gs = this.generalSettingsService.read();
        }
        GeneralSettingsDAO.DeployerMode deployerMode = gs.deployerClientSettings.getRef().mode;
        return deployerMode.equals((Object)GeneralSettingsDAO.DeployerMode.LOCAL) && (this.isDesignNode() || this.isAutomationNode()) || deployerMode.equals((Object)GeneralSettingsDAO.DeployerMode.REMOTE) && gs.deployerServerEnabledDespiteRemote;
    }

    public boolean isDesignNode() {
        return "design".equals(DKUApp.getInstallNodeType());
    }

    public boolean isAutomationNode() {
        return "automation".equals(DKUApp.getInstallNodeType());
    }

    public SourceNodeWithLocalInfo getSourceNodeWithLocalInfo(@Nullable DesignNodeInfo designNodeInfo) {
        if (designNodeInfo == null) {
            return null;
        }
        return new SourceNodeWithLocalInfo(designNodeInfo.nodeId, designNodeInfo.url);
    }
}

