/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneDocBuilder;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.AbstractAnalysisFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.custom.CustomAnalyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LuceneMultiMappingsAnalyzer
extends LuceneMappingsAnalyzer {
    public LuceneMultiMappingsAnalyzer(String name, LuceneMappingsAnalyzer ... lmaArgs) {
        super(name);
        List<LuceneMappingsAnalyzer> impactedLmaList;
        List<LuceneMappingsAnalyzer> lmaList = Arrays.asList(lmaArgs);
        for (String analyzerName : lmaList.stream().flatMap(lma -> lma.analyzerMap.keySet().stream()).collect(Collectors.toSet())) {
            impactedLmaList = lmaList.stream().filter(lma -> lma.analyzerMap.containsKey(analyzerName)).collect(Collectors.toList());
            this.analyzerMap.put(analyzerName, ((LuceneMappingsAnalyzer)impactedLmaList.get((int)0)).analyzerMap.get(analyzerName));
            if (impactedLmaList.size() <= 1) continue;
            this.checkAnalyzersConflicts(impactedLmaList, analyzerName);
        }
        for (LuceneMappingsAnalyzer lma2 : lmaList) {
            this.jsonsPerType.putAll(lma2.jsonsPerType);
            this.analyzerMap.putAll(lma2.analyzerMap);
            this.mappingPerTypeMap.putAll(lma2.mappingPerTypeMap);
        }
        this.buildSubMappings();
        for (String facetKey : lmaList.stream().flatMap(l -> l.getFacetsConfig().getDimConfigs().keySet().stream()).collect(Collectors.toSet())) {
            this.addFacet(facetKey.substring("facet_".length()));
        }
        for (String fieldName : lmaList.stream().flatMap(l -> l.getCondensedMapping().keySet().stream()).collect(Collectors.toSet())) {
            impactedLmaList = lmaList.stream().filter(lma -> lma.getCondensedMapping().containsKey(fieldName)).collect(Collectors.toList());
            if (impactedLmaList.size() <= 1) continue;
            LuceneMappingsAnalyzer.Field firstField = impactedLmaList.remove(0).getCondensedMapping().get(fieldName);
            for (LuceneMappingsAnalyzer otherLma : impactedLmaList) {
                LuceneMappingsAnalyzer.Field otherField = otherLma.getCondensedMapping().get(fieldName);
                this.checkFieldConflicts(firstField, otherField, fieldName);
            }
        }
    }

    private void checkAnalyzersConflicts(List<LuceneMappingsAnalyzer> impactedLmaList, String analyzerName) {
        this.checkTokenFilterFactoriesConflicts(impactedLmaList, analyzerName);
        List<TokenizerFactory> tokenizerFactoriesList = impactedLmaList.stream().map(lma -> ((CustomAnalyzer)lma.analyzerMap.get(analyzerName)).getTokenizerFactory()).collect(Collectors.toList());
        this.checkTokenizerFactoriesConflicts(tokenizerFactoriesList, analyzerName);
        this.checkPatternTokenizerFactoriesConflicts(tokenizerFactoriesList, analyzerName);
    }

    private void checkTokenFilterFactoriesConflicts(List<LuceneMappingsAnalyzer> impactedLmaList, String analyzerName) {
        List tokenFilterFactoriesList = impactedLmaList.stream().map(lma -> ((CustomAnalyzer)lma.analyzerMap.get(analyzerName)).getTokenFilterFactories().stream().map(Object::getClass).collect(Collectors.toList())).collect(Collectors.toList());
        if (!tokenFilterFactoriesList.stream().allMatch(((List)tokenFilterFactoriesList.get(0))::equals)) {
            logger.fatal((Object)("The list of TokenFilterFactories for the analyzer " + analyzerName + " is not the same for every mapping"));
            throw new IllegalStateException("Conflict of analyzers in LuceneMultiMappingsAnalyzer");
        }
    }

    private void checkTokenizerFactoriesConflicts(List<TokenizerFactory> tokenizerFactoriesList, String analyzerName) {
        if (!tokenizerFactoriesList.stream().map(Object::getClass).allMatch(tokenizerFactoriesList.get(0).getClass()::equals)) {
            logger.fatal((Object)("The tokenizer for the analyzer " + analyzerName + " is not the same for every mapping"));
            throw new IllegalStateException("Conflict of tokenizer in LuceneMultiMappingsAnalyzer");
        }
    }

    private void checkPatternTokenizerFactoriesConflicts(List<TokenizerFactory> tokenizerFactoriesList, String analyzerName) {
        if (tokenizerFactoriesList.get(0) instanceof PatternTokenizerFactory) {
            List argMapList = tokenizerFactoriesList.stream().map(AbstractAnalysisFactory::getOriginalArgs).collect(Collectors.toList());
            if (!argMapList.stream().allMatch(((Map)argMapList.get(0))::equals)) {
                logger.fatal((Object)("Input tokenizer patterns differ for the analyzer's tokenizer " + analyzerName));
                throw new IllegalStateException("Conflict of pattern for PatternTokenizerFactory in LuceneMultiMappingsAnalyzer");
            }
        }
    }

    private void checkFieldConflicts(LuceneMappingsAnalyzer.Field firstField, LuceneMappingsAnalyzer.Field otherField, String fieldName) {
        if (firstField.type != otherField.type) {
            logger.fatal((Object)("type conflict for field " + fieldName));
            throw new IllegalStateException("Conflict of LMA field mapping type for field " + fieldName + "during construction of LuceneMultiMappingsAnalyzer");
        }
        if (!(firstField.analyzer == null && otherField.analyzer == null || firstField.analyzer != null && otherField.analyzer != null && firstField.analyzer.equals(otherField.analyzer))) {
            logger.fatal((Object)("analyzer conflict for field " + fieldName));
            throw new IllegalStateException("Conflict of LMA field mapping analyzer for field " + fieldName + "during construction of LuceneMultiMappingsAnalyzer");
        }
        if (firstField.stored != otherField.stored) {
            logger.fatal((Object)("stored value conflict for field " + fieldName));
            throw new IllegalStateException("Conflict of LMA field mapping stored for field " + fieldName + "during construction of LuceneMultiMappingsAnalyzer");
        }
        if (firstField.termVector != otherField.termVector) {
            logger.fatal((Object)("termVector value conflict for field " + fieldName));
            throw new IllegalStateException("Conflict of LMA field mapping termVector for field " + fieldName + "during construction of LuceneMultiMappingsAnalyzer");
        }
    }

    @Override
    public void addDocument(IndexWriter indexWriter, LuceneDocBuilder doc) {
        throw new UnsupportedOperationException("addDocument is not permitted in a LuceneMultiMappingsAnalyzer");
    }
}

