/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.facet;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.shaker.facet.CountMap;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.mutable.MutableInt;

public abstract class JSONArrayFaceter<T>
extends Faceter {
    protected final int maxResults;
    protected final FilterRequest.FilterType filterType;
    protected final FilterFacet filterFacet = new FilterFacet();
    protected int skippedRows = 0;

    protected JSONArrayFaceter(String column, FilterRequest.FilterType filterType, int maxResults) {
        this.column = column;
        this.maxResults = maxResults;
        this.filterType = filterType;
    }

    protected JSONArrayFaceter(String column, FilterRequest.FilterType filterType) {
        this.column = column;
        this.filterType = filterType;
        this.maxResults = -1;
    }

    protected abstract List<T> parseColumnArray(String var1);

    protected abstract String extractFacetValue(T var1);

    @Override
    protected void observe(MemTable table, Column cd, boolean[] filters) {
        CountMap counts = new CountMap();
        CountMap rowCounts = new CountMap();
        for (int rowIdx = 0; rowIdx < table.rows.size(); ++rowIdx) {
            if (!filters[rowIdx]) continue;
            List<Object> items = this.parseColumnArray(table.rows.get(rowIdx).get(cd));
            if (CollectionUtils.isEmpty(items)) {
                ++this.skippedRows;
                continue;
            }
            items.forEach(bbox -> counts.inc(this.extractFacetValue(bbox)));
            items.stream().map(this::extractFacetValue).distinct().forEach(rowCounts::inc);
            Stream<FilterFacet.Val> valuesStream = counts.getMap().entrySet().stream().map(fieldValueCount -> {
                String fieldValue = (String)fieldValueCount.getKey();
                int count = ((MutableInt)fieldValueCount.getValue()).intValue();
                int rowCount = rowCounts.getMap().get(fieldValue).intValue();
                return new FilterFacet.Val(fieldValue, count, (long)rowCount);
            }).sorted((fieldVal1, fieldVal2) -> -Long.compare(fieldVal1.count, fieldVal2.count));
            if (this.maxResults > -1) {
                valuesStream = valuesStream.limit(this.maxResults);
            }
            this.filterFacet.values = valuesStream.collect(Collectors.toList());
            this.filterFacet.count = counts.size();
        }
    }

    @Override
    public FilterFacet compute() {
        this.filterFacet.column = this.column;
        this.filterFacet.type = this.filterType;
        return this.filterFacet;
    }

    public int getNumSkippedRows() {
        return this.skippedRows;
    }
}

