/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFaceter;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.utils.DKUtils;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class DateNonRangeFilter
extends DisplayFilterColumn {
    private ChartFilter.DateFilterPart dateFilterPart;
    private Set<Long> values = new HashSet<Long>();
    private AnyTemporal anyTemporalType = new AnyTemporal();
    private Calendar cal = DKUtils.getUTCCalendar();
    private boolean exclude;

    public DateNonRangeFilter(String column, ChartFilter.DateFilterPart dateFilterPart, Set<String> values, boolean exclude) {
        this.column = column;
        this.dateFilterPart = dateFilterPart;
        this.exclude = exclude;
        for (String value : values) {
            if ("___dku_no_value___".equals(value)) {
                this.values.add(-1L);
                continue;
            }
            this.values.add(Long.parseLong(value));
        }
    }

    @Override
    public boolean filterRow(MemRow row, Column cd) {
        long binId;
        String value = row.get(cd);
        long ts = this.anyTemporalType.msSinceEpoch(value);
        long l = binId = ts == Long.MAX_VALUE ? -1L : (long)DateAxisFaceter.getBinId(this.dateFilterPart, ts, this.cal);
        if (!this.exclude) {
            return this.values.contains(binId);
        }
        return !this.values.contains(binId);
    }
}

