/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class LineInputFormatAdapter
extends FileInputFormat<Void, RowWithFactories> {
    private final ColumnFactory columnFactory;
    private final RowFactory rowFactory;
    private final TextInputFormat realInputFormat;
    private final Column singleColumnHandle;

    public LineInputFormatAdapter(ColumnFactory cf, RowFactory rf, DatasetConfig inputConf, WarningsContext warningsContext) {
        this.columnFactory = cf;
        this.rowFactory = rf;
        this.realInputFormat = new TextInputFormat();
        Schema schema = inputConf.dataset.getSchema();
        int nbCols = schema.getColumns().size();
        if (nbCols != 1) {
            throw new RuntimeException("The input dataset must have 1 column (" + nbCols + " defined in schema)");
        }
        this.singleColumnHandle = this.columnFactory.column(((SchemaColumn)schema.getColumns().get(0)).getName());
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.realInputFormat.getSplits(job);
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new InternalRecordReader();
    }

    private class InternalRecordReader
    extends RecordReader<Void, RowWithFactories> {
        private RecordReader<LongWritable, Text> realRecordReader;
        private RowWithFactories currentRow = null;

        private InternalRecordReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            RecordReader rr = LineInputFormatAdapter.this.realInputFormat.createRecordReader(inputSplit, taskAttemptContext);
            rr.initialize(inputSplit, taskAttemptContext);
            this.realRecordReader = rr;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentRow = null;
            if (this.realRecordReader.nextKeyValue()) {
                Row row = LineInputFormatAdapter.this.rowFactory.row();
                Text textVal = (Text)this.realRecordReader.getCurrentValue();
                String strVal = textVal.toString();
                row.put(LineInputFormatAdapter.this.singleColumnHandle, strVal);
                this.currentRow = new RowWithFactories(LineInputFormatAdapter.this.columnFactory, LineInputFormatAdapter.this.rowFactory, row);
                return true;
            }
            return false;
        }

        public Void getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
            return this.currentRow;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.realRecordReader.getProgress();
        }

        public void close() throws IOException {
            this.realRecordReader.close();
        }
    }
}

