/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.input.formats.parquet.DSSParquetOutputFormat;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetRowBuilder;
import com.dataiku.dip.input.formats.parquet.ReusableParquetRow;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;

public class ParquetOutputFormatAdapter
extends FileOutputFormat<Void, RowWithFactories> {
    private static final DKULogger logger = DKULogger.getLogger(ParquetOutputFormatAdapter.class);
    private final ParquetFormatConfig parquetConfig;
    private final Schema outputSchema;
    private final WarningsContext warningsContext;

    public ParquetOutputFormatAdapter(DatasetConfig outputConf, WarningsContext warningsContext) {
        this.parquetConfig = (ParquetFormatConfig)outputConf.dataset.getFormatParams();
        this.outputSchema = outputConf.dataset.getSchema();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public RecordWriter<Void, RowWithFactories> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new InternalRecordWriter(taskAttemptContext);
    }

    public synchronized OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException {
        return new ParquetOutputFormat().getOutputCommitter(context);
    }

    private class InternalRecordWriter
    extends RecordWriter<Void, RowWithFactories> {
        private final TaskAttemptContext taskAttemptContext;
        private RecordWriter<Void, ReusableParquetRow> recordWriter;
        private ParquetRowBuilder rowBuilder;
        private ReusableParquetRow reusableParquetRow = new ReusableParquetRow();

        InternalRecordWriter(TaskAttemptContext taskAttemptContext) {
            this.taskAttemptContext = taskAttemptContext;
        }

        public void write(Void aVoid, RowWithFactories mrRow) throws IOException, InterruptedException {
            this.lazyInit(mrRow);
            this.reusableParquetRow.clear();
            boolean ok = false;
            try {
                this.rowBuilder.build(mrRow.getRow(), this.reusableParquetRow);
                ok = true;
            }
            catch (Exception e) {
                ParquetOutputFormatAdapter.this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row. " + e.getMessage(), (Throwable)e, logger);
            }
            if (ok) {
                this.recordWriter.write(null, (Object)this.reusableParquetRow);
            }
        }

        private void lazyInit(RowWithFactories firstRow) throws IOException, InterruptedException {
            if (this.recordWriter == null) {
                StreamColumnFactory cf = new StreamColumnFactory();
                if (firstRow != null) {
                    cf = firstRow.getColumnFactory();
                }
                this.rowBuilder = new ParquetRowBuilder(ParquetOutputFormatAdapter.this.outputSchema, (ColumnFactory)cf, ParquetOutputFormatAdapter.this.parquetConfig.parquetLowerCaseIdentifiers, ParquetOutputFormatAdapter.this.parquetConfig.parquetFlavor);
                DSSParquetOutputFormat outputFormat = new DSSParquetOutputFormat(ParquetOutputFormatAdapter.this.outputSchema, (ColumnFactory)cf, new WarningsContext(), ParquetOutputFormatAdapter.this.parquetConfig.parquetLowerCaseIdentifiers, ParquetOutputFormatAdapter.this.parquetConfig.parquetFlavor);
                this.recordWriter = outputFormat.getRecordWriter(this.taskAttemptContext);
            }
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.lazyInit(null);
            this.recordWriter.close(taskAttemptContext);
        }
    }
}

