/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.StaticColumnsCreatorProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public abstract class ProcessorMeta<TProcessor extends Processor, TProcParam extends StepParams> {
    public String plugin;

    public static String actionVerb(String vb) {
        return "<span class='action-verb'>" + vb + "</span>";
    }

    public abstract String getName();

    public abstract Category getCategory();

    public abstract Set<ProcessorTag> getTags();

    public ProcessorDesc describe(String language) {
        return this.describe();
    }

    public ProcessorDesc describe() {
        return null;
    }

    public String getHelp(String language) {
        return this.getHelp();
    }

    public String getHelp() {
        return null;
    }

    public String getDocPage() {
        return null;
    }

    public ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
        return this.getCapabilities(params, report, dialect);
    }

    public ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn, Dataset dataset) {
        return this.getCapabilities(params, report, dialect, conn);
    }

    public ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
        return new ProcessorCapabilitiesSummary();
    }

    public abstract Class<TProcParam> stepParamClass();

    protected Object selfReport(TProcParam param) throws Exception {
        return null;
    }

    public Object selfReportCast(StepParams param) throws Exception {
        return this.selfReport(param);
    }

    public StepParams expandParams(StepParams params, VariablesContext vc) {
        return params;
    }

    public abstract TProcessor build(TProcParam var1) throws Exception;

    public TProcessor build(TProcParam param, BaseProcessorsFactory.PipelineContext context) throws Exception {
        return this.build(param);
    }

    public TProcessor validateAndBuild(StepParams param, BaseProcessorsFactory.PipelineContext context) throws Exception {
        param.validate();
        return this.build(param, context);
    }

    public String getNativeSparkClassname() {
        throw new Error("unreachable");
    }

    public StaticColumnsCreatorProcessor buildStaticColumnsCreator(StepParams params) {
        throw new Error("unreachable");
    }

    public ProcessorSQLTranslator getSQLTranslator(StepParams param, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws Exception {
        throw new Error("unreachable");
    }

    public ProcessorSQLTranslator getSQLTranslator(StepParams param, ProcessorWithRecordedReport.ProcessorRecordedReport report, AbstractSQLConnection conn) throws Exception {
        return this.getSQLTranslator(param, report);
    }

    protected String translate(String language, String translationID, String defaultValue) {
        TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return sts.translate(language, translationID, defaultValue, new Object[0]);
    }

    public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
        throw new NotImplementedException("Data lineage not implemented yet for processor: " + this.getName());
    }

    public static class ProcessorCapabilitiesSummary {
        private Set<ProcessorCapabilities> can = Sets.newHashSet();
        private Map<ProcessorCapabilities, String> could = Maps.newHashMap();

        public ProcessorCapabilitiesSummary withCan(ProcessorCapabilities ... c2) {
            this.can.addAll(Arrays.asList(c2));
            return this;
        }

        public ProcessorCapabilitiesSummary withCould(ProcessorCapabilities c2, String reason) {
            this.could.put(c2, reason);
            return this;
        }

        public boolean can(ProcessorCapabilities c2) {
            return this.can.contains((Object)c2);
        }

        public String reasonForInability(ProcessorCapabilities c2) {
            if (this.could.containsKey((Object)c2)) {
                return this.could.get((Object)c2);
            }
            if (c2 == ProcessorCapabilities.NATIVE_SPARK_IMPL) {
                return "No optimized Spark implementation available";
            }
            if (c2 == ProcessorCapabilities.SQL_TRANSLATABLE) {
                return "Not translatable to SQL";
            }
            return "not possible";
        }
    }
}

