/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.reshaping;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;

public class ArrayFold
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<ArrayFold, Parameter> META = new ProcessorMeta<ArrayFold, Parameter>(){

        @Override
        public String getName() {
            return "ArrayFold";
        }

        @Override
        public String getDocPage() {
            return "array-fold";
        }

        @Override
        public Category getCategory() {
            return Category.RESHAPING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.RESHAPING, ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ArrayFold.DESCRIPTION", 1.actionVerb("Fold") + " an array")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column"));
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ArrayFold.HELP", "Transform a cell containing a JSON array and fold it into several rows, performing the transformation in-place. Each generated row contains a single value from the input array. All other columns are copied in each generated row.");
        }

        @Override
        public ArrayFold build(Parameter parameter) throws Exception {
            return new ArrayFold(parameter.column);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter arrayFoldParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Set<String> availableColumns = previousDatasetPairLineage.getOutputColumns();
                if (StringUtils.isNotBlank((String)arrayFoldParams.column)) {
                    for (String availableColumn : availableColumns) {
                        updatedDatasetPairLineage.addFactorizedColumnRelations(arrayFoldParams.column, availableColumn, true);
                    }
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private String column;
    private Column foldCD;
    static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.processors.arrayfold");

    public ArrayFold(String column) {
        this.column = column;
    }

    public void init() {
        this.foldCD = this.getCf().column(this.column, Processor.ProcessorRole.INPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.foldCD);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            JSONArray array = new JSONArray(v);
            for (int i = 0; i < array.length(); ++i) {
                Object so = array.get(i);
                String s = so == null ? null : so.toString();
                Row newRow = this.getRf().row();
                for (Column c2 : this.getCf().columns()) {
                    String colVal = row.get(c2);
                    if (StringUtils.isBlank((String)colVal)) continue;
                    newRow.put(c2, colVal);
                }
                newRow.put(this.foldCD, s);
                if (newRow instanceof MemRow && v.length() > 2000) {
                    ((MemRow)newRow).compact();
                }
                this.getProcessorOutput().emitRow(newRow);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postProcess() throws Exception {
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;

        public void validate() throws IllegalArgumentException {
        }
    }
}

