/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.DateProcessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DateIncrement
extends DateProcessor {
    public static final ProcessorMeta<DateIncrement, Parameter> META = new DateProcessor.DateProcessorMeta<DateIncrement, Parameter>(){

        @Override
        public String getName() {
            return "DateIncrement";
        }

        @Override
        public String getDocPage() {
            return "date-increment";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.DateIncrement.HELP", "This processor takes a column containing a date in standard ISO8601 format (ie, detected with meaning 'Date') and increment it with a specified value");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public DateIncrement build(Parameter parameter) throws Exception {
            return new DateIncrement(parameter);
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION", 1.actionVerb("Increment") + " date with a specified value"), false).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION.IN_COL", "Column")).withParam(ParamDesc.advancedSelect("incrementBy", this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION.INCREMENT_BY", "Increment by"), "", IncrementBy.class).withDefaultValue(IncrementBy.STATIC)).withParam("increment", "Integer", false, true, this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION.INCREMENT", "Increment")).withParam("valueCol", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION.VALUE_COL", "Value in column")).withParam(ParamDesc.advancedSelect("datePart", this.translate(language, "SHAKER.PROCESSOR.DateIncrement.DESCRIPTION.DATE_PART", "Date part"), "", DatePart.class).withDefaultValue(DatePart.DAY)).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (dialect.getOperator(QueryUtils.OperatorType.DATE_ADD) == null) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: database doesn't support incrementing dates");
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter parameter = (Parameter)pss.params;
            if (StringUtils.isBlank((String)parameter.inCol)) {
                throw new IllegalConfigurationException("Missing input column information for lineage on " + this.getName() + " processor parameters.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                String outputColumn;
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)parameter.outCol)) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(parameter.inCol, parameter.outCol);
                }
                String string = outputColumn = StringUtils.isNotBlank((String)parameter.outCol) ? parameter.outCol : parameter.inCol;
                if (parameter.incrementBy == IncrementBy.COLUMN && StringUtils.isNotBlank((String)parameter.valueCol)) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(parameter.valueCol, outputColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private Column inCD;
    private Column outCD;
    private Parameter params;

    public DateIncrement(Parameter params) {
        this.params = params;
    }

    public void init() throws Exception {
        this.inCD = this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = StringUtils.isNotBlank((String)this.params.outCol) ? this.getColumnFactory().columnAfter(this.params.inCol, this.params.outCol, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().column(this.params.inCol, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String rowVal = row.get(this.inCD);
        if (StringUtils.isNotBlank((String)rowVal)) {
            Object dateTime;
            try {
                dateTime = new DKUFormulaUtils().asTemporal(rowVal);
            }
            catch (Exception e) {
                return;
            }
            int incrementValue = 0;
            if (this.params.incrementBy.equals(IncrementBy.COLUMN)) {
                if (StringUtils.isNotBlank((String)this.params.valueCol)) {
                    Column valueCol = this.cf.column(this.params.valueCol, Processor.ProcessorRole.INPUT_COLUMN);
                    try {
                        incrementValue = Integer.parseInt(row.get(valueCol));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                incrementValue = this.params.increment;
            }
            if (dateTime instanceof DateTime) {
                switch (this.params.datePart) {
                    case YEAR: {
                        result = ((DateTime)dateTime).plusYears(incrementValue);
                        break;
                    }
                    case QUARTER: {
                        result = ((DateTime)dateTime).plusMonths(3 * incrementValue);
                        break;
                    }
                    case MONTH: {
                        result = ((DateTime)dateTime).plusMonths(incrementValue);
                        break;
                    }
                    case WEEK: {
                        result = ((DateTime)dateTime).plusWeeks(incrementValue);
                        break;
                    }
                    case DAY: {
                        result = ((DateTime)dateTime).plusDays(incrementValue);
                        break;
                    }
                    case HOUR: {
                        result = ((DateTime)dateTime).plusHours(incrementValue);
                        break;
                    }
                    case MINUTE: {
                        result = ((DateTime)dateTime).plusMinutes(incrementValue);
                        break;
                    }
                    case SECOND: {
                        result = ((DateTime)dateTime).plusSeconds(incrementValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected date part: " + String.valueOf(this.params.datePart));
                    }
                }
                row.put(this.outCD, result.toString());
            } else if (dateTime instanceof LocalDateTime) {
                switch (this.params.datePart) {
                    case YEAR: {
                        result = ((LocalDateTime)dateTime).plusYears(incrementValue);
                        break;
                    }
                    case QUARTER: {
                        result = ((LocalDateTime)dateTime).plusMonths(3 * incrementValue);
                        break;
                    }
                    case MONTH: {
                        result = ((LocalDateTime)dateTime).plusMonths(incrementValue);
                        break;
                    }
                    case WEEK: {
                        result = ((LocalDateTime)dateTime).plusWeeks(incrementValue);
                        break;
                    }
                    case DAY: {
                        result = ((LocalDateTime)dateTime).plusDays(incrementValue);
                        break;
                    }
                    case HOUR: {
                        result = ((LocalDateTime)dateTime).plusHours(incrementValue);
                        break;
                    }
                    case MINUTE: {
                        result = ((LocalDateTime)dateTime).plusMinutes(incrementValue);
                        break;
                    }
                    case SECOND: {
                        result = ((LocalDateTime)dateTime).plusSeconds(incrementValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected date part: " + String.valueOf(this.params.datePart));
                    }
                }
                row.put(this.outCD, DatetimeNoTz.CANONICAL_FORMATTER.print((ReadablePartial)result));
            } else if (dateTime instanceof LocalDate) {
                switch (this.params.datePart) {
                    case YEAR: {
                        result = ((LocalDate)dateTime).plusYears(incrementValue);
                        break;
                    }
                    case QUARTER: {
                        result = ((LocalDate)dateTime).plusMonths(3 * incrementValue);
                        break;
                    }
                    case MONTH: {
                        result = ((LocalDate)dateTime).plusMonths(incrementValue);
                        break;
                    }
                    case WEEK: {
                        result = ((LocalDate)dateTime).plusWeeks(incrementValue);
                        break;
                    }
                    case DAY: {
                        result = ((LocalDate)dateTime).plusDays(incrementValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected date part: " + String.valueOf(this.params.datePart));
                    }
                }
                row.put(this.outCD, result.toString());
            } else {
                throw new IllegalStateException("Unexpected date type: " + dateTime.getClass().getCanonicalName());
            }
        }
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    extends DateProcessor.DateParameter {
        private static final long serialVersionUID = -1L;
        int increment;
        public IncrementBy incrementBy = IncrementBy.STATIC;
        public String valueCol;
        DatePart datePart = DatePart.YEAR;

        @Override
        public void validate() throws IllegalArgumentException {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IncrementBy implements Labelled
    {
        COLUMN{

            @Override
            public String getLabel() {
                return "Value in column";
            }
        }
        ,
        STATIC{

            @Override
            public String getLabel() {
                return "Static value";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DatePart implements Labelled
    {
        YEAR{

            @Override
            public String getLabel() {
                return "Year";
            }
        }
        ,
        QUARTER{

            @Override
            public String getLabel() {
                return "Quarter";
            }
        }
        ,
        MONTH{

            @Override
            public String getLabel() {
                return "Month";
            }
        }
        ,
        WEEK{

            @Override
            public String getLabel() {
                return "Week";
            }
        }
        ,
        DAY{

            @Override
            public String getLabel() {
                return "Day";
            }
        }
        ,
        HOUR{

            @Override
            public String getLabel() {
                return "Hour";
            }
        }
        ,
        MINUTE{

            @Override
            public String getLabel() {
                return "Minute";
            }
        }
        ,
        SECOND{

            @Override
            public String getLabel() {
                return "Second";
            }
        };

    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            if (StringUtils.equals((String)this.parameter.inCol, (String)this.parameter.outCol)) {
                this.parameter.outCol = null;
            }
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.inCol});
            boolean incrementByColumn = this.parameter.incrementBy.equals(IncrementBy.COLUMN);
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            if (StringUtils.isNotBlank((String)this.parameter.outCol)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.outCol);
            }
            if (incrementByColumn && StringUtils.isNotBlank((String)this.parameter.valueCol)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.valueCol);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            for (String column : affectedColumns) {
                SchemaColumn inputSchemaColumn = input.getMandatoryCurrentColumn(column);
                Object incValue = incrementByColumn ? input.col(this.parameter.valueCol) : Integer.valueOf(this.parameter.increment);
                ExpressionBuilder col = input.col(inputSchemaColumn);
                ExpressionBuilder e = col.dateAdd(incValue, this.parameter.datePart.name());
                input.addAfterOrReplaceColumn(inputSchemaColumn, e, inputSchemaColumn.getType(), this.parameter.outCol, false);
            }
            return input;
        }
    }
}

