/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.TimezonableProcessor;
import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysExtractionHelper;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.Hours;
import com.dataiku.dss.shadelib.org.joda.time.Minutes;
import com.dataiku.dss.shadelib.org.joda.time.Months;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Seconds;
import com.dataiku.dss.shadelib.org.joda.time.Weeks;
import com.dataiku.dss.shadelib.org.joda.time.Years;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateDifference
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "DateDifference";
        }

        @Override
        public String getDocPage() {
            return "date-difference";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.DATE});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.DateDifference.HELP", "Compute the difference between an ISO-8601 formatted date column (*yyyy-MM-ddTHH:mm:ss.SSSZ*) and another time reference: the current time, a fixed date, or another column. \n\n# Options\n\n**Time since column**\n\nColumn containing data in ISO-8601 format. Use a Prepare step to parse your data into this format if it isn't already. \n\n**Until**\n\nChoose the second time reference to compute the difference \u2014 now, another date column, or a fixed date.\n\n**Output time unit**\n\nDetermine the unit of time in which to express the datetime difference \u2014 year, month, week, day, hour, minute or second. \n\n**Output column**\n\nColumn into which the datetime difference will be written. \n\n**Reverse output**\n\nMultiply the computed difference by -1, reversing it: *3 days* \u2192 *-3 days*. \n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            ArrayList availableCalendars = Lists.newArrayList((Object[])new String[]{"FR", "US", "IN", "ES", "DE"});
            ArrayList<String> calendarChoiceValues = new ArrayList<String>();
            calendarChoiceValues.add("extract_from_column");
            calendarChoiceValues.addAll(availableCalendars);
            ArrayList<String> calendarChoiceLabels = new ArrayList<String>();
            calendarChoiceLabels.add(this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.USE_COUNTRY_CODE_FROM_OTHER_COLUMN", "Use country code from another column..."));
            calendarChoiceLabels.addAll(availableCalendars);
            ArrayList<String> timezoneIDs = new ArrayList<String>();
            timezoneIDs.add("use_preferred_timezone");
            timezoneIDs.addAll(Arrays.asList(TimezonableProcessor.friendlyTimezoneIds));
            ArrayList<String> timezoneNames = new ArrayList<String>();
            timezoneNames.add(this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.COUNTRY_DEFAULT_TIMEZONE", "Country's default timezone"));
            timezoneNames.addAll(Arrays.asList(TimezonableProcessor.friendlyTimezoneNames(language)));
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION", 1.actionVerb("Compute") + " difference between dates"), false).withMNEColParam("input1", this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION.INPUT1", "First date column")).withColParam("input2", this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION.INPUT2", "Second date column")).withMNESParam("output", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withParam("refDate", "string", false, true, "SHAKER.PROCESSORS.DESCRIPTION.REF_DATE", "Second date").withBool("reverse", this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION.REVERSE", "Revert output")).withParam(ParamDesc.advancedSelect("outputUnit", this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION.OUTPUT_UNIT", "Time unit"), "", TimeUnit.class).withDefaultValue(TimeUnit.DAYS)).withParam(ParamDesc.advancedSelect("compareTo", this.translate(language, "SHAKER.PROCESSOR.DateDifference.DESCRIPTION.COMPARE_TO", "Compare to ..."), "", CompareTo.class).withDefaultValue(CompareTo.NOW)).withParam(ParamDesc.advancedSelect("calendar_id", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_ID", "Calendar"), this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_ID", "Calendar"), calendarChoiceValues.toArray(new String[0]), calendarChoiceLabels.toArray(new String[0])).withMandatory(false)).withParam("calendar_src", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.CALENDAR_SRC", "Country code source column")).withParam(ParamDesc.advancedSelect("timezone_id", this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.TIMEZONE_ID", "Timezone"), "Timezone", timezoneIDs.toArray(new String[0]), timezoneNames.toArray(new String[0])).withDefaultValue("use_preferred_timezone").withMandatory(false)).withParam("timezone_src", "generic", false, true, this.translate(language, "SHAKER.PROCESSOR.HolidaysComputer.DESCRIPTION.TIMEZONE_SRC", "Timezone source column"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"input1", "input2", "output"});
        }

        @Override
        public StreamImpl build(Parameter param) {
            return new StreamImpl(param);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)params;
            ProcessorMeta.ProcessorCapabilitiesSummary capabilities = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (p.excludeWeekends || p.excludeHolidays) {
                String excludeOption = p.excludeWeekends ? "'Exclude weekends'" : "'Exclude bank holidays'";
                capabilities.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, excludeOption + " option is not supported in SQL");
                capabilities.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, excludeOption + " option is not supported with native Spark");
                return capabilities;
            }
            return capabilities.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.SQL_TRANSLATABLE);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.time.DateDifferenceNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter parameter = (Parameter)pss.params;
            if (StringUtils.isBlank((String)parameter.input1)) {
                throw new IllegalConfigurationException("Missing input column information for lineage on " + this.getName() + " processor parameters.");
            }
            if (StringUtils.isBlank((String)parameter.output)) {
                throw new IllegalConfigurationException("Missing output column information for lineage on " + this.getName() + " processor parameters.");
            }
            if (parameter.compareTo == CompareTo.COLUMN && StringUtils.isBlank((String)parameter.input2)) {
                throw new IllegalConfigurationException("Missing value column information for lineage on " + this.getName() + " processor parameters.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                updatedDatasetPairLineage.addFactorizedColumnRelations(parameter.input1, parameter.output);
                if (parameter.compareTo == CompareTo.COLUMN) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(parameter.input2, parameter.output);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    public static int getDifference(DateTime dt1, DateTime dt2, TimeUnit field) {
        switch (field) {
            case SECONDS: {
                return Seconds.secondsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getSeconds();
            }
            case MINUTES: {
                return Minutes.minutesBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getMinutes();
            }
            case HOURS: {
                return Hours.hoursBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getHours();
            }
            case DAYS: {
                return Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
            }
            case WEEKS: {
                return Weeks.weeksBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getWeeks();
            }
            case MONTHS: {
                return Months.monthsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getMonths();
            }
            case YEARS: {
                return Years.yearsBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getYears();
            }
        }
        return 0;
    }

    public static enum TimeUnit implements Labelled
    {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        WEEKS,
        MONTHS,
        YEARS;


        @Override
        public String getLabel() {
            String s = super.toString();
            return s.substring(0, 1) + s.substring(1).toLowerCase();
        }
    }

    public static class StreamImpl
    extends TimezonableProcessor {
        Parameter param;
        Column inCD1;
        Column inCD2;
        Column outCD;
        AnyTemporal temporalMeaning = new AnyTemporal();
        DateTime now;
        DateTime ref;
        boolean usePreferredTimezones;
        Column inCalendarCol;
        private static Logger logger = Logger.getLogger((String)"dku.date-diff");

        public StreamImpl(Parameter param) {
            this.param = param;
        }

        @Override
        public Map<String, File> gatherRequirements() {
            Map<String, File> requirements = super.gatherRequirements();
            String installDir = ApplicationConfigurator.getInstallFolder();
            if (StringUtils.isBlank((String)installDir)) {
                logger.error((Object)"DKUINSTALLDIR is not defined. Cannot load holidays/weekends database.");
            }
            requirements.put("dku.holidays.db", new File(installDir, "resources/holidays.db"));
            requirements.put("dku.weekends.db", new File(installDir, "resources/weekends.db"));
            return requirements;
        }

        @Override
        public void setRequiredFiles(Map<String, File> requiredFiles) {
            if (!this.param.excludeHolidays && !this.param.excludeWeekends) {
                return;
            }
            super.setRequiredFiles(requiredFiles);
            File holidaysDBFile = requiredFiles.get("dku.holidays.db");
            File weekendsDBFile = requiredFiles.get("dku.weekends.db");
            HolidaysExtractionHelper.loadSharedDatabase((File)weekendsDBFile, (File)holidaysDBFile);
        }

        private DateTime anyValueToDateTime(String v) {
            long ts = this.temporalMeaning.msSinceEpoch(v);
            if (ts == Long.MAX_VALUE) {
                return null;
            }
            return new DateTime(ts).withZone(DateTimeZone.UTC);
        }

        public void init() throws Exception {
            this.inCD1 = this.getColumnFactory().column(this.param.input1, Processor.ProcessorRole.INPUT_COLUMN);
            if (this.param.compareTo == CompareTo.COLUMN) {
                if (this.param.input2 != null && !this.param.input2.equals("")) {
                    this.inCD2 = this.getColumnFactory().column(this.param.input2, Processor.ProcessorRole.INPUT_COLUMN);
                }
            } else if (this.param.compareTo == CompareTo.NOW) {
                this.now = new DateTime();
            } else if (this.param.compareTo == CompareTo.DATE) {
                this.ref = this.anyValueToDateTime(this.param.refDate);
            }
            if (StringUtils.equalsIgnoreCase((String)this.param.calendar_id, (String)"extract_from_column")) {
                this.inCalendarCol = this.getColumnFactory().column(this.param.calendar_src, Processor.ProcessorRole.INPUT_COLUMN);
            }
            this.usePreferredTimezones = StringUtils.equalsIgnoreCase((String)this.param.timezone_id, (String)"use_preferred_timezone");
            if (!this.usePreferredTimezones) {
                this.initTimezonableWithParams(this.param.timezone_id, this.param.timezone_src);
            }
            if (this.param.output != null && !this.param.output.equals("")) {
                this.outCD = this.getColumnFactory().columnAfter(this.param.input1, this.param.output, Processor.ProcessorRole.OUTPUT_COLUMN);
            }
        }

        private String getCalendarId(Row row) {
            String calId = StringUtils.equalsIgnoreCase((String)this.param.calendar_id, (String)"extract_from_column") ? row.get(this.inCalendarCol) : this.param.calendar_id;
            if (calId == null) {
                calId = "";
            }
            return calId;
        }

        public void processRow(Row row) throws Exception {
            String first = row.get(this.inCD1);
            DateTime firstDate = null;
            boolean firstDateIsDateOnly = false;
            try {
                firstDate = this.anyValueToDateTime(first);
                firstDateIsDateOnly = first != null && first.length() == 10;
            }
            catch (Exception e) {
                return;
            }
            DateTime secondDate = null;
            if (this.param.compareTo == CompareTo.COLUMN) {
                String second = row.get(this.inCD2);
                try {
                    secondDate = this.anyValueToDateTime(second);
                }
                catch (Exception e) {
                    return;
                }
            } else if (this.param.compareTo == CompareTo.NOW) {
                secondDate = this.now;
                if (firstDateIsDateOnly) {
                    secondDate = this.now.toLocalDate().toDateTimeAtStartOfDay(DateTimeZone.UTC);
                }
            } else if (this.param.compareTo == CompareTo.DATE) {
                secondDate = this.ref;
                if (firstDateIsDateOnly) {
                    secondDate = this.ref.toLocalDate().toDateTimeAtStartOfDay(DateTimeZone.UTC);
                }
            }
            if (firstDate != null && secondDate != null) {
                if (!this.param.excludeHolidays && !this.param.excludeWeekends || this.param.outputUnit != TimeUnit.DAYS) {
                    row.put(this.outCD, (this.param.reverse ? -1 : 1) * DateDifference.getDifference(firstDate, secondDate, this.param.outputUnit));
                    return;
                }
                String calendarId = this.getCalendarId(row);
                int daysDifference = DateDifference.getDifference(firstDate, secondDate, this.param.outputUnit);
                HashSet<Integer> removedDays = new HashSet<Integer>();
                ArrayList<HolidayOccurrence> occurrences = new ArrayList<HolidayOccurrence>();
                if (this.param.excludeWeekends) {
                    occurrences.addAll(this.computeWeekends(row, firstDate, daysDifference, calendarId));
                }
                if (this.param.excludeHolidays) {
                    occurrences.addAll(this.computeHolidays(row, firstDate, secondDate, calendarId));
                }
                for (HolidayOccurrence occurrence : occurrences) {
                    if (occurrence.type != HolidayOccurrence.Type.BANK && occurrence.type != HolidayOccurrence.Type.WEEKEND || removedDays.contains(occurrence.dayFrom)) continue;
                    removedDays.add(occurrence.dayFrom);
                    --daysDifference;
                }
                row.put(this.outCD, (this.param.reverse ? -1 : 1) * (switch (this.param.outputUnit) {
                    case TimeUnit.SECONDS -> daysDifference * 24 * 60 * 60;
                    case TimeUnit.MINUTES -> daysDifference * 24 * 60;
                    case TimeUnit.HOURS -> daysDifference * 24;
                    case TimeUnit.DAYS -> daysDifference;
                    case TimeUnit.WEEKS -> daysDifference / 7;
                    case TimeUnit.MONTHS -> daysDifference / 30;
                    case TimeUnit.YEARS -> daysDifference / 365;
                    default -> 0;
                }));
            }
        }

        private List<HolidayOccurrence> computeHolidays(Row row, DateTime firstDate, DateTime secondDate, String calendarId) {
            if (this.usePreferredTimezones) {
                return HolidaysExtractionHelper.holidaysDatabase.searchForPeriod(firstDate, secondDate, calendarId);
            }
            DateTimeZone currentTimezone = this.getTimezone(row);
            if (currentTimezone == null) {
                return null;
            }
            GregorianCalendar date = new GregorianCalendar(currentTimezone.toTimeZone());
            date.setTime(firstDate.toDate());
            int lowerYear = date.get(1);
            int lowerMonth = date.get(2) + 1;
            date.setTime(secondDate.toDate());
            int lowerDay = date.get(5);
            int upperYear = date.get(1);
            int upperMonth = date.get(2) + 1;
            int upperDay = date.get(5);
            return HolidaysExtractionHelper.holidaysDatabase.searchForPeriod(lowerYear, lowerMonth, lowerDay, upperYear, upperMonth, upperDay, calendarId);
        }

        private List<HolidayOccurrence> computeWeekends(Row row, DateTime firstDate, int daysDifference, String calendarId) {
            if (this.usePreferredTimezones) {
                return HolidaysExtractionHelper.weekendDatabase.searchForPeriod(firstDate, daysDifference, calendarId);
            }
            DateTimeZone currentTimezone = this.getTimezone(row);
            if (currentTimezone == null) {
                return null;
            }
            GregorianCalendar outCal = new GregorianCalendar(currentTimezone.toTimeZone());
            outCal.setTime(firstDate.toDate());
            int year = outCal.get(1);
            int monthOfYear = outCal.get(2) + 1;
            int dayOfMonth = outCal.get(5);
            return HolidaysExtractionHelper.weekendDatabase.searchForPeriod(year, monthOfYear, dayOfMonth, daysDifference, calendarId);
        }

        public void postProcess() throws Exception {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            Type refType;
            ExpressionBuilder ref;
            DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
            ArrayList affectedColumns = Lists.newArrayList((Object[])new String[]{this.parameter.input1});
            if (this.parameter.compareTo == CompareTo.COLUMN && StringUtils.isNotBlank((String)this.parameter.input2)) {
                affectedColumns.add(this.parameter.input2);
            }
            boolean needsSubquery = input.isAnyCreatedOrModifiedByCurrentQuery(affectedColumns);
            if (StringUtils.isNotBlank((String)this.parameter.output)) {
                needsSubquery |= input.isCreatedOrModifiedByCurrentQuery(this.parameter.output);
            }
            if (needsSubquery) {
                input = input.makeSubquery();
            }
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            SchemaColumn input1Col = input.getMandatoryCurrentColumn(this.parameter.input1);
            ExpressionBuilder dt = input.col(input1Col);
            Type dtType = input1Col.getType();
            if (!input1Col.getType().isTemporal()) {
                dt = dt.castToDate();
                dtType = Type.DATE;
            }
            switch (this.parameter.compareTo) {
                case COLUMN: {
                    SchemaColumn input2Col = input.getMandatoryCurrentColumn(this.parameter.input2);
                    ref = input.col(input2Col);
                    refType = input2Col.getType();
                    if (!input2Col.getType().isTemporal()) {
                        ref = ref.castToDate();
                        refType = Type.DATE;
                    }
                    if (dtType == refType) break;
                    if (!dtType.isTimestamp()) {
                        dt = dt.castToDate();
                    }
                    if (!refType.isTimestamp()) {
                        ref = ref.castToDate();
                    }
                    dtType = Type.DATE;
                    refType = Type.DATE;
                    break;
                }
                case DATE: {
                    DateTime refDate = formatter.parseDateTime(this.parameter.refDate);
                    ref = dtType == Type.DATEONLY ? ef.cst(refDate.toLocalDate()) : (dtType == Type.DATETIMENOTZ ? ef.cst(refDate.toLocalDateTime()) : ef.cst(refDate));
                    refType = dtType;
                    break;
                }
                case NOW: {
                    DateTime refDate = new DateTime();
                    ref = dtType == Type.DATEONLY ? ef.cst(refDate.toLocalDate()) : (dtType == Type.DATETIMENOTZ ? ef.cst(refDate.toLocalDateTime()) : ef.cst(refDate));
                    refType = dtType;
                    break;
                }
                default: {
                    throw new Error("unreachable");
                }
            }
            if (!this.parameter.reverse) {
                ExpressionBuilder swap = ref;
                ref = dt;
                dt = swap;
                Type swapType = refType;
                refType = dtType;
                dtType = swapType;
            }
            dt.expr.outputType.dssType = dtType;
            ref.expr.outputType.dssType = refType;
            ExpressionBuilder diff = switch (this.parameter.outputUnit) {
                case TimeUnit.YEARS -> dt.minusDate(ref, "YEAR");
                case TimeUnit.MONTHS -> dt.minusDate(ref, "MONTH");
                case TimeUnit.WEEKS -> dt.minusDate(ref, "WEEK");
                case TimeUnit.DAYS -> dt.minusDate(ref, "DAY");
                case TimeUnit.HOURS -> dt.minusDate(ref, "HOUR");
                case TimeUnit.MINUTES -> dt.minusDate(ref, "MINUTE");
                case TimeUnit.SECONDS -> dt.minusDate(ref, "SECOND");
                default -> throw new Error("unreachable");
            };
            input.addLastOrReplaceColumn((SchemaColumn)input.getInputColumn(this.parameter.output).orNull(), diff, Type.BIGINT, this.parameter.output);
            input.replaceSelect(this.parameter.output, diff.castToBigint(), this.parameter.output);
            return input;
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String input1;
        public String input2;
        public String output;
        public TimeUnit outputUnit;
        public CompareTo compareTo;
        public String refDate;
        public boolean reverse = false;
        public boolean excludeWeekends = false;
        public boolean excludeHolidays = false;
        public String calendar_id = "FR";
        public String calendar_src;
        public String timezone_id = "use_preferred_timezone";
        public String timezone_src;

        public void validate() throws IllegalArgumentException {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CompareTo implements Labelled
    {
        COLUMN{

            @Override
            public String getLabel() {
                return "Compare to column";
            }
        }
        ,
        NOW{

            @Override
            public String getLabel() {
                return "Compare to now";
            }
        }
        ,
        DATE{

            @Override
            public String getLabel() {
                return "Compare to specified date";
            }
        };

    }
}

