/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform.interactivedatapreparation;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.shaker.processors.transform.interactivedatapreparation.InteractiveExtractor;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.springframework.stereotype.Service;

@Service
public class InteractiveDataPreparationService {
    private List<String> getColumnRows(MemScriptRunner.TableWithReport twr, String column, String firstString) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (!firstString.isEmpty()) {
            sentences.add(firstString);
        }
        MemColumn c2 = twr.table.column(column);
        ArrayList<MemRow> rowsRandomized = new ArrayList<MemRow>(twr.table.rows);
        ArrayList<Boolean> filterRandomized = twr.filters != null ? Booleans.asList((boolean[])twr.filters) : new ArrayList<Boolean>(Collections.nCopies(rowsRandomized.size(), true));
        int SEED = 42;
        Collections.shuffle(rowsRandomized, new Random(SEED));
        Collections.shuffle(filterRandomized, new Random(SEED));
        int rowIdx = -1;
        for (MemRow mr : rowsRandomized) {
            String v;
            if (mr.isDeleted() || (v = mr.get(c2)) == null || v.length() == 0 || v.equals(firstString) || !((Boolean)filterRandomized.get(++rowIdx)).booleanValue()) continue;
            sentences.add(v);
        }
        return sentences;
    }

    List<String> getColumnNames(MemTable mt) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column col : mt.columns()) {
            MemColumn mCol = mt.getColumn(col.getName());
            if (mCol.state == 3) continue;
            columnNames.add(mCol.getName());
        }
        return columnNames;
    }

    public InteractiveExtractor.ExtractorResponse generateSmartPattern(MemScriptRunner.TableWithReport twr, String column, boolean onColumnNames, List<InteractiveExtractor.Selection> selections, List<String> excluded, String customRegex, String firstString) {
        List<String> sentences = onColumnNames ? this.getColumnNames(twr.table) : this.getColumnRows(twr, column, firstString);
        InteractiveExtractor ie = new InteractiveExtractor(selections, excluded, sentences);
        InteractiveExtractor.ExtractorResponse extractorResponse = ie.guess();
        if (!customRegex.equals("")) {
            try {
                Pattern.compile(customRegex);
                extractorResponse.addCustomProposition(customRegex);
            }
            catch (PatternSyntaxException ex) {
                extractorResponse.customRegexError = ExceptionUtils.getMessageWithCauses((Throwable)ex);
            }
        }
        return extractorResponse;
    }
}

