/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ColumnOnly;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.typespecific.UserAgentClassifierAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UserAgentClassifier {
    public static final List<String> OUTPUT_SUFFIXES = Arrays.asList("_category", "_type", "_brand", "_version", "_os", "_osversion", "_osflavor");
    public static final ProcessorMeta<StreamImpl, ColumnOnly> META = new ProcessorMeta<StreamImpl, ColumnOnly>(){

        @Override
        public String getName() {
            return "UserAgentClassifier";
        }

        @Override
        public String getDocPage() {
            return "user-agent";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.WEB, ProcessorTag.ENRICH});
        }

        @Override
        public Class<ColumnOnly> stepParamClass() {
            return ColumnOnly.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.UserAgentClassifier.HELP", "This processor parses and extracts information from a browser's User-Agent string.\n\nThe following columns are created and may or may not be filled depending on the user agents\n\n* 'type': one of:\n   * 'browser' (desktop OS)\n   * 'tablet'\n   * 'phone'\n   * 'mobile' (could be either a tablet or phone)\n   * 'bot' (crawlers, spam, ...)\n   * 'library' (wget, urllib2, ...)\n   * 'rss' : RSS feed readers\n   * 'unknown'\n* 'brand': Chrome, Firefox, Safari, Android, ...\n* 'category': Quite like brand, but tries to distinguish browsers of the same brand that behave differently. For example, IE8 and IE9 are the same brand, but different categories\n* 'version'\n* 'os' : Operating system\n* 'osversion' : Version of the Operating system\n* 'osflavor' : Variant of the Operating System (Linux distribution, 32/64 bits, ...)\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.UserAgentClassifier.DESCRIPTION", 1.actionVerb("Classify") + " User-Agent")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public StreamImpl build(ColumnOnly parameter) throws Exception {
            return new StreamImpl(parameter.column);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator(((ColumnOnly)parameter).column);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof ColumnOnly)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            ColumnOnly params = (ColumnOnly)pss.params;
            if (StringUtils.isBlank((String)params.column)) {
                throw new IllegalConfigurationException("Missing column for UserAgentClassifier processor");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                String inputColumn = params.column;
                for (String outputSuffix : OUTPUT_SUFFIXES) {
                    String outputColumn = inputColumn + outputSuffix;
                    updatedDatasetPairLineage.removeRelationsOnColumn(outputColumn);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(inputColumn, outputColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final String inCol;
        private Column inCD;
        private Column type;
        private Column category;
        private Column brand;
        private Column version;
        private Column os;
        private Column osVersion;
        private Column osFlavor;
        private UserAgentClassifierAlgorithm userAgentClassifierAlgorithm;
        MeaningDetector text = new Text();

        public StreamImpl(String inCol) {
            this.inCol = inCol;
        }

        public void init() {
            this.inCD = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
            this.osFlavor = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_osflavor", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.osVersion = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_osversion", Processor.ProcessorRole.OUTPUT_COLUMN);
            if (this.osVersion instanceof MemColumn) {
                ((MemColumn)this.osVersion).forceType(this.text);
            }
            this.os = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_os", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.version = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_version", Processor.ProcessorRole.OUTPUT_COLUMN);
            if (this.version instanceof MemColumn) {
                ((MemColumn)this.version).forceType(this.text);
            }
            this.brand = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_brand", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.category = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_category", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.type = this.getColumnFactory().columnAfter(this.inCol, this.inCol + "_type", Processor.ProcessorRole.OUTPUT_COLUMN);
            this.userAgentClassifierAlgorithm = new UserAgentClassifierAlgorithm();
        }

        public void processRow(Row row) throws Exception {
            String v = row.get(this.inCD);
            if (v == null || v.isEmpty()) {
                return;
            }
            UserAgentClassifierAlgorithm.UserAgentMatch uam = new UserAgentClassifierAlgorithm.UserAgentMatch();
            this.userAgentClassifierAlgorithm.detect(v, uam);
            if (uam.category != null) {
                row.put(this.category, uam.category);
            }
            if (uam.type != null) {
                row.put(this.type, uam.type);
            }
            if (uam.brand != null) {
                row.put(this.brand, uam.brand);
            }
            if (uam.version != null) {
                row.put(this.version, uam.version);
            }
            if (uam.os != null) {
                row.put(this.os, uam.os);
            }
            if (uam.osVersion != null) {
                row.put(this.osVersion, uam.osVersion);
            }
            if (uam.osFlavor != null) {
                row.put(this.osFlavor, uam.osFlavor);
            }
        }

        public void postProcess() {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final String functionName = "userAgentClassifier_" + SecretKeyGenerator.generate();
        private final String inputColumn;

        private SnowflakeUDFSQLTranslator(String inputColumn) {
            this.inputColumn = inputColumn;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.typespecific.UserAgentClassifierUDF.process", "data STRING", "STRING", "ARRAY");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            String tmpColumnName = "USER_AGENT_CLASSIFIER_" + SecretKeyGenerator.generate((int)16);
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.inputColumn)) {
                chain = chain.makeSubquery();
            }
            chain.select(ebf.expr(String.format("%s(%s)", this.functionName, d.quoteIdentifier(this.inputColumn))), tmpColumnName);
            SQLQueryWithSchema outer = chain.makeSubquery();
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.inputColumn);
            List<String> outputColumns = OUTPUT_SUFFIXES;
            for (int i = 0; i < outputColumns.size(); ++i) {
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr(d.quoteIdentifier(tmpColumnName) + "[" + i + "]"), Type.STRING, this.inputColumn + outputColumns.get(i), false);
            }
            outer.deleteColumn(tmpColumnName);
            outer.deleteSelect(tmpColumnName);
            return outer;
        }
    }
}

