/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.services.smartdate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DateFormatGuesser {
    private static final String separatorsRegexp = StringUtils.join((Object[])new String[]{"[, /]", " +", "(?<! [+\\-][0-9]{2}):(?![0-9]{2}$)", "(?<! [+\\-][0-9]{2})(:)(?:[0-9]{2}$)", "[0-9]([T\\._])[0-9]", "(\\-)(?![0-9]{2}:?[0-9]{2}$)", "( ?)(?:[+\\-][0-9]{2}:?[0-9]{2}$)"}, (String)"|");
    private static final Pattern separators = Pattern.compile(separatorsRegexp);
    static Set<String> enDayNames = new HashSet<String>();
    private static final Replace[] frenchMonthReplaces;
    private static final Replace[] englishMonthReplaces;
    private static final Replace[] monthReplaces;
    private static final Set<String> allPossibleMonthNames;
    static Set<String> timezoneAbbreviations;
    static Set<String> amPmToken;
    private Map<String, DetectedFormat> formats = new HashMap<String, DetectedFormat>();
    private static Logger logger;

    static List<String> splitWithSeps(String str) {
        int lastMatch = 0;
        ArrayList<String> ret = new ArrayList<String>();
        Matcher m = separators.matcher(str);
        while (m.find()) {
            int startPos = m.start();
            int endPos = m.end();
            String val = m.group();
            for (int k = 1; k <= m.groupCount(); ++k) {
                if (m.group(k) == null) continue;
                startPos = m.start(k);
                endPos = m.end(k);
                val = m.group(k);
            }
            ret.add(str.substring(lastMatch, startPos));
            ret.add(val);
            lastMatch = endPos;
        }
        ret.add(str.substring(lastMatch));
        return ret;
    }

    void recurse(List<FormatChunk> prevCandidates, String format, List<String> chunks, int curIdx, boolean yearDone, boolean monthDone, boolean dayDone, boolean hoursDone, boolean minutesDone, boolean secondsDone) {
        FormatChunk newFormat = new FormatChunk(format);
        prevCandidates.add(newFormat);
        if (curIdx + 1 >= chunks.size()) {
            newFormat.end = true;
            return;
        }
        this.observeRec(newFormat.successors, chunks, curIdx + 1, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondsDone);
    }

    public static Set<String> getAllPossibleMonthNames() {
        return allPossibleMonthNames;
    }

    public static String translateMonthAndDay(String v) {
        return DateFormatGuesser.translateMonthAndDay(v, monthReplaces);
    }

    public static String translateFrenchMonthAndDay(String v) {
        return DateFormatGuesser.translateMonthAndDay(v, frenchMonthReplaces);
    }

    public static String translateEnglishMonthAndDay(String v) {
        return DateFormatGuesser.translateMonthAndDay(v, englishMonthReplaces);
    }

    private static String translateMonthAndDay(String v, Replace[] monthReplaces) {
        String lv = v.toLowerCase();
        block0: for (Replace r : monthReplaces) {
            for (String src : r.srcs) {
                if (!lv.contains(src)) continue;
                v = StringUtils.replace((String)v.toLowerCase(Locale.ENGLISH), (String)src.toLowerCase(Locale.ENGLISH), (String)r.dest);
                continue block0;
            }
        }
        return v;
    }

    void observeRec(List<FormatChunk> oCandidates, List<String> chunks, int curIdx, boolean yearDone, boolean monthDone, boolean dayDone, boolean hoursDone, boolean minutesDone, boolean secondDone) {
        int ic;
        int i;
        boolean ok;
        String c2 = chunks.get(curIdx);
        if (timezoneAbbreviations.contains(c2)) {
            this.recurse(oCandidates, "Z", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
        }
        if (c2.length() == 5 && (c2.charAt(0) == '+' || c2.charAt(0) == '-')) {
            ok = true;
            for (i = 1; i < 5; ++i) {
                if (c2.charAt(i) <= '9' && c2.charAt(i) >= '0') continue;
                ok = false;
            }
            if (ok) {
                this.recurse(oCandidates, "Z", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
        }
        if (c2.length() == 6 && (c2.charAt(0) == '+' || c2.charAt(0) == '-') && c2.charAt(3) == ':') {
            ok = true;
            for (i = 1; i < 6; ++i) {
                if (i == 3 || c2.charAt(i) <= '9' && c2.charAt(i) >= '0') continue;
                ok = false;
            }
            if (ok) {
                this.recurse(oCandidates, "Z", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
        }
        if (c2.length() > 0 && curIdx > 0 && chunks.get(curIdx - 1).equals(".") && StringUtils.isNumeric((String)c2) && hoursDone && minutesDone && secondDone && (ic = Integer.parseInt(c2)) >= 0 && ic <= 999) {
            if (c2.length() == 3) {
                this.recurse(oCandidates, "SSS", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            } else {
                this.recurse(oCandidates, "S", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
        }
        if (c2.length() <= 1) {
            if (c2.length() > 0 && StringUtils.isNumeric((String)c2)) {
                ic = Integer.parseInt(c2);
                if (!monthDone && ic > 0 && ic <= 12) {
                    this.recurse(oCandidates, "MM", chunks, curIdx, yearDone, true, dayDone, hoursDone, minutesDone, secondDone);
                }
                if (!dayDone && ic > 0 && ic <= 31) {
                    this.recurse(oCandidates, "dd", chunks, curIdx, yearDone, monthDone, true, hoursDone, minutesDone, secondDone);
                }
                if (!hoursDone && ic >= 0 && ic <= 23) {
                    this.recurse(oCandidates, "HH", chunks, curIdx, yearDone, monthDone, dayDone, true, minutesDone, secondDone);
                }
                if (hoursDone && !minutesDone && ic >= 0 && ic <= 60) {
                    this.recurse(oCandidates, "mm", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, true, secondDone);
                }
                if (minutesDone && !secondDone && ic >= 0 && ic <= 61) {
                    this.recurse(oCandidates, "ss", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, true);
                }
            } else if (c2.equals("T")) {
                this.recurse(oCandidates, "'T'", chunks, curIdx, true, true, true, hoursDone, minutesDone, secondDone);
            } else if (c2.equals(".") && hoursDone && minutesDone && secondDone) {
                this.recurse(oCandidates, ".", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, secondDone, secondDone);
            } else {
                this.recurse(oCandidates, c2, chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
            return;
        }
        if ((c2.length() == 6 || c2.length() == 9) && StringUtils.isNumeric((String)c2)) {
            this.recurse(oCandidates, "SSS", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
        }
        if (c2.length() == 4 && StringUtils.isNumeric((String)c2)) {
            if (!yearDone) {
                this.recurse(oCandidates, "yyyy", chunks, curIdx, true, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
        } else if (c2.length() == 2 && StringUtils.isNumeric((String)c2)) {
            ic = Integer.parseInt(c2);
            if (!yearDone) {
                this.recurse(oCandidates, "yy", chunks, curIdx, true, monthDone, dayDone, hoursDone, minutesDone, secondDone);
            }
            if (!monthDone && ic > 0 && ic <= 12) {
                this.recurse(oCandidates, "MM", chunks, curIdx, yearDone, true, dayDone, hoursDone, minutesDone, secondDone);
            }
            if (!dayDone && ic > 0 && ic <= 31) {
                this.recurse(oCandidates, "dd", chunks, curIdx, yearDone, monthDone, true, hoursDone, minutesDone, secondDone);
            }
            if (!hoursDone && ic >= 0 && ic <= 23) {
                this.recurse(oCandidates, "HH", chunks, curIdx, yearDone, monthDone, dayDone, true, minutesDone, secondDone);
            }
            if (hoursDone && !minutesDone && ic >= 0 && ic <= 60) {
                this.recurse(oCandidates, "mm", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, true, secondDone);
            }
            if (minutesDone && !secondDone && ic >= 0 && ic <= 61) {
                this.recurse(oCandidates, "ss", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, true);
            }
        } else if (DateFormatGuesser.getAllPossibleMonthNames().contains(c2) && !monthDone) {
            this.recurse(oCandidates, "MMM", chunks, curIdx, yearDone, true, dayDone, hoursDone, minutesDone, secondDone);
        } else if (c2.length() == 3 && enDayNames.contains(c2)) {
            this.recurse(oCandidates, "EEE", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
        } else if (c2.length() == 5 && (c2.charAt(0) == '+' || c2.charAt(0) == '-')) {
            this.recurse(oCandidates, "Z", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
        } else if (c2.length() == 2 && amPmToken.contains(c2)) {
            this.recurse(oCandidates, "a", chunks, curIdx, yearDone, monthDone, dayDone, hoursDone, minutesDone, secondDone);
        }
    }

    void collect(List<String> o, String curStr, FormatChunk curChk) {
        String newStr = curStr + curChk.pattern;
        if (curChk.successors.size() == 0 && curChk.end) {
            o.add(newStr);
        } else {
            for (FormatChunk next : curChk.successors) {
                this.collect(o, newStr, next);
            }
        }
    }

    public void addObservation(String observation) {
        int thirdParsed;
        int firstParsed;
        String first;
        int third;
        List<String> chunks = DateFormatGuesser.splitWithSeps(observation);
        for (int i = 0; i < chunks.size() - 2; ++i) {
            if (!chunks.get(i).equals(" ") || !chunks.get(i + 1).equals("") || !chunks.get(i + 2).equals("-")) continue;
            chunks.set(i + 3, "-" + chunks.get(i + 3));
            chunks.remove(i + 1);
            chunks.remove(i + 1);
        }
        logger.info((Object)("Adding observation : " + StringUtils.join(chunks, (String)"__")));
        ArrayList<FormatChunk> roots = new ArrayList<FormatChunk>();
        this.observeRec(roots, chunks, 0, false, false, false, false, false, false);
        ArrayList<String> candidates = new ArrayList<String>();
        for (FormatChunk root : roots) {
            this.collect(candidates, "", root);
        }
        if (observation.length() == 8 && StringUtils.isNumeric((String)observation)) {
            int first2 = Integer.parseInt(observation.substring(0, 4));
            int second = Integer.parseInt(observation.substring(4, 6));
            third = Integer.parseInt(observation.substring(6, 8));
            if (first2 < 3000 && second <= 12 && third <= 31) {
                candidates.add("yyyyMMdd");
            }
            if (first2 < 3000 && second <= 31 && third <= 12) {
                candidates.add("yyyyddMM");
            }
            first2 = Integer.parseInt(observation.substring(0, 2));
            second = Integer.parseInt(observation.substring(2, 4));
            third = Integer.parseInt(observation.substring(4, 8));
            if (first2 <= 31 && second <= 12 && third < 3000) {
                candidates.add("ddMMyyyy");
            }
            if (first2 <= 12 && second <= 31 && third < 3000) {
                candidates.add("MMddyyyy");
            }
        }
        if (observation.length() == 6 && StringUtils.isNumeric((String)observation)) {
            int first3 = Integer.parseInt(observation.substring(0, 2));
            int second = Integer.parseInt(observation.substring(2, 4));
            third = Integer.parseInt(observation.substring(4, 6));
            if (first3 <= 31 && second <= 12) {
                candidates.add("ddMMyy");
            }
            if (first3 <= 12 && second <= 31) {
                candidates.add("MMddyy");
            }
            if (second <= 12 && third <= 31) {
                candidates.add("yyMMdd");
            }
            if (second <= 31 && third <= 12) {
                candidates.add("yyddMM");
            }
        }
        if (observation.length() == 9) {
            first = observation.substring(0, 2);
            String second = observation.substring(2, 5);
            String third2 = observation.substring(5, 9);
            if (StringUtils.isNumeric((String)first) && DateFormatGuesser.getAllPossibleMonthNames().contains(second) && StringUtils.isNumeric((String)third2)) {
                firstParsed = Integer.parseInt(first);
                thirdParsed = Integer.parseInt(third2);
                if (firstParsed <= 31 && thirdParsed < 3000) {
                    candidates.add("ddMMMyyyy");
                }
            }
            first = observation.substring(0, 4);
            second = observation.substring(4, 7);
            third2 = observation.substring(7, 9);
            if (StringUtils.isNumeric((String)first) && DateFormatGuesser.getAllPossibleMonthNames().contains(second) && StringUtils.isNumeric((String)third2)) {
                firstParsed = Integer.parseInt(first);
                thirdParsed = Integer.parseInt(third2);
                if (firstParsed < 3000 && thirdParsed <= 31) {
                    candidates.add("yyyyMMMdd");
                }
            }
        }
        if (observation.length() == 7) {
            first = observation.substring(0, 2);
            String second = observation.substring(2, 5);
            String third3 = observation.substring(5, 7);
            if (StringUtils.isNumeric((String)first) && DateFormatGuesser.getAllPossibleMonthNames().contains(second) && StringUtils.isNumeric((String)third3)) {
                firstParsed = Integer.parseInt(first);
                thirdParsed = Integer.parseInt(third3);
                if (firstParsed <= 31) {
                    candidates.add("ddMMMyy");
                }
                if (thirdParsed <= 31) {
                    candidates.add("yyMMMdd");
                }
            }
        }
        if (observation.length() >= 15) {
            first = observation.substring(0, 8);
            String second = observation.substring(8, 9);
            String third4 = observation.substring(9, 15);
            if (StringUtils.isNumeric((String)first) && "T".equals(second) && StringUtils.isNumeric((String)third4)) {
                candidates.add("yyyyMMdd'T'HHmmss");
                candidates.add("yyyyMMdd'T'HHmmssSSS");
                candidates.add("yyyyMMdd'T'HHmmss.SSS");
                candidates.add("yyyyMMdd'T'HHmmssZ");
                candidates.add("yyyyMMdd'T'HHmmssSSSZ");
                candidates.add("yyyyMMdd'T'HHmmss.SSSZ");
            }
        }
        for (String candidate : candidates) {
            DetectedFormat df;
            if (candidate.indexOf(97) >= 0) {
                candidate = candidate.replace('H', 'h');
            }
            if ((df = this.formats.get(candidate)) == null) {
                df = this.createDetectedFormat(candidate);
                this.formats.put(candidate, df);
            }
            ++df.nbOK;
            logger.info((Object)("  --> Candidate " + candidate));
        }
    }

    private DetectedFormat createDetectedFormat(String candidate) {
        boolean standard;
        DetectedFormat df = new DetectedFormat();
        df.format = candidate;
        boolean stupidInversions = DateFormatGuesser.isBefore(candidate, "HH", "yy") || DateFormatGuesser.isBefore(candidate, "hh", "yy") || DateFormatGuesser.isBefore(candidate, "mm", "yy") || DateFormatGuesser.isBefore(candidate, "ss", "yy") || DateFormatGuesser.isBefore(candidate, "HH", "yyyy") || DateFormatGuesser.isBefore(candidate, "hh", "yyyy") || DateFormatGuesser.isBefore(candidate, "mm", "yyyy") || DateFormatGuesser.isBefore(candidate, "ss", "yyyy") || DateFormatGuesser.isBefore(candidate, "HH", "MM") || DateFormatGuesser.isBefore(candidate, "hh", "MM") || DateFormatGuesser.isBefore(candidate, "mm", "MM") || DateFormatGuesser.isBefore(candidate, "ss", "MM") || DateFormatGuesser.isBefore(candidate, "HH", "MMM") || DateFormatGuesser.isBefore(candidate, "hh", "MMM") || DateFormatGuesser.isBefore(candidate, "mm", "MMM") || DateFormatGuesser.isBefore(candidate, "ss", "MMM") || DateFormatGuesser.isBefore(candidate, "HH", "dd") || DateFormatGuesser.isBefore(candidate, "hh", "dd") || DateFormatGuesser.isBefore(candidate, "mm", "dd") || DateFormatGuesser.isBefore(candidate, "ss", "dd") || DateFormatGuesser.isBefore(candidate, "ss", "mm") || DateFormatGuesser.isBefore(candidate, "mm", "HH") || DateFormatGuesser.isBefore(candidate, "mm", "hh") || DateFormatGuesser.isBefore(candidate, "SSS", "ss") || DateFormatGuesser.isStrictlyBetween(candidate, "yy", "dd", "MM");
        boolean weirdlyMissing = DateFormatGuesser.hasAAndNotB(candidate, "MM", "yy") || DateFormatGuesser.hasAAndNotB(candidate, "dd", "MM") || DateFormatGuesser.hasAAndNotBNorC(candidate, "mm", "HH", "hh") || DateFormatGuesser.hasAAndNotBNorC(candidate, "ss", "HH", "hh") || DateFormatGuesser.hasAAndNotB(candidate, "ss", "mm") || DateFormatGuesser.hasAAndNotB(candidate, "SSS", "ss") || DateFormatGuesser.hasAAndNotB(candidate, "SSS", "mm") || DateFormatGuesser.hasAAndNotBNorC(candidate, "SSS", "HH", "hh");
        boolean bl = standard = candidate.equals("EEE, dd MMM yyyy HH:mm:ss Z") || candidate.equals("EEE MMM dd HH:mm:ss Z yyyy") || candidate.equals("yyyy-MM-dd HH:mm:ss") || candidate.equals("yyyy-dd-MM HH:mm:ss") || candidate.equals("yyyy-MM-dd") || candidate.equals("yyyy-dd-MM");
        df.trust = standard ? 2 : (stupidInversions || weirdlyMissing ? 0 : 1);
        return df;
    }

    private static boolean isBefore(String candidate, String a, String b) {
        return candidate.indexOf(a) >= 0 && candidate.indexOf(b) >= 0 && candidate.indexOf(a) < candidate.indexOf(b);
    }

    private static boolean isStrictlyBetween(String candidate, String a, String boundary1, String boundary2) {
        int posA = candidate.indexOf(a);
        int posBoundary1 = candidate.indexOf(boundary1);
        int posBoundary2 = candidate.indexOf(boundary2);
        return posA >= 0 && posBoundary1 >= 0 && posBoundary2 >= 0 && (posBoundary1 < posA && posA < posBoundary2 || posBoundary2 < posA && posA < posBoundary1);
    }

    private static boolean hasAAndNotB(String candidate, String a, String b) {
        return candidate.indexOf(a) >= 0 && candidate.indexOf(b) < 0;
    }

    private static boolean hasAAndNotBNorC(String candidate, String a, String b, String c2) {
        return candidate.indexOf(a) >= 0 && candidate.indexOf(b) < 0 && candidate.indexOf(c2) < 0;
    }

    public List<DetectedFormat> getResults() {
        ArrayList ret = Lists.newArrayList(this.formats.values());
        Collections.sort(ret);
        return ret;
    }

    public void clearObservation() {
        this.formats.clear();
    }

    public List<DetectedFormat> guess(List<String> observations) {
        for (String observation : observations) {
            this.addObservation(observation);
        }
        return this.getResults();
    }

    static {
        enDayNames.add("Mon");
        enDayNames.add("Tue");
        enDayNames.add("Wed");
        enDayNames.add("Thu");
        enDayNames.add("Fri");
        enDayNames.add("Sat");
        enDayNames.add("Sun");
        frenchMonthReplaces = new Replace[]{new Replace("Jan", "janvier", "janv.", "janv"), new Replace("Feb", "f\u00e9vrier", "fevr.", "f\u00e9vr.", "fev.", "f\u00e9v.", "fevr", "f\u00e9vr", "f\u00e9v", "fev"), new Replace("Mar", "mars", "mar.", "mar"), new Replace("Apr", "avril", "apr.", "avr.", "avr"), new Replace("May", "mai"), new Replace("Jun", "juin"), new Replace("Jul", "juillet", "juil.", "juil"), new Replace("Aug", "ao\u00fbt", "aout"), new Replace("Sep", "septembre", "sept."), new Replace("Oct", "octobre", "oct.", "oct"), new Replace("Nov", "novembre", "nov.", "nov"), new Replace("Dec", "d\u00e9cembre", "decembre", "dec.", "d\u00e9c.", "d\u00e9c", "dec")};
        englishMonthReplaces = new Replace[]{new Replace("Jan", "JAN"), new Replace("Feb", "FEB"), new Replace("Mar", "MAR"), new Replace("Apr", "APR"), new Replace("May", "MAY"), new Replace("Jun", "JUN"), new Replace("Jul", "JUL"), new Replace("Aug", "AUG"), new Replace("Sep", "SEP"), new Replace("Oct", "OCT"), new Replace("Nov", "NOV"), new Replace("Dec", "DEC")};
        monthReplaces = (Replace[])Stream.of(frenchMonthReplaces, englishMonthReplaces).flatMap(Arrays::stream).toArray(Replace[]::new);
        allPossibleMonthNames = new HashSet<String>();
        for (Replace r : monthReplaces) {
            allPossibleMonthNames.addAll(r.srcs);
            allPossibleMonthNames.add(r.dest);
        }
        timezoneAbbreviations = new HashSet<String>();
        for (String tz : new String[]{"ACDT", "ACST", "ACT", "ADT", "AEDT", "AEST", "AFT", "AKDT", "AKST", "AMST", "AMT", "ART", "AST", "AST", "AWDT", "AWST", "AZOST", "AZT", "BDT", "BIOT", "BIT", "BOT", "BRT", "BST", "BST", "BTT", "CAT", "CCT", "CDT", "CDT", "CEDT", "CEST", "CET", "CHADT", "CHAST", "CHOT", "ChST", "CHUT", "CIST", "CIT", "CKT", "CLST", "CLT", "COST", "COT", "CST", "CST", "CST", "CST", "CST", "CT", "CVT", "CWST", "CXT", "DAVT", "DDUT", "DFT", "EASST", "EAST", "EAT", "ECT", "ECT", "EDT", "EEDT", "EEST", "EET", "EGST", "EGT", "EIT", "EST", "EST", "FET", "FJT", "FKST", "FKT", "FNT", "GALT", "GAMT", "GET", "GFT", "GILT", "GIT", "GMT", "GST", "GST", "GYT", "HADT", "HAEC", "HAST", "HKT", "HMT", "HOVT", "HST", "ICT", "IDT", "IOT", "IRDT", "IRKT", "IRST", "IST", "IST", "IST", "JST", "KGT", "KOST", "KRAT", "KST", "LHST", "LHST", "LINT", "MAGT", "MART", "MAWT", "MDT", "MET", "MEST", "MHT", "MIST", "MIT", "MMT", "MSK", "MST", "MST", "MST", "MUT", "MVT", "MYT", "NCT", "NDT", "NFT", "NPT", "NST", "NT", "NUT", "NZDT", "NZST", "OMST", "ORAT", "PDT", "PET", "PETT", "PGT", "PHOT", "PHT", "PKT", "PMDT", "PMST", "PONT", "PST", "RET", "ROTT", "SAKT", "SAMT", "SAST", "SBT", "SCT", "SGT", "SLT", "SRT", "SST", "SST", "SYOT", "TAHT", "THA", "TFT", "TJT", "TKT", "TLT", "TMT", "TOT", "TVT", "UCT", "ULAT", "UTC", "UYST", "UYT", "UZT", "VET", "VLAT", "VOLT", "VOST", "VUT", "WAKT", "WAST", "WAT", "WEDT", "WEST", "WET", "WST", "YAKT", "YEKT"}) {
            timezoneAbbreviations.add(tz);
        }
        amPmToken = new HashSet<String>(Arrays.asList("AM", "PM"));
        logger = Logger.getLogger((String)"dku.shaker.dates");
    }

    static class FormatChunk {
        String pattern;
        boolean end;
        List<FormatChunk> successors = new ArrayList<FormatChunk>();

        FormatChunk(String pattern) {
            this.pattern = pattern;
        }
    }

    static class Replace {
        String dest;
        List<String> srcs = new ArrayList<String>();

        Replace(String dest, String ... src) {
            this.dest = dest;
            for (String s : src) {
                this.srcs.add(s);
            }
        }
    }

    public static class DetectedFormat
    implements Comparable<DetectedFormat> {
        public String format;
        int nbOK;
        int trust;

        @Override
        public int compareTo(DetectedFormat o) {
            if (this.nbOK < o.nbOK) {
                return 1;
            }
            if (this.nbOK > o.nbOK) {
                return -1;
            }
            if (this.trust < o.trust) {
                return 1;
            }
            if (this.trust > o.trust) {
                return -1;
            }
            return 0;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

