/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.shaker.processors.cleansing.FilterAndFlagOnBadType;
import com.dataiku.dip.shaker.sql.AbstractSqlFilterAndFlagOnSimpleCriteria;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.google.common.base.Preconditions;

public class SnowflakeUDFFilterAndFlagOnBadType
extends AbstractSqlFilterAndFlagOnSimpleCriteria {
    private final String udfName;

    public SnowflakeUDFFilterAndFlagOnBadType(SQLQueryWithSchema chain, FilterAndFlagOnBadType.Parameter parameter, String udfName) {
        super(chain, parameter);
        this.udfName = udfName;
    }

    @Override
    protected ExpressionBuilder exprFor(String column) {
        SQLDialect d = this.chain.getDialect();
        Preconditions.checkArgument((this.chain.getCurrentColumn(column) != null ? 1 : 0) != 0, (Object)("No schema column found for column " + column));
        return this.ebf.expr(String.format("%s(%s, %s)", this.udfName, d.quoteIdentifier(column), d.quoteString(this.getTypedParameter().type)));
    }

    private FilterAndFlagOnBadType.Parameter getTypedParameter() {
        return (FilterAndFlagOnBadType.Parameter)this.getTypedParams();
    }
}

