/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SparkJob {
    public String name;
    public List<String> nonSecretGlobalFiles = Lists.newArrayList();
    public List<String> secretDriverFiles = Lists.newArrayList();
    public List<String> pyFiles = Lists.newArrayList();
    public List<String> jars = Lists.newArrayList();
    public List<SimpleKeyValue> conf = Lists.newArrayList();
    public String file;
    public String className;
    public List<String> args = Lists.newArrayList();

    public boolean hasConfKey(String ... keys) {
        HashSet keysToTest = Sets.newHashSet((Object[])keys);
        for (SimpleKeyValue kv : this.conf) {
            if (!keysToTest.contains(kv.key)) continue;
            return true;
        }
        return false;
    }

    public String getConfValue(String key) {
        for (SimpleKeyValue kv : this.conf) {
            if (!StringUtils.equals((String)key, (String)kv.key)) continue;
            return kv.value;
        }
        return null;
    }

    public void addOrReplaceConfValue(SimpleKeyValue o) {
        for (SimpleKeyValue kv : this.conf) {
            if (!StringUtils.equals((String)o.key, (String)kv.key)) continue;
            kv.value = o.value;
            return;
        }
        this.conf.add(o);
    }

    public void removeConfValues(Set<String> keys) {
        ArrayList toRemove = Lists.newArrayList();
        for (SimpleKeyValue kv : this.conf) {
            if (!keys.contains(kv.key)) continue;
            toRemove.add(kv);
        }
        this.conf.removeAll(toRemove);
    }

    public List<SparkFilesList> getFileLists() {
        SparkFilesList secretFilesList = new SparkFilesList(){

            @Override
            public void set(List<String> files) {
                SparkJob.this.secretDriverFiles = files;
            }

            @Override
            public String name() {
                return "secret-driver-files";
            }

            @Override
            public List<String> get() {
                return SparkJob.this.secretDriverFiles;
            }
        };
        SparkFilesList nonSecretFiles = new SparkFilesList(){

            @Override
            public void set(List<String> files) {
                SparkJob.this.nonSecretGlobalFiles = files;
            }

            @Override
            public String name() {
                return "non-secret-global-files";
            }

            @Override
            public List<String> get() {
                return SparkJob.this.nonSecretGlobalFiles;
            }
        };
        SparkFilesList jarsList = new SparkFilesList(){

            @Override
            public void set(List<String> files) {
                SparkJob.this.jars = files;
            }

            @Override
            public String name() {
                return "jars";
            }

            @Override
            public List<String> get() {
                return SparkJob.this.jars;
            }
        };
        return Lists.newArrayList((Object[])new SparkFilesList[]{secretFilesList, nonSecretFiles, jarsList});
    }

    public static interface SparkFilesList {
        public String name();

        public List<String> get();

        public void set(List<String> var1);
    }
}

