/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.H2Connection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class H2V2SQLDialect
extends H2SQLDialect {
    public static final String DIALECT_ID = "H2V2";

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        if (schemaColumn.getType() == Type.DATE) {
            return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamp with time zone", new Integer[]{93, 91});
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if (sqlType == 93) {
            SchemaColumn col = new SchemaColumn(name, Type.DATETIMENOTZ);
            if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                col.setType(Type.DATE);
                col.withTimestampNoTzAsDate(true);
            } else if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                col.setType(Type.STRING);
            }
            return col;
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return "timestamp".equalsIgnoreCase(sqlTypeName);
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case DATE: {
                long timestamp = this.typeDate.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                ps2.setTimestamp(colIdx, new Timestamp(timestamp));
                break;
            }
            default: {
                super.fill(ps2, dssType, colIdx, dssStrVal);
            }
        }
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case 93: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : (Calendar)this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx, (Calendar)this.utcCalendar.get());
                    if (ts == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                }
                return rs2.getString(colIdx);
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    public boolean canSQL99() {
        return true;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.INNER_ONLY;
    }

    @Override
    public boolean isNaturalJoinImplicitlyInner() {
        return true;
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return 0x40000000;
    }

    @Override
    public String createCreateTableFromCsvStatementSQL(Dataset dataset, List<SchemaColumn> columns, String fileName, CSVFormatConfig csvConfig, String csvOpts) {
        List columnNames = columns.stream().map(SchemaColumn::getName).collect(Collectors.toList());
        List columnNamesQuoted = columnNames.stream().map(this::quoteIdentifier).collect(Collectors.toList());
        return this.getCreateTableStatementSQL(new H2Connection(), dataset, new InfoMessage.InfoMessages(), false) + " AS SELECT " + StringUtils.join(columnNamesQuoted, (char)',') + " FROM CSVREAD('" + fileName + "', '" + StringUtils.join(columnNames, (String)csvConfig.getSeparatorStr()) + "', '" + csvOpts + "')";
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        if (requestedType == Type.DATE) {
            if (exprType == Type.DATEONLY) {
                return "CAST(PARSEDATETIME(FORMATDATETIME(" + expr + ", 'yyyy-MM-dd'), 'yyyy-MM-dd', 'en', 'UTC' ) AS TIMESTAMP WITH TIME ZONE)";
            }
            if (exprType == Type.DATETIMENOTZ) {
                return "CAST(PARSEDATETIME(FORMATDATETIME(" + expr + ", 'yyyy-MM-dd HH:mm:ss'), 'yyyy-MM-dd HH:mm:ss', 'en', 'UTC' ) AS TIMESTAMP WITH TIME ZONE)";
            }
            return "(CAST(" + expr + " AS TIMESTAMP) AT TIME ZONE 'UTC')";
        }
        return super.cast(expr, exprType, requestedType, maxLength);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV_SAMP", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRANSLATE, QueryUtils.Arity.NARY){

            private String replace(String str, String x, String y) {
                return "REPLACE(" + str + ", " + H2V2SQLDialect.this.quoteString(x) + ", " + H2V2SQLDialect.this.quoteString(y) + ")";
            }

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String ret = this.toSQLNoBrackets(args[0]);
                String from = this.getParamAs(args[1], String.class);
                String to = this.getParamAs(args[2], String.class);
                for (int i = 0; i < from.length() && i < to.length(); ++i) {
                    ret = this.replace(ret, from.substring(i, i + 1), to.substring(i, i + 1));
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEDIFF, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                String end = this.toSQLNoBrackets(args[0]);
                String start = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = Type.DATE;
                if (args[0].outputType != null && args[0].outputType.dssType != null) {
                    type = args[0].outputType.dssType;
                }
                switch (unit) {
                    case "YEAR": 
                    case "MONTH": 
                    case "WEEK": 
                    case "DAY": 
                    case "HOUR": 
                    case "MINUTE": 
                    case "SECOND": {
                        String diffFunc;
                        String string = diffFunc = type == Type.DATEONLY ? "DATEDIFF" : "TIMESTAMPDIFF";
                        if (type == Type.DATE) {
                            return diffFunc + "(" + unit + ",(" + start + ") AT TIME ZONE 'UTC', (" + end + ") AT TIME ZONE 'UTC')";
                        }
                        return diffFunc + "(" + unit + "," + start + ", " + end + ")";
                    }
                }
                throw new QueryUtils.SQLGenerationException("Unknown datepart: '" + unit + "'");
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.SUBSTR, "SUBSTRING", QueryUtils.Arity.NARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LOG, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 1 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                double base = 10.0;
                String arg = this.toSQLNoBrackets(args[0]);
                if (args.length > 1) {
                    base = this.getParamAs(args[1], Double.class);
                }
                if (base == 2.0) {
                    return "LN(" + arg + ")";
                }
                return "LN(" + arg + ") / LN(" + base + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return H2V2SQLDialect.this.doQuoteDate(ret);
            }
        });
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_DATE, "CAST(", " AS DATE)"));
        this.addOperator(new GenericSQLDialect.SimpleUnaryFunction(QueryUtils.OperatorType.STRING_TO_TIMESTAMP, "CAST(", " AS TIMESTAMP)"));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                if (args.length > 2) {
                    return "CAST(PARSEDATETIME(FORMATDATETIME(" + this.toSQLNoBrackets(args[0]) + ", 'yyyy-MM-dd HH:mm:ss', 'en', " + this.toSQLNoBrackets(args[1]) + "), 'yyyy-MM-dd HH:mm:ss', 'en', " + this.toSQLNoBrackets(args[2]) + ") AS TIMESTAMP WITH TIME ZONE)";
                }
                if (args.length > 1 && args[1] != null) {
                    return "CAST(PARSEDATETIME(FORMATDATETIME(" + this.toSQLNoBrackets(args[0]) + ", 'yyyy-MM-dd HH:mm:ss', 'en', 'UTC'), 'yyyy-MM-dd HH:mm:ss', 'en', " + this.toSQLNoBrackets(args[1]) + ") AS TIMESTAMP WITH TIME ZONE)";
                }
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                return "DATEADD(" + unit + ", " + addIntLong + ", " + datetimeNoTz + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.PARSE, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    String sqlFormat = H2V2SQLDialect.this.toDateFormat(jodaFormat, true);
                    if (requestedType == Type.DATEONLY) {
                        return "CAST(PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', 'UTC') AS DATE)";
                    }
                    if (requestedType == Type.DATETIMENOTZ) {
                        return "CAST(PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', 'UTC') AS TIMESTAMP)";
                    }
                    return "PARSEDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FORMAT, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String input = this.toSQLNoBrackets(args[0]);
                Type requestedType = this.getParamAs(args[1], Type.class);
                if (requestedType.isTemporal()) {
                    this.validateMinNumberOfParameters(args, 3);
                    String jodaFormat = this.getParamAs(args[2], String.class);
                    Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                    String timezoneId = args.length > 4 ? this.getParamAs(args[4], String.class) : "UTC";
                    timezoneId = StringUtils.defaultIfBlank((String)timezoneId, (String)"UTC");
                    String sqlFormat = H2V2SQLDialect.this.toDateFormat(jodaFormat, false);
                    return "FORMATDATETIME(" + input + ",'" + sqlFormat + "', '" + locale.toString() + "', '" + timezoneId + "')";
                }
                throw new NotImplementedException("parse as not date");
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String input = this.toSQLNoBrackets(args[0]);
                String regex = this.toSQLNoBrackets(args[1]);
                return "REGEXP_LIKE(" + input + ", " + regex + ")";
            }
        });
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, true);
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        return this.temporalTrunc(inputDateExpression, rounding, false);
    }

    private String temporalTrunc(String inputDateExpression, DateRounding rounding, boolean isDateOnly) {
        switch (rounding) {
            case DAY: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd','en','UTC'), ' 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case HOUR: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH','en','UTC'), ':00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case MONTH: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM','en','UTC'), '-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case YEAR: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy','en','UTC'), '-01-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case MINUTE: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm','en','UTC'), ':00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case SECOND: {
                return "PARSEDATETIME(FORMATDATETIME(" + inputDateExpression + ", 'yyyy-MM-dd HH:mm:ss','en','UTC'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
            case WEEK: {
                String firstDayOfWeek = (isDateOnly ? "DATEADD" : "TIMESTAMPADD") + "(DAY, 1 - ISO_DAY_OF_WEEK(" + inputDateExpression + "), " + inputDateExpression + ")";
                return this.temporalTrunc(firstDayOfWeek, DateRounding.DAY, isDateOnly);
            }
            case QUARTER: {
                return "PARSEDATETIME(CONCAT(FORMATDATETIME(" + inputDateExpression + ", 'yyyy','en','UTC'), '-', DECODE(FORMATDATETIME(" + inputDateExpression + ", 'MM','en','UTC'),'01','01','02','01','03','01','04','04','05','04','06','04','07','07','08','07','09','07','10','10','11','10','12','10'), '-01 00:00:00'), 'yyyy-MM-dd HH:mm:ss','en','UTC')";
            }
        }
        throw new QueryUtils.SQLGenerationException("Rounding mode not implemented for H2:" + String.valueOf(rounding));
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, true);
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false);
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        return this.temporalPartExpression(inputDateExpression, part, false);
    }

    private String temporalPartExpression(String inputDateExpression, DatePart part, boolean isTzAware) {
        Object inputDateExpressionAtUTCIfNeeded = isTzAware ? "(" + inputDateExpression + ") AT TIME ZONE 'UTC'" : inputDateExpression;
        switch (part) {
            case DAY_OF_MONTH: {
                return "DAY_OF_MONTH(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case HOUR_OF_DAY: {
                return "HOUR(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case MINUTE_OF_HOUR: {
                return "MINUTE(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case SECOND_OF_MINUTE: {
                return "SECOND(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case MILLISECOND_OF_SECOND: {
                return "EXTRACT(MILLISECOND FROM " + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case MONTH_OF_YEAR: {
                return "MONTH(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case WEEK_OF_YEAR: {
                return "ISO_WEEK(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case QUARTER_OF_YEAR: {
                return "QUARTER(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case YEAR: {
                return "YEAR(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case DAY_OF_WEEK: {
                return "ISO_DAY_OF_WEEK(" + (String)inputDateExpressionAtUTCIfNeeded + ")";
            }
            case SECOND_FROM_EPOCH: {
                return "EXTRACT(EPOCH FROM " + inputDateExpression + ")";
            }
            case MILLIS_FROM_EPOCH: {
                return "(" + this.datePartExpression(inputDateExpression, DatePart.SECOND_FROM_EPOCH) + " * 1000 + " + this.datePartExpression(inputDateExpression, DatePart.MILLISECOND_OF_SECOND) + ")";
            }
        }
        throw new NotImplementedException(String.format("Date part '%s' is not supported on H2", part));
    }

    @Override
    public String quoteDate(String str) {
        return super.quoteDate(str);
    }

    @Override
    public String quoteDateOnly(String str) {
        return "CAST(" + this.quoteString(str) + " AS DATE)";
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return "CAST(" + this.quoteString(str) + " AS TIMESTAMP)";
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public int getIdentifiersMaxLength() {
        return -1;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return true;
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        Map<SQLAggregateType, SQLAggregateAbility> abilities = super.getAggregationAbilities();
        abilities.put(SQLAggregateType.CONCAT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.CONCAT_DISTINCT, new SQLAggregateAbility(true, true, true, true));
        return abilities;
    }

    @Override
    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        if (forParsing) {
            if (part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR) {
                return part.text.replace('x', 'Y');
            }
            if (part.type == DKUDateUtils.FormatPatternPartType.DAYOFWEEK && part.numeric) {
                return "F";
            }
            return part.text;
        }
        if (part.type == DKUDateUtils.FormatPatternPartType.TEXT) {
            Pattern toEscape = Pattern.compile("[a-zA-Z0-9\"]");
            if (toEscape.matcher(part.text).matches()) {
                return "'" + part.text.replace("'", "''") + "'";
            }
            return part.text;
        }
        return part.text;
    }

    @Override
    public String getId() {
        return DIALECT_ID;
    }
}

