/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AbstractQueryBuilder;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CreateIndexQueryBuilder
extends AbstractQueryBuilder {
    boolean unique;
    private final List<String> columns = new ArrayList<String>();
    private final String indexName;

    public static CreateIndexQueryBuilder createAnonymousIndex(SQLUtils.SQLTable table) {
        return new CreateIndexQueryBuilder(table, false);
    }

    public static CreateIndexQueryBuilder createAnonymousUniqueIndex(SQLUtils.SQLTable table) {
        return new CreateIndexQueryBuilder(table, true);
    }

    public static CreateIndexQueryBuilder createNamedIndex(SQLUtils.SQLTable table, String indexName) {
        return new CreateIndexQueryBuilder(table, indexName);
    }

    private CreateIndexQueryBuilder(SQLUtils.SQLTable table, boolean unique) {
        super(table);
        this.unique = unique;
        this.indexName = null;
    }

    private CreateIndexQueryBuilder(SQLUtils.SQLTable table, String indexName) {
        super(table);
        this.indexName = indexName;
    }

    @Override
    protected void assertBuilderIsValid() {
        super.assertBuilderIsValid();
        Preconditions.checkArgument((!this.columns.isEmpty() ? 1 : 0) != 0, (Object)"No columns selected to create index.");
    }

    @Override
    void buildSQLQueries() {
        assert (!(this.dialect instanceof MySQLDialect)) : "Anonymous index is Not supported for MySQL.";
        FluentIterable quotedColumns = FluentIterable.from(this.columns).transform(this.quoteColumns());
        String sql = String.format("CREATE%s INDEX%s ON %s (%s)", this.unique ? " UNIQUE" : "", this.indexName == null ? "" : " " + this.dialect.quoteIdentifier(this.indexName), this.dialect.getQuotedTableFullName(this.table), Joiner.on((String)", ").join((Iterable)quotedColumns));
        this.queries.add(sql);
    }

    public CreateIndexQueryBuilder addColumns(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public CreateIndexQueryBuilder addColumns(SchemaColumn ... columns) {
        for (SchemaColumn sc : columns) {
            this.columns.add(sc.getName());
        }
        return this;
    }

    public CreateIndexQueryBuilder addColumns(SchemaColumn[] ... columnGroups) {
        SchemaColumn[][] schemaColumnArray = columnGroups;
        int n = schemaColumnArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaColumn[] gr;
            for (SchemaColumn sc : gr = schemaColumnArray[i]) {
                this.columns.add(sc.getName());
            }
        }
        return this;
    }

    private Function<String, String> quoteColumns() {
        return new Function<String, String>(){

            public String apply(String column) {
                return CreateIndexQueryBuilder.this.dialect.quoteIdentifier(column);
            }
        };
    }
}

