/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class QueryAst {

    public static class CombinedTableLikes
    extends Expr
    implements TableLike {
        QuerySetOperator operator;
        List<TableLike> tables = new ArrayList<TableLike>();
        String alias;

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)((Object)this.operator), (Object)"Invalid operator to combine tables");
            Preconditions.checkNotNull(this.tables, (Object)"Tables not specified");
            for (TableLike t : this.tables) {
                Preconditions.checkNotNull((Object)t, (Object)"Null table");
                t.check();
            }
        }
    }

    public static enum QuerySetOperator {
        UNION("UNION"),
        UNION_ALL("UNION ALL"),
        INTERSECT("INTERSECT"),
        MINUS("MINUS");

        private String name;

        private QuerySetOperator(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class SelectQuery
    extends Expr
    implements TableLike {
        List<TableLike> with = new ArrayList<TableLike>();
        boolean distinct;
        List<SelectRef> selectList = new ArrayList<SelectRef>();
        TableLike from;
        List<JoinClause> join = new ArrayList<JoinClause>();
        List<Expr> where = new ArrayList<Expr>();
        List<Expr> having = new ArrayList<Expr>();
        List<OrderClause> orderBy = new ArrayList<OrderClause>();
        List<GroupClause> groupBy = new ArrayList<GroupClause>();
        Long limit;
        String comment;
        String alias;

        public SelectQuery shallowCopy() {
            SelectQuery ret = new SelectQuery();
            ret.with.addAll(this.with);
            ret.distinct = this.distinct;
            ret.selectList.addAll(this.selectList);
            ret.from = this.from;
            ret.join.addAll(this.join);
            ret.where.addAll(this.where);
            ret.having.addAll(this.having);
            ret.orderBy.addAll(this.orderBy);
            ret.groupBy.addAll(this.groupBy);
            ret.limit = this.limit;
            ret.comment = this.comment;
            ret.alias = this.alias;
            return ret;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void check() {
            if (this.with != null) {
                for (TableLike tableLike : this.with) {
                    Preconditions.checkNotNull((Object)tableLike, (Object)"CTE (in WITH clause) not specified");
                    tableLike.check();
                }
            }
            if (this.selectList != null) {
                for (SelectRef selectRef : this.selectList) {
                    if (selectRef == null) continue;
                    selectRef.check();
                }
            }
            if (this.from != null) {
                this.from.check();
            }
            if (this.join != null) {
                for (JoinClause joinClause : this.join) {
                    Preconditions.checkNotNull((Object)joinClause, (Object)"Null JOIN condition");
                    joinClause.check();
                }
            }
            if (this.where != null) {
                for (Expr expr : this.where) {
                    Preconditions.checkNotNull((Object)expr, (Object)"Null WHERE condition");
                    expr.check();
                }
            }
            if (this.having != null) {
                for (Expr expr : this.having) {
                    Preconditions.checkNotNull((Object)expr, (Object)"Null HAVING condition");
                    expr.check();
                }
            }
            if (this.orderBy != null) {
                for (OrderClause orderClause : this.orderBy) {
                    if (orderClause == null) continue;
                    orderClause.check();
                }
            }
            if (this.groupBy != null) {
                for (GroupClause groupClause : this.groupBy) {
                    if (groupClause == null) continue;
                    groupClause.check();
                }
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            super.visit(visitor);
            if (this.selectList != null) {
                for (SelectRef selectRef : this.selectList) {
                    selectRef.visit(visitor);
                }
            }
            if (this.join != null) {
                for (JoinClause joinClause : this.join) {
                    joinClause.visit(visitor);
                }
            }
            if (this.where != null) {
                for (Expr expr : this.where) {
                    expr.visit(visitor);
                }
            }
            if (this.having != null) {
                for (Expr expr : this.having) {
                    expr.visit(visitor);
                }
            }
            if (this.orderBy != null) {
                for (OrderClause orderClause : this.orderBy) {
                    orderClause.visit(visitor);
                }
            }
            if (this.groupBy != null) {
                for (GroupClause groupClause : this.groupBy) {
                    groupClause.visit(visitor);
                }
            }
        }
    }

    public static interface WithComment {
        public String getComment();
    }

    public static interface TableLike {
        public String getAlias();

        public void check();
    }

    static class SelectRef
    extends Node {
        Expr expr;
        int index;
        String alias;

        SelectRef() {
        }

        @Override
        public void check() {
            if (this.expr != null) {
                this.expr.check();
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
            this.expr.visit(visitor);
        }
    }

    public static class SampleClause
    extends Node {
        public SamplingParam.SamplingMethod samplingMethod;
        public Double ratio;
        public Long rows;
        public Long seed;

        public static SampleClause sampleClause(DatasetSelection selection) {
            return SampleClause.sampleClause(selection.samplingMethod, selection.maxRecords, selection.targetRatio, selection.seed);
        }

        public static SampleClause sampleClause(ExtractionLimit limit) {
            return SampleClause.sampleClause(limit.samplingMethod, limit.maxRecords, limit.samplingRatio, limit.samplingSeed);
        }

        private static SampleClause sampleClause(SamplingParam.SamplingMethod samplingMethod, long maxRecords, double ratio, Long seed) {
            switch (samplingMethod) {
                case RANDOM_FIXED_NB: 
                case RANDOM_FIXED_NB_EXACT: {
                    return SampleClause.sampleOfRows(maxRecords, seed);
                }
                case RANDOM_FIXED_RATIO: 
                case RANDOM_FIXED_RATIO_EXACT: {
                    return SampleClause.sampleOfRatio(ratio, seed);
                }
            }
            return null;
        }

        public static SampleClause sampleOfRatio(double ratio, Long seed) {
            SampleClause sample = new SampleClause();
            sample.samplingMethod = SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
            sample.ratio = ratio;
            sample.seed = seed;
            return sample;
        }

        public static SampleClause sampleOfRows(long rows, Long seed) {
            SampleClause sample = new SampleClause();
            sample.samplingMethod = SamplingParam.SamplingMethod.RANDOM_FIXED_NB;
            sample.rows = rows;
            sample.seed = seed;
            return sample;
        }

        @Override
        public void check() {
            switch (this.samplingMethod) {
                case RANDOM_FIXED_RATIO: 
                case RANDOM_FIXED_RATIO_EXACT: {
                    Preconditions.checkNotNull((Object)this.ratio);
                    break;
                }
                case RANDOM_FIXED_NB: 
                case RANDOM_FIXED_NB_EXACT: {
                    Preconditions.checkNotNull((Object)this.rows);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to use sampling method " + String.valueOf(this.samplingMethod));
                }
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
        }
    }

    static class GroupClause
    extends Node {
        Expr expr;

        GroupClause() {
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)this.expr, (Object)"Group by clause not specified");
            this.expr.check();
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
            this.expr.visit(visitor);
        }
    }

    public static class OrderClause
    extends Node {
        Expr expr;
        OrderType orderType = OrderType.ASC;
        OrderType nullOrder;

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)this.expr, (Object)"Order by clause not specified");
            this.expr.check();
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
            this.expr.visit(visitor);
        }
    }

    static class JoinClause
    extends Node {
        JoinType type;
        TableLike tableLike;
        List<Expr> on = new ArrayList<Expr>();
        String operatorBetweenConditions = "AND";

        JoinClause() {
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Invalid join Type");
            Preconditions.checkNotNull((Object)this.tableLike, (Object)"Table to join with not specified");
            this.tableLike.check();
            if (this.on != null) {
                for (Expr c2 : this.on) {
                    c2.check();
                }
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
            if (this.on != null) {
                for (Expr item : this.on) {
                    item.visit(visitor);
                }
            }
        }
    }

    public static class Window
    extends Node {
        public static final ConstExpr UNBOUNDED = new ConstExpr(null);
        public static final ConstExpr CURRENT = new ConstExpr(0);
        List<Expr> partitionExpressions;
        List<Expr> orderExpressions;
        List<OrderType> orderTypes;
        WindowFrameMode frameMode;
        String frameStart;
        private WindowFrameDirection frameStartDirection = WindowFrameDirection.PRECEDING;
        String frameEnd;
        private WindowFrameDirection frameEndDirection = WindowFrameDirection.FOLLOWING;
        WindowRecipePayloadParams.DateDiffUnit dateDiffUnit;

        WindowFrameDirection getFrameStartDirection() {
            if (this.frameStartDirection != null) {
                return this.frameStartDirection;
            }
            return WindowFrameDirection.PRECEDING;
        }

        WindowFrameDirection getFrameEndDirection() {
            if (this.frameEndDirection != null) {
                return this.frameEndDirection;
            }
            return WindowFrameDirection.FOLLOWING;
        }

        public Window partitionBy(Expr ... exprs) {
            if (this.partitionExpressions == null) {
                this.partitionExpressions = new ArrayList<Expr>();
            }
            for (Expr expr : exprs) {
                this.partitionExpressions.add(expr);
            }
            return this;
        }

        public Window orderBy(Expr ... exprs) {
            if (this.orderExpressions == null) {
                this.orderExpressions = new ArrayList<Expr>();
            }
            for (Expr expr : exprs) {
                this.orderExpressions.add(expr);
            }
            return this;
        }

        public Window withFrame(WindowFrameMode frameMode, String start, WindowFrameDirection startDirection, String end, WindowFrameDirection endDirection, WindowRecipePayloadParams.DateDiffUnit dateDiffUnit) {
            this.frameMode = frameMode;
            this.frameStart = start;
            this.frameStartDirection = startDirection;
            this.frameEnd = end;
            this.frameEndDirection = endDirection;
            this.dateDiffUnit = dateDiffUnit;
            return this;
        }

        public boolean isOrdered() {
            return this.orderExpressions != null && this.orderExpressions.size() > 0;
        }

        @Override
        public void check() {
            if (this.partitionExpressions != null) {
                for (Expr p : this.partitionExpressions) {
                    Preconditions.checkNotNull((Object)p, (Object)"Null partition expression");
                    p.check();
                }
            }
            if (this.orderExpressions != null) {
                for (Expr p : this.orderExpressions) {
                    Preconditions.checkNotNull((Object)p, (Object)"Null order expression");
                    p.check();
                }
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
            if (this.partitionExpressions != null) {
                for (Expr item : this.partitionExpressions) {
                    item.visit(visitor);
                }
            }
            if (this.orderExpressions != null) {
                for (Expr item : this.orderExpressions) {
                    item.visit(visitor);
                }
            }
        }
    }

    public static enum WindowFrameDirection {
        PRECEDING,
        FOLLOWING;

    }

    public static enum WindowFrameMode {
        RANGE,
        ROWS;

    }

    static class InlineQuery
    extends Expr
    implements TableLike {
        String sql;
        String alias;
        List<String> columnNames;

        public InlineQuery(String sql, String alias) {
            this.sql = sql;
            this.alias = alias;
        }

        public InlineQuery(String inlineQuery, List<String> columnNames, String alias) {
            assert (inlineQuery != null);
            this.sql = inlineQuery;
            this.alias = alias;
            this.columnNames = columnNames;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)StringUtils.isNotBlank((String)this.sql), (Object)"Inline query is not specified");
            if (this.columnNames != null) {
                for (String cn : this.columnNames) {
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)cn), (Object)"Empty column names for inline query");
                }
            }
        }
    }

    public static class TableVariableReference
    implements TableLike,
    WithComment {
        private final String var;
        private final String comment;

        public TableVariableReference(String var, String comment) {
            this.var = var;
            this.comment = comment;
        }

        public String getVar() {
            return this.var;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getAlias() {
            return this.var;
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)this.var, (Object)"Table variable reference not specified");
        }
    }

    static class Table
    extends Identifier
    implements TableLike {
        String catalog;
        String schema;
        String name;
        String alias;
        SampleClause sample;

        public Table(String catalog, String schema, String name, String alias, SampleClause sample) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.alias = alias;
            this.sample = sample;
        }

        public Table(String catalog, String schema, String name, String alias) {
            this(catalog, schema, name, alias, null);
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public void check() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"Table name is not specified");
            if (this.sample != null) {
                this.sample.check();
            }
        }
    }

    public static class Column
    extends Identifier {
        TableLike table;
        String name;

        Column(TableLike table, String name) {
            this.table = table;
            this.name = name;
        }

        Column(String column) {
            this.name = column;
        }

        Column(String column, Type dssType) {
            this.name = column;
            this.withExprType(dssType);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void check() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.name), (Object)"Column name is not specified");
            if (this.table != null) {
                this.table.check();
            }
        }
    }

    static abstract class Identifier
    extends Expr {
        Identifier() {
        }
    }

    public static class Comment
    extends Expr {
        public String value;

        public Comment(String comment) {
            this.value = comment;
        }

        @Override
        public void check() {
        }
    }

    public static class InlineExpr
    extends Expr {
        public String expr;
        public Map<String, Window> windows;

        public InlineExpr(String expr) {
            this.expr = expr;
        }

        public InlineExpr withWindow(String windowId, Window window) {
            if (this.windows == null) {
                this.windows = new HashMap<String, Window>();
            }
            this.windows.put(windowId, window);
            return this;
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)this.expr, (Object)"Inline SQL expression not specified");
            if (this.windows != null) {
                for (Window window : this.windows.values()) {
                    Preconditions.checkNotNull((Object)window, (Object)"Window not specified");
                    window.check();
                }
            }
        }
    }

    public static class ListExpr
    extends Expr {
        List<Expr> items;

        public ListExpr(List<Expr> items) {
            this.items = items;
        }

        @Override
        public void check() {
            Preconditions.checkNotNull(this.items, (Object)"List items are not specified");
            for (Expr item : this.items) {
                if (item == null) continue;
                item.check();
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            super.visit(visitor);
            for (Expr item : this.items) {
                item.visit(visitor);
            }
        }

        public List<Expr> getItems() {
            return this.items;
        }
    }

    public static class CaseExpr
    extends Expr {
        List<WhenItem> items = new ArrayList<WhenItem>();
        Expr elseValue;

        public CaseExpr(CaseExpr other, List<Expr> vargs) {
            this.items.addAll(other.items);
            this.elseValue = other.elseValue;
            for (int i = 0; i < vargs.size() / 2; ++i) {
                this.items.add(new WhenItem(vargs.get(2 * i), vargs.get(2 * i + 1)));
            }
            if (vargs.size() % 2 == 1) {
                this.elseValue = vargs.get(vargs.size() - 1);
            }
        }

        public CaseExpr(List<Expr> vargs) {
            for (int i = 0; i < vargs.size() / 2; ++i) {
                this.items.add(new WhenItem(vargs.get(2 * i), vargs.get(2 * i + 1)));
            }
            if (vargs.size() % 2 == 1) {
                this.elseValue = vargs.get(vargs.size() - 1);
            }
        }

        @Override
        public void check() {
            Preconditions.checkNotNull(this.items, (Object)"No items in the CASE WHEN clause.");
            for (WhenItem item : this.items) {
                if (item == null) {
                    throw new IllegalArgumentException("Empty item in CASE WHEN clause");
                }
                if (item.when == null) {
                    throw new IllegalArgumentException("NULL condition in item from CASE WHEN clause");
                }
                item.when.check();
                if (item.then == null) continue;
                item.then.check();
            }
        }

        @Override
        public void visit(NodeVisitor visitor) {
            super.visit(visitor);
            for (WhenItem item : this.items) {
                if (item.when != null) {
                    item.when.visit(visitor);
                }
                if (item.then == null) continue;
                item.then.visit(visitor);
            }
        }

        static class WhenItem {
            final Expr when;
            final Expr then;

            WhenItem(Expr when, Expr then) {
                this.when = when;
                this.then = then;
            }
        }
    }

    public static class ConstExpr
    extends Expr {
        public Object value;

        public ConstExpr(Object value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstExpr other = (ConstExpr)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public void check() {
        }
    }

    public static class OperatorExpr
    extends Expr {
        public QueryUtils.OperatorType op;
        public List<Expr> args;
        public Window window;

        public OperatorExpr() {
        }

        public OperatorExpr(OperatorExpr expr) {
            this.op = expr.op;
            this.args = Lists.newArrayList(expr.args);
            this.window = expr.window;
        }

        public OperatorExpr(QueryUtils.OperatorType op, Expr ... args) {
            this.op = op;
            this.args = Lists.newArrayList((Object[])args);
        }

        @Override
        public void check() {
            Preconditions.checkNotNull((Object)((Object)this.op), (Object)"Operator type not specified");
        }

        @Override
        public void visit(NodeVisitor visitor) {
            super.visit(visitor);
            for (Expr arg : this.args) {
                arg.visit(visitor);
            }
        }
    }

    public static abstract class Expr
    extends Node {
        public ExprType outputType = new ExprType();

        @Override
        public void visit(NodeVisitor visitor) {
            visitor.handle(this);
        }

        public Expr withExprType(Type dssType) {
            this.outputType.dssType = dssType;
            return this;
        }

        public Expr useCurrentTZForQuoteDate(boolean b) {
            this.outputType.useCurrentTZForQuoteDate = b;
            return this;
        }
    }

    public static class ExprType {
        public Type dssType;
        public boolean useCurrentTZForQuoteDate;
    }

    static abstract class Node {
        Node() {
        }

        public abstract void check();

        public abstract void visit(NodeVisitor var1);
    }

    static interface NodeVisitor {
        public void handle(Node var1);
    }

    public static enum BaseType {
        STRING,
        DATE,
        NUMBER,
        BOOL,
        UNKNOWN;

    }

    public static enum OrderType {
        ASC,
        DESC;

    }

    public static enum JoinType {
        INNER(true),
        LEFT(true),
        RIGHT(true),
        FULL(true),
        CROSS(false),
        NATURAL_INNER(false),
        NATURAL_LEFT(false),
        NATURAL_RIGHT(false),
        NATURAL_FULL(false);

        public final boolean requiresOnClause;

        private JoinType(boolean requiresOnClause) {
            this.requiresOnClause = requiresOnClause;
        }
    }
}

