/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kdbplustick;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.kdbplustick.KDBPlusTickStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;

public class KDBPlusTickStreamingEndpointMeta
extends StreamingEndpointMeta {
    public static final String TYPE = "kdbplustick";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass() {
        return KDBPlusTickStreamingEndpointParams.class;
    }

    @Override
    public StreamingEndpointSimpleWriter getSimpleWriter(AuthCtx authCtx, StreamingEndpoint targetSE, ColumnFactory cf, WarningsContext warningsContext) {
        throw new Error("KDB+Tick endpoint does not support write");
    }

    @Override
    public StreamingEndpointSimplePuller getSimplePuller(AuthCtx authCtx, StreamingEndpoint sourceSE, boolean nonConsuming) {
        return null;
    }

    @Override
    public StreamingEndpoint create(StreamingEndpointService.StreamingEndpointProto proto) throws InstantiationException, IllegalAccessException {
        StreamingEndpoint se = super.create(proto);
        se.schema = new Schema();
        return se;
    }

    @Override
    public void fillManagedParams(StreamingEndpoint se, DSSConnection connection, String formatOptionId) {
        throw new UnsupportedOperationException("Cannot write to KDB+Tick endpoints");
    }

    @Override
    public void fillCopyParams(StreamingEndpoint se) {
    }

    @Override
    public void checkUsability(AuthCtx authCtx, StreamingEndpoint se) throws DKUSecurityException {
    }

    @Override
    public <T extends StreamingEndpoint.StreamingEndpointParams> T getExpandedParams(String projectKey, StreamingEndpoint se, Class<T> clazz) {
        KDBPlusTickStreamingEndpointParams params = (KDBPlusTickStreamingEndpointParams)JSON.deepCopy((Object)se.getParamsAs(KDBPlusTickStreamingEndpointParams.class));
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(projectKey);
        vc.add("projectKey", se.projectKey);
        vc.add("seId", se.id);
        params.tableName = vc.expand(params.tableName);
        return (T)((StreamingEndpoint.StreamingEndpointParams)clazz.cast(params));
    }
}

